/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.friendlies;

import com.shim.celestialexploration.entity.client.dispatchers.CobblesaurusDispatcher;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialTags;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class Cobblesaurus
extends Animal
implements PlayerRideable {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(CelestialTags.Items.COBBLESAURUS_FOOD);
    private static final Predicate<LivingEntity> PARENT_SELECTOR = p_30636_ -> p_30636_ instanceof Cobblesaurus && ((Cobblesaurus)((Object)p_30636_)).isBred();
    private static final TargetingConditions MOMMY_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26888_(PARENT_SELECTOR);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(Cobblesaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER_UUID = SynchedEntityData.m_135353_(Cobblesaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final int FLAG_TAME = 2;
    private static final int FLAG_SADDLE = 4;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_SLOT_ARMOR = 1;
    public static final int INV_BASE_COUNT = 2;
    private int eatingCounter;
    private int standCounter;
    public int sprintCounter;
    protected SimpleContainer inventory;
    protected int temper;
    private boolean allowStandSliding;
    private float eatAnim;
    private float eatAnimO;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    public final CobblesaurusDispatcher dispatcher;
    private final MoveAnalysis moveAnalysis;
    private LazyOptional<?> itemHandler = null;

    public Cobblesaurus(EntityType<? extends Cobblesaurus> p_30531_, Level p_30532_) {
        super(p_30531_, p_30532_);
        this.f_19793_ = 1.0f;
        this.dispatcher = new CobblesaurusDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, Cobblesaurus.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, FOOD_ITEMS, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_OWNER_UUID, Optional.empty());
    }

    protected boolean getFlag(int p_30648_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & p_30648_) != 0;
    }

    protected void setFlag(int p_30598_, boolean p_30599_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (p_30599_) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | p_30598_)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~p_30598_)));
        }
    }

    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ID_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_30587_) {
        this.f_19804_.m_135381_(DATA_ID_OWNER_UUID, Optional.ofNullable(p_30587_));
    }

    public void setTamed(boolean p_30652_) {
        this.setFlag(2, p_30652_);
    }

    protected void m_7880_(float p_30660_) {
        if (p_30660_ > 6.0f && this.isEating()) {
            this.setEating(false);
        }
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean p_30658_) {
        this.setFlag(8, p_30658_);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int p_30650_) {
        this.temper = p_30650_;
    }

    public int modifyTemper(int p_30654_) {
        int i = Mth.m_14045_((int)(this.getTemper() + p_30654_), (int)0, (int)this.getMaxTemper());
        this.setTemper(i);
        return i;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    private void eating() {
        SoundEvent soundevent;
        if (!this.m_20067_() && (soundevent = this.getEatingSound()) != null) {
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        }
    }

    public boolean m_142535_(float p_149499_, float p_149500_, DamageSource p_149501_) {
        int i;
        if (p_149499_ > 1.0f) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(p_149499_, p_149500_)) <= 0) {
            return false;
        }
        this.m_6469_(p_149501_, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(p_149501_, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected int m_5639_(float p_30606_, float p_30607_) {
        return Mth.m_14167_((float)((p_30606_ * 0.5f - 3.0f) * p_30607_));
    }

    protected int getInventorySize() {
        return 2;
    }

    @Nullable
    protected SoundEvent getEatingSound() {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_30609_) {
        if (this.f_19796_.nextInt(3) == 0) {
            this.stand();
        }
        return null;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.f_19796_.nextInt(10) == 0 && !this.m_6107_()) {
            this.stand();
        }
        return null;
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        this.stand();
        return null;
    }

    protected void m_7355_(BlockPos p_30584_, BlockState p_30585_) {
        if (!p_30585_.m_60767_().m_76332_()) {
            BlockState blockstate = this.f_19853_.m_8055_(p_30584_.m_7494_());
            SoundType soundtype = p_30585_.getSoundType((LevelReader)this.f_19853_, p_30584_, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.f_19853_, p_30584_, (Entity)this);
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (soundtype == SoundType.f_56736_) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    protected void playGallopSound(SoundType p_30560_) {
        this.m_5496_(SoundEvents.f_11977_, p_30560_.m_56773_() * 0.15f, p_30560_.m_56774_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 73.0).m_22268_(Attributes.f_22279_, 0.125);
    }

    public int m_5792_() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public int m_8100_() {
        return 400;
    }

    public InteractionResult fedFood(Player p_30581_, ItemStack p_30582_) {
        boolean flag = this.handleEating(p_30581_, p_30582_);
        if (!p_30581_.m_150110_().f_35937_) {
            p_30582_.m_41774_(1);
        }
        if (this.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected boolean handleEating(Player p_30593_, ItemStack p_30594_) {
        boolean flag = false;
        float health = 3.0f;
        int i = 60;
        int j = 3;
        if (this.m_21223_() < this.m_21233_() && health > 0.0f) {
            this.m_5634_(health);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.f_19853_.f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.isTamed()) && this.getTemper() < this.getMaxTemper()) {
            flag = true;
            if (!this.f_19853_.f_46443_) {
                this.modifyTemper(j);
            }
        }
        if (flag) {
            this.eating();
            this.m_146859_(GameEvent.f_157806_, this.m_146901_());
        }
        return flag;
    }

    protected void doPlayerRide(Player p_30634_) {
        this.setEating(false);
        this.setStanding(false);
        if (!this.f_19853_.f_46443_) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_((Entity)this);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_() && this.isEating() || this.isStanding();
    }

    public boolean m_6898_(ItemStack p_30644_) {
        return FOOD_ITEMS.test(p_30644_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.f_19796_.nextInt(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEating() && !this.m_20160_() && this.f_19796_.nextInt(300) == 0 && this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60713_(Blocks.f_50440_)) {
                    this.setEating(true);
                }
                if (this.isEating() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEating(false);
                }
            }
            this.followMommy();
        }
    }

    protected void followMommy() {
        LivingEntity livingentity;
        if (this.isBred() && this.m_6162_() && !this.isEating() && (livingentity = this.f_19853_.m_45963_(AbstractHorse.class, MOMMY_TARGETING, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142469_().m_82400_(16.0))) != null && this.m_20280_((Entity)livingentity) > 4.0) {
            this.f_21344_.m_6570_((Entity)livingentity, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.moveAnalysis.update();
        if (this.f_19853_.m_5776_()) {
            boolean isMovingOnGround;
            boolean bl = isMovingOnGround = this.moveAnalysis.isMovingHorizontally() && this.m_20096_();
            if (isMovingOnGround) {
                this.dispatcher.walk();
            } else {
                this.dispatcher.idle();
            }
        }
        if ((this.m_6109_() || this.m_6142_()) && this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
            this.setStanding(false);
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.eatAnimO = this.eatAnim;
        if (this.isEating()) {
            this.eatAnim += (1.0f - this.eatAnim) * 0.4f + 0.05f;
            if (this.eatAnim > 1.0f) {
                this.eatAnim = 1.0f;
            }
        } else {
            this.eatAnim += (0.0f - this.eatAnim) * 0.4f - 0.05f;
            if (this.eatAnim < 0.0f) {
                this.eatAnim = 0.0f;
            }
        }
        this.standAnimO = this.standAnim;
        if (this.isStanding()) {
            this.eatAnimO = this.eatAnim = 0.0f;
            this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
            if (this.standAnim > 1.0f) {
                this.standAnim = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
            if (this.standAnim < 0.0f) {
                this.standAnim = 0.0f;
            }
        }
        this.mouthAnimO = this.mouthAnim;
        if (this.getFlag(64)) {
            this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
            if (this.mouthAnim > 1.0f) {
                this.mouthAnim = 1.0f;
            }
        } else {
            this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
            if (this.mouthAnim < 0.0f) {
                this.mouthAnim = 0.0f;
            }
        }
    }

    public void setEating(boolean p_30662_) {
        this.setFlag(16, p_30662_);
    }

    public void setStanding(boolean p_30666_) {
        if (p_30666_) {
            this.setEating(false);
        }
        this.setFlag(32, p_30666_);
    }

    private void stand() {
        if (this.m_6109_() || this.m_6142_()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    public void makeMad() {
        if (!this.isStanding()) {
            this.stand();
            SoundEvent soundevent = this.getAngrySound();
            if (soundevent != null) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
        }
    }

    public boolean tameWithName(Player p_30638_) {
        this.setOwnerUUID(p_30638_.m_142081_());
        this.setTamed(true);
        if (p_30638_ instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)p_30638_, (Animal)this);
        }
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        return true;
    }

    public void m_7023_(Vec3 p_30633_) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_5807_()) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.gallopSoundCounter = 0;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, p_30633_.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_21043_((LivingEntity)this, false);
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(p_30633_);
            }
        }
    }

    protected void playJumpSound() {
        this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
    }

    public void m_7380_(CompoundTag p_30589_) {
        super.m_7380_(p_30589_);
        p_30589_.m_128379_("EatingHaystack", this.isEating());
        p_30589_.m_128379_("Bred", this.isBred());
        p_30589_.m_128405_("Temper", this.getTemper());
        p_30589_.m_128379_("Tame", this.isTamed());
        if (this.getOwnerUUID() != null) {
            p_30589_.m_128362_("Owner", this.getOwnerUUID());
        }
    }

    public void m_7378_(CompoundTag p_30565_) {
        UUID uuid;
        super.m_7378_(p_30565_);
        this.setEating(p_30565_.m_128471_("EatingHaystack"));
        this.setBred(p_30565_.m_128471_("Bred"));
        this.setTemper(p_30565_.m_128451_("Temper"));
        this.setTamed(p_30565_.m_128471_("Tame"));
        if (p_30565_.m_128403_("Owner")) {
            uuid = p_30565_.m_128342_("Owner");
        } else {
            String s = p_30565_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    protected boolean canParent() {
        return !this.m_20160_() && !this.m_20159_() && this.isTamed() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof LivingEntity;
    }

    protected void spawnTamingParticles(boolean p_30670_) {
        SimpleParticleType particleoptions = p_30670_ ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte p_30541_) {
        if (p_30541_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_30541_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(p_30541_);
        }
    }

    public void m_7332_(Entity p_30642_) {
        super.m_7332_(p_30642_);
        if (p_30642_ instanceof Mob) {
            Mob mob = (Mob)p_30642_;
            this.f_20883_ = mob.f_20883_;
        }
        if (this.standAnimO > 0.0f) {
            float f3 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.standAnimO;
            float f2 = 0.15f * this.standAnimO;
            p_30642_.m_6034_(this.m_20185_() + (double)(f1 * f3), this.m_20186_() + this.m_6048_() + p_30642_.m_6049_() + (double)f2, this.m_20189_() - (double)(f1 * f));
            if (p_30642_ instanceof LivingEntity) {
                ((LivingEntity)p_30642_).f_20883_ = this.f_20883_;
            }
        }
    }

    protected float generateRandomMaxHealth() {
        return 15.0f + (float)this.f_19796_.nextInt(8) + (float)this.f_19796_.nextInt(9);
    }

    protected double generateRandomJumpStrength() {
        return (double)0.4f + this.f_19796_.nextDouble() * 0.2 + this.f_19796_.nextDouble() * 0.2 + this.f_19796_.nextDouble() * 0.2;
    }

    protected double generateRandomSpeed() {
        return ((double)0.45f + this.f_19796_.nextDouble() * 0.3 + this.f_19796_.nextDouble() * 0.3 + this.f_19796_.nextDouble() * 0.3) * 0.25;
    }

    public boolean m_6147_() {
        return false;
    }

    protected float m_6431_(Pose p_30578_, EntityDimensions p_30579_) {
        return p_30579_.f_20378_ * 0.95f;
    }

    public boolean canWearArmor() {
        return false;
    }

    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isArmor(ItemStack p_30645_) {
        return false;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 p_30562_, LivingEntity p_30563_) {
        double d0 = this.m_20185_() + p_30562_.f_82479_;
        double d1 = this.m_142469_().f_82289_;
        double d2 = this.m_20189_() + p_30562_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_30563_.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_142469_().f_82292_ + 0.75;
            do {
                Vec3 vec3;
                AABB aabb;
                double d4 = this.f_19853_.m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4) && DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)p_30563_, (AABB)(aabb = p_30563_.m_21270_(pose)).m_82383_(vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2)))) {
                    p_30563_.m_20124_(pose);
                    return vec3;
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity p_30576_) {
        Vec3 vec3 = Cobblesaurus.m_19903_((double)this.m_20205_(), (double)p_30576_.m_20205_(), (float)(this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, p_30576_);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = Cobblesaurus.m_19903_((double)this.m_20205_(), (double)p_30576_.m_20205_(), (float)(this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, p_30576_);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    protected void randomizeAttributes() {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30555_, DifficultyInstance p_30556_, MobSpawnType p_30557_, @Nullable SpawnGroupData p_30558_, @Nullable CompoundTag p_30559_) {
        if (p_30558_ == null) {
            p_30558_ = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        this.randomizeAttributes();
        return super.m_6518_(p_30555_, p_30556_, p_30557_, p_30558_, p_30559_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public InteractionResult m_6071_(Player p_30713_, InteractionHand p_30714_) {
        ItemStack itemstack = p_30713_.m_21120_(p_30714_);
        if (!this.m_6162_() && this.m_20160_()) {
            return super.m_6071_(p_30713_, p_30714_);
        }
        if (!itemstack.m_41619_()) {
            if (itemstack.m_204117_(CelestialTags.Items.COBBLESAURUS_FOOD)) {
                return this.fedFood(p_30713_, itemstack);
            }
            InteractionResult interactionresult = itemstack.m_41647_(p_30713_, (LivingEntity)this, p_30714_);
            if (interactionresult.m_19077_()) {
                return interactionresult;
            }
            if (!this.isTamed()) {
                this.makeMad();
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(p_30713_, p_30714_);
        }
        this.doPlayerRide(p_30713_);
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean m_7848_(Animal p_30698_) {
        if (!(p_30698_ instanceof Cobblesaurus)) {
            return false;
        }
        return this.canParent() && ((Cobblesaurus)p_30698_).canParent();
    }

    public AgeableMob m_142606_(ServerLevel p_149533_, AgeableMob p_149534_) {
        return (AgeableMob)((EntityType)CelestialEntities.COBBLESAURUS.get()).m_20615_((Level)p_149533_);
    }
}

