/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.mob;

import com.shim.celestialexploration.entity.client.dispatchers.SimpleEntityDispatcher;
import java.util.EnumSet;
import java.util.Random;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Orbiter
extends Ghast {
    public final SimpleEntityDispatcher dispatcher;
    private final MoveAnalysis moveAnalysis;

    public Orbiter(EntityType<? extends Orbiter> p_32725_, Level p_32726_) {
        super(p_32725_, p_32726_);
        this.f_21342_ = new OrbiterMoveControl(this);
        this.dispatcher = new SimpleEntityDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public static AttributeSupplier.Builder m_32752_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 100.0);
    }

    public static boolean checkSpawnRules(EntityType<Orbiter> p_32735_, LevelAccessor p_32736_, MobSpawnType p_32737_, BlockPos p_32738_, Random p_32739_) {
        return p_32736_.m_46791_() != Difficulty.PEACEFUL && p_32739_.nextInt(20) == 0 && Orbiter.m_21400_(p_32735_, (LevelAccessor)p_32736_, (MobSpawnType)p_32737_, (BlockPos)p_32738_, (Random)p_32739_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new OrbiterLookGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new OrbiterShootFireballGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.dispatcher.idle();
        }
    }

    static class OrbiterMoveControl
    extends MoveControl {
        private final Orbiter ghast;
        private int floatDuration;

        public OrbiterMoveControl(Orbiter p_32768_) {
            super((Mob)p_32768_);
            this.ghast = p_32768_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.m_21187_().nextInt(5) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.ghast.m_20185_(), this.f_24976_ - this.ghast.m_20186_(), this.f_24977_ - this.ghast.m_20189_());
                double d0 = vec3.m_82553_();
                if (this.canReach(vec3 = vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.ghast.m_20256_(this.ghast.m_20184_().m_82549_(vec3.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_32771_, int p_32772_) {
            AABB aabb = this.ghast.m_142469_();
            for (int i = 1; i < p_32772_; ++i) {
                if (this.ghast.f_19853_.m_45756_((Entity)this.ghast, aabb = aabb.m_82383_(p_32771_))) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final Orbiter ghast;

        public RandomFloatAroundGoal(Orbiter p_32783_) {
            this.ghast = p_32783_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movecontrol = this.ghast.m_21566_();
            if (!movecontrol.m_24995_()) {
                return true;
            }
            double d0 = movecontrol.m_25000_() - this.ghast.m_20185_();
            double d3 = d0 * d0 + (d1 = movecontrol.m_25001_() - this.ghast.m_20186_()) * d1 + (d2 = movecontrol.m_25002_() - this.ghast.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Random random = this.ghast.m_21187_();
            double d0 = this.ghast.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.ghast.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.ghast.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.ghast.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class OrbiterLookGoal
    extends Goal {
        private final Orbiter ghast;

        public OrbiterLookGoal(Orbiter p_32762_) {
            this.ghast = p_32762_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.ghast.m_5448_() == null) {
                Vec3 vec3 = this.ghast.m_20184_();
                this.ghast.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.ghast.f_20883_ = this.ghast.m_146908_();
            } else {
                LivingEntity livingentity = this.ghast.m_5448_();
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.ghast.m_20185_();
                    double d2 = livingentity.m_20189_() - this.ghast.m_20189_();
                    this.ghast.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.ghast.f_20883_ = this.ghast.m_146908_();
                }
            }
        }
    }

    static class OrbiterShootFireballGoal
    extends Goal {
        private final Orbiter ghast;
        public int chargeTime;

        public OrbiterShootFireballGoal(Orbiter p_32776_) {
            this.ghast = p_32776_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.ghast.m_32758_(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            if (livingentity != null) {
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 4096.0 && this.ghast.m_142582_((Entity)livingentity)) {
                    Level level = this.ghast.f_19853_;
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.ghast.m_20067_()) {
                        level.m_5898_((Player)null, 1015, this.ghast.m_142538_(), 0);
                    }
                    if (this.chargeTime == 20) {
                        double d1 = 4.0;
                        Vec3 vec3 = this.ghast.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vec3.f_82479_ * 4.0);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.ghast.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vec3.f_82481_ * 4.0);
                        if (!this.ghast.m_20067_()) {
                            level.m_5898_((Player)null, 1016, this.ghast.m_142538_(), 0);
                        }
                        LargeFireball largefireball = new LargeFireball(level, (LivingEntity)this.ghast, d2, d3, d4, this.ghast.m_32751_());
                        largefireball.m_6034_(this.ghast.m_20185_() + vec3.f_82479_ * 4.0, this.ghast.m_20227_(0.5) + 0.5, largefireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)largefireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ghast.m_32758_(this.chargeTime > 10);
            }
        }
    }
}

