/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.mob.slimes;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCelestialSlime
extends Slime {
    final ParticleOptions slimeParticles;

    public AbstractCelestialSlime(EntityType<? extends Slime> entityType, Level level, ParticleOptions slimeParticles) {
        super(entityType, level);
        this.slimeParticles = slimeParticles;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 3.0).m_22265_();
    }

    protected ParticleOptions m_6300_() {
        return this.slimeParticles;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33601_, DifficultyInstance p_33602_, MobSpawnType p_33603_, @Nullable SpawnGroupData p_33604_, @Nullable CompoundTag p_33605_) {
        return super.m_6518_(p_33601_, p_33602_, p_33603_, p_33604_, p_33605_);
    }

    public static boolean checkCelestialSlimeSpawnRules(EntityType<? extends AbstractCelestialSlime> slime, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (random.nextInt() > 5) {
            return false;
        }
        if (level.m_45517_(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        return AbstractCelestialSlime.m_21400_(slime, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

