/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.projectile;

import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.projectile.AbstractDirectionalProjectile;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MeteorProjectile
extends AbstractDirectionalProjectile {
    final int MAX_LIFESPAN;
    int lifeSpan;
    float defaultMovementSpeed = 0.06f;
    float currentYMovementSpeed = this.defaultMovementSpeed / 3.0f;
    float currentZMovementSpeed = this.defaultMovementSpeed;

    public MeteorProjectile(EntityType<? extends AbstractDirectionalProjectile> entityTypeIn, Level levelIn) {
        super(entityTypeIn, levelIn);
        this.lifeSpan = this.MAX_LIFESPAN = 15 + new Random().nextInt(10);
    }

    @Override
    public void m_8119_() {
        HitResult hitresult;
        super.m_8119_();
        --this.lifeSpan;
        if (this.lifeSpan <= 0) {
            this.m_146870_();
        }
        if ((hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitresult);
            this.explode();
        }
        this.m_20101_();
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        Vec3 currentMovement = this.m_20184_();
        this.m_20334_(currentMovement.f_82479_ + this.f_19853_.m_5822_().nextDouble(0.5) - 0.25, currentMovement.f_82480_ - (double)this.currentYMovementSpeed - this.f_19853_.m_5822_().nextDouble(0.3), currentMovement.f_82481_ + (double)this.currentZMovementSpeed + this.f_19853_.m_5822_().nextDouble(0.3));
        double d0 = this.m_20185_() + currentMovement.f_82479_;
        double d1 = this.m_20186_() + currentMovement.f_82480_;
        double d2 = this.m_20189_() + currentMovement.f_82481_;
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 1.0, d2 - 1.0, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 1.25, d2 - 1.25, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 1.5, d2 - 1.5, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 1.75, d2 - 1.75, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 2.0, d2 - 2.0, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 2.25, d2 - 2.25, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 2.5, d2 - 2.5, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 2.75, d2 - 2.75, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 3.0, d2 - 3.0, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)CelestialParticles.SHOOTING_STAR_PARTICLE.get(), d0, d1 + 3.25, d2 - 3.25, 0.0, 0.0, 0.0);
    }

    private void calculateArc() {
        if (this.lifeSpan >= this.MAX_LIFESPAN / 3 * 2) {
            this.currentYMovementSpeed = this.defaultMovementSpeed - 0.05f;
            this.currentZMovementSpeed = this.defaultMovementSpeed + 0.05f;
        } else if (this.lifeSpan < this.MAX_LIFESPAN / 3 * 2 && this.lifeSpan > this.MAX_LIFESPAN / 3) {
            this.currentYMovementSpeed = this.defaultMovementSpeed;
            this.currentZMovementSpeed = this.defaultMovementSpeed;
        } else {
            this.currentYMovementSpeed = this.defaultMovementSpeed + 0.05f;
            this.currentZMovementSpeed = this.defaultMovementSpeed - 0.05f;
        }
    }

    private void explode() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = (Boolean)CelestialCommonConfig.METEORS_EXPLODE.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            explosion$blockinteraction = this.f_19853_.m_5822_().nextInt(3) == 0 ? Explosion.BlockInteraction.NONE : explosion$blockinteraction;
            float explosion = this.f_19853_.m_5822_().nextFloat(7.5f) - 4.0f;
            explosion = explosion < 0.0f ? 0.0f : explosion;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosion, explosion$blockinteraction);
            if (explosion > 2.5f && this.f_19853_.f_46441_.nextInt(16) == 0) {
                if (this.f_19853_.m_8055_(new BlockPos(this.m_20182_()).m_7495_()).m_60795_()) {
                    this.f_19853_.m_7731_(new BlockPos(this.m_20182_()).m_7495_(), ((Block)CelestialBlocks.METEOR.get()).m_49966_(), 1);
                } else if (this.f_19853_.m_8055_(new BlockPos(this.m_20182_()).m_6625_(2)).m_60795_()) {
                    this.f_19853_.m_7731_(new BlockPos(this.m_20182_()).m_7495_(), ((Block)CelestialBlocks.METEOR.get()).m_49966_(), 1);
                } else if (this.f_19853_.m_8055_(new BlockPos(this.m_20182_()).m_6625_(3)).m_60795_()) {
                    this.f_19853_.m_7731_(new BlockPos(this.m_20182_()).m_7495_(), ((Block)CelestialBlocks.METEOR.get()).m_49966_(), 1);
                } else if (this.f_19853_.m_8055_(new BlockPos(this.m_20182_()).m_6625_(4)).m_60795_()) {
                    this.f_19853_.m_7731_(new BlockPos(this.m_20182_()).m_7495_(), ((Block)CelestialBlocks.METEOR.get()).m_49966_(), 1);
                }
            }
            this.m_146870_();
        }
    }

    @Override
    public boolean m_20068_() {
        return true;
    }
}

