/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.robots;

import com.shim.celestialexploration.entity.mob.Gust;
import com.shim.celestialexploration.entity.robots.AbstractCerberus;
import com.shim.celestialexploration.entity.robots.MechaDog;
import com.shim.celestialexploration.registry.CelestialEffects;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialParticles;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mod.azure.azurelib.ai.pathing.AzureNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MechaCerberusBoss
extends AbstractCerberus
implements Enemy {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private static final int INVULNERABLE_TICKS = 100;
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int lightningAttackCooldown = 800;
    int lightningTick;
    static final int LIGHTNING_MIN_COOLDOWN = 140;
    static final int LIGHTNING_MAX_COOLDOWN = 800;
    static final int MAX_MINION_COOLDOWN = 500;
    static final int STATIC_CAP = 50;
    static final int PLAYER_CAP = 5;
    int summonMinionsTick;
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int chargingTick;
    static final int MAX_CHARGE_TIME = 280;
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGED = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_STUNNED = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_SUMMONED = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGE_ENDING = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int checkStaticCooldown;
    int modifyStrategyTick;
    public static final Predicate<Entity> IS_PLAYER = entity -> entity instanceof Player;
    static final int MAX_STATIC_DURATION = 500;
    static final int MIN_STATIC_DURATION = 200;
    private static final EntityDataAccessor<Boolean> DATA_IS_HOWLING = SynchedEntityData.m_135353_(MechaCerberusBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Predicate<Entity> IS_TAMED_MECHADOG = entity -> {
        if (entity instanceof MechaDog) {
            MechaDog dog = (MechaDog)entity;
            return dog.m_21824_();
        }
        return entity.m_6084_();
    };

    public MechaCerberusBoss(EntityType<? extends MechaCerberusBoss> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.m_7105_(false);
        this.chargingTick = 0;
        this.summonMinionsTick = 400;
        this.checkStaticCooldown = 0;
        this.lightningTick = 0;
        this.setCharged(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AbstractCerberus.CerberusPanicGoal(1.5));
        this.f_21345_.m_25352_(3, new AbstractCerberus.CerberusAvoidEntityGoal<Gust>(this, Gust.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new CerberusMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ChargeUpForAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CerberusLightningAOEAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new StunByAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonMinionsGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> {
            if (entity instanceof MechaDog) {
                MechaDog dog = (MechaDog)entity;
                return entity.m_6084_() && dog.m_21824_();
            }
            return entity.m_6084_();
        }));
    }

    public boolean isHowling() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_HOWLING);
    }

    public void setHowling(boolean isHowling) {
        this.f_19804_.m_135381_(DATA_IS_HOWLING, (Object)isHowling);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean isCharging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)isCharging);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGED);
    }

    public void setCharged(boolean isCharged) {
        this.f_19804_.m_135381_(DATA_IS_CHARGED, (Object)isCharged);
    }

    public boolean isChargeEnding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGE_ENDING);
    }

    public void setChargeEnding(boolean isCharging) {
        this.f_19804_.m_135381_(DATA_CHARGE_ENDING, (Object)isCharging);
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_STUNNED);
    }

    public void setStunned(boolean isStunned) {
        this.f_19804_.m_135381_(DATA_IS_STUNNED, (Object)isStunned);
    }

    public boolean isSummoned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SUMMONED);
    }

    public void setSummoned() {
        this.f_19804_.m_135381_(DATA_IS_SUMMONED, (Object)true);
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (!this.isStunned()) {
            return SoundEvents.f_12625_;
        }
        return SoundEvents.f_12621_;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        Entity attacker;
        if (this.isHowling()) {
            return false;
        }
        if (!this.isStunned()) {
            damage *= 0.25f;
        }
        if (this.isCharging() && !this.isCharged()) {
            this.setStunned(true);
        }
        if ((attacker = source.m_7639_()) instanceof Player) {
            Player player = (Player)attacker;
            if (player.m_21023_((MobEffect)CelestialEffects.STATIC_EFFECT.get())) {
                int amplifier = player.m_21124_((MobEffect)CelestialEffects.STATIC_EFFECT.get()).m_19564_();
                if (amplifier >= 9) {
                    if (player.m_21124_((MobEffect)CelestialEffects.STATIC_EFFECT.get()).m_19557_() < 180) {
                        player.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.STATIC_EFFECT.get(), 200, 9));
                    }
                } else {
                    int duration = 500 - (amplifier + 1) * 10;
                    if (player.m_21124_((MobEffect)CelestialEffects.STATIC_EFFECT.get()).m_19557_() < duration - 40) {
                        player.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.STATIC_EFFECT.get(), duration, amplifier + 1));
                    }
                }
            } else {
                player.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.STATIC_EFFECT.get(), 500));
            }
        }
        return super.m_6469_(source, damage);
    }

    @Override
    protected Runnable getAnimation() {
        boolean isMovingOnGround;
        if (this.isHowling()) {
            return this.dispatcher::howl;
        }
        if (this.isStunned()) {
            return this.dispatcher::stun;
        }
        if (this.isCharged()) {
            return this.dispatcher::chargeAttack;
        }
        if (this.isCharging()) {
            if (this.isChargeEnding()) {
                return this.dispatcher::chargeUpEnd;
            }
            return this.dispatcher::chargeUp;
        }
        boolean bl = isMovingOnGround = this.moveAnalysis.isMovingHorizontally() && this.f_19861_;
        if (isMovingOnGround) {
            return this.dispatcher::walk;
        }
        return this.dispatcher::idle;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (!(!(this.bossEvent.m_142717_() < 1.0f) || !(this.bossEvent.m_142717_() > 0.0f) || this.isCharging() && this.isCharged() && this.isStunned())) {
                ++this.summonMinionsTick;
            }
            ++this.lightningTick;
            ++this.checkStaticCooldown;
            if (this.checkStaticCooldown == 20) {
                this.checkStaticCooldown = 0;
                this.lightningAttackCooldown = (int)(660.0f * (this.m_21223_() / this.m_21233_()) + 140.0f);
                if (this.lightningTick >= this.lightningAttackCooldown - 80) {
                    this.summonMinionsTick = 501;
                }
            }
        }
    }

    public void makeInvulnerable() {
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Invul", this.getInvulnerableTicks());
        nbt.m_128405_("lightningAttackCooldown", this.lightningAttackCooldown);
        nbt.m_128405_("lightningTick", this.lightningTick);
        nbt.m_128405_("summonMinionsCooldown", this.summonMinionsTick);
        nbt.m_128379_("isCharging", this.isCharging());
        nbt.m_128405_("chargingTime", this.chargingTick);
        nbt.m_128379_("isCharged", this.isCharged());
        nbt.m_128379_("isStunned", this.isStunned());
        nbt.m_128379_("isHowling", this.isHowling());
        nbt.m_128379_("chargeEnd", this.isChargeEnding());
        nbt.m_128405_("checkStaticCooldown", this.checkStaticCooldown);
        nbt.m_128405_("modifyStrategyTick", this.modifyStrategyTick);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setInvulnerableTicks(nbt.m_128451_("Invul"));
        if (this.m_8077_() && !this.m_21824_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (nbt.m_128441_("lightningAttackCooldown")) {
            this.lightningAttackCooldown = nbt.m_128451_("lightningAttackCooldown");
        }
        if (nbt.m_128441_("lightningTick")) {
            this.lightningTick = nbt.m_128451_("lightningTick");
        }
        if (nbt.m_128441_("summonMinionsCooldown")) {
            this.summonMinionsTick = nbt.m_128451_("summonMinionsCooldown");
        }
        if (nbt.m_128441_("isCharging")) {
            this.setCharging(nbt.m_128471_("isCharging"));
        }
        if (nbt.m_128441_("chargingTime")) {
            this.chargingTick = nbt.m_128451_("chargingTime");
        }
        if (nbt.m_128441_("isCharged")) {
            this.setCharged(nbt.m_128471_("isCharged"));
        }
        if (nbt.m_128441_("isStunned")) {
            this.setStunned(nbt.m_128471_("isStunned"));
        }
        if (nbt.m_128441_("isHowling")) {
            this.setHowling(nbt.m_128471_("isHowling"));
        }
        if (nbt.m_128441_("chargeEnd")) {
            this.setChargeEnding(nbt.m_128471_("chargeEnd"));
        }
        if (nbt.m_128441_("checkStaticCooldown")) {
            this.checkStaticCooldown = nbt.m_128451_("checkStaticCooldown");
        }
        if (nbt.m_128441_("modifyStrategyTick")) {
            this.modifyStrategyTick = nbt.m_128451_("modifyStrategyTick");
        }
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int p_31511_) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)p_31511_);
    }

    public void m_6593_(@Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        if (!this.m_21824_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6457_(ServerPlayer p_31483_) {
        if (!this.m_21824_()) {
            this.bossEvent.m_6543_(p_31483_);
        }
    }

    public void m_6452_(ServerPlayer p_31488_) {
        if (!this.m_21824_()) {
            this.bossEvent.m_6539_(p_31488_);
        }
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.isSummoned()) {
            int i = 1200;
            if ((this.f_19797_ + this.m_142049_()) % 800 == 0) {
                MobEffect mobeffect = MobEffects.f_19599_;
                List list = ((ServerLevel)this.f_19853_).m_8795_(p_32465_ -> this.m_20280_((Entity)p_32465_) < 2500.0 && p_32465_.f_8941_.m_9294_());
                int j = 2;
                int k = 6000;
                int l = 1200;
                for (ServerPlayer serverplayer : list) {
                    if (serverplayer.m_21023_(mobeffect) && serverplayer.m_21124_(mobeffect).m_19564_() >= 2 && serverplayer.m_21124_(mobeffect).m_19557_() >= 1200) continue;
                    serverplayer.m_147207_(new MobEffectInstance(mobeffect, 6000, 2), (Entity)this);
                }
            }
            if (!this.m_21536_()) {
                this.m_21446_(this.m_142538_(), 16);
            }
        }
    }

    public boolean m_6573_(Player p_21813_) {
        return false;
    }

    @Override
    public void m_7105_(boolean p_30443_) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 1.5);
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)0);
        this.f_19804_.m_135372_(DATA_IS_HOWLING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CHARGED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_STUNNED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_SUMMONED, (Object)false);
        this.f_19804_.m_135372_(DATA_CHARGE_ENDING, (Object)false);
    }

    public static class CerberusMeleeAttackGoal
    extends MeleeAttackGoal {
        public CerberusMeleeAttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            super(p_25552_, p_25553_, p_25554_);
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.f_25540_.m_20205_() * 1.5f * this.f_25540_.m_20205_() * 1.5f + p_25556_.m_20205_();
        }
    }

    public static class ChargeUpForAttackGoal
    extends Goal {
        MechaCerberusBoss boss;
        boolean stunned;
        float MAX_CHARGE;

        public ChargeUpForAttackGoal(MechaCerberusBoss mechaCerberus) {
            this.boss = mechaCerberus;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.boss.isCharged()) {
                return false;
            }
            if (this.boss.lightningTick < this.boss.lightningAttackCooldown) {
                return false;
            }
            if (this.boss.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            this.MAX_CHARGE = Math.min(280.0f * (this.boss.m_21223_() / this.boss.m_21233_()), 93.333336f);
            return (float)this.boss.chargingTick <= this.MAX_CHARGE;
        }

        public boolean m_8045_() {
            if (this.boss.isStunned()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            ((AzureNavigation)this.boss.m_21573_()).hardStop();
            if (this.boss.f_19853_.m_5776_()) {
                this.boss.dispatcher.chargeUp();
            }
            this.boss.setCharging(true);
            this.stunned = false;
        }

        public void m_8041_() {
            this.boss.setCharged(!this.boss.isStunned());
            this.boss.setChargeEnding(false);
            this.boss.setCharging(false);
            this.boss.chargingTick = 0;
            this.boss.lightningTick = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (!this.stunned) {
                ++this.boss.chargingTick;
            }
        }
    }

    public static class CerberusLightningAOEAttackGoal
    extends Goal {
        MechaCerberusBoss boss;
        int lengthTick = 0;

        public CerberusLightningAOEAttackGoal(MechaCerberusBoss mechaCerberus) {
            this.boss = mechaCerberus;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.boss.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            List nearbyPlayers = this.boss.f_19853_.m_6249_((Entity)this.boss, this.boss.m_142469_().m_82400_(40.0), EntitySelector.f_20406_.and(Entity::m_6087_).and(EntitySelector.f_20403_).and(IS_PLAYER));
            if (nearbyPlayers.isEmpty()) {
                return false;
            }
            return this.boss.isCharged() && !this.boss.isStunned();
        }

        public boolean m_8045_() {
            if (this.lengthTick > 30) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            ((AzureNavigation)this.boss.m_21573_()).hardStop();
            SoundEvent soundevent = this.boss.getChargeAttackSound();
            if (soundevent != null) {
                this.boss.m_5496_(soundevent, this.boss.m_6121_() + 0.1f, this.boss.m_6100_());
            }
            if (!this.boss.f_19853_.m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)this.boss.f_19853_;
                int arcLength = 20;
                for (int i = 0; i < 360; i += arcLength) {
                    Vec3 angle = this.getParticleDirection(i);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.boss.m_20182_().m_7096_(), this.boss.m_20182_().m_7098_() + 1.5, this.boss.m_20182_().m_7094_(), 0, angle.m_7096_(), 0.0, angle.m_7094_(), (double)0.91f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.boss.m_20182_().m_7096_() + 0.1, this.boss.m_20182_().m_7098_() + 1.5, this.boss.m_20182_().m_7094_(), 0, angle.m_7096_(), 0.0, angle.m_7094_(), (double)0.91f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.boss.m_20182_().m_7096_(), this.boss.m_20182_().m_7098_() + 1.5, this.boss.m_20182_().m_7094_() + 0.1, 0, angle.m_7096_(), 0.0, angle.m_7094_(), (double)0.91f);
                }
            }
            super.m_8056_();
        }

        private void waveAttack(float radius) {
            List nearbyEntities = this.boss.f_19853_.m_6249_((Entity)this.boss, this.boss.m_142469_().m_82400_((double)radius), EntitySelector.f_20406_.and(Entity::m_6087_).and(EntitySelector.f_20403_).and(IS_TAMED_MECHADOG));
            for (Entity entity : nearbyEntities) {
                this.doHurtTarget(entity);
            }
        }

        public boolean doHurtTarget(Entity entity) {
            boolean flag;
            int i;
            LivingEntity livingEntity;
            float damage = entity instanceof Player ? (float)this.boss.m_21133_(Attributes.f_22281_) * 3.0f : (float)this.boss.m_21133_(Attributes.f_22281_) * 2.0f;
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)CelestialEffects.STATIC_EFFECT.get())) {
                int amplify = livingEntity.m_21124_((MobEffect)CelestialEffects.STATIC_EFFECT.get()).m_19564_() + 1;
                damage += (float)amplify * 0.2f;
            }
            if (this.boss.f_19853_.m_46791_() == Difficulty.EASY) {
                damage -= 1.0f;
            }
            if (this.boss.f_19853_.m_46791_() == Difficulty.HARD) {
                damage += 1.0f;
            }
            float knockback = (float)this.boss.m_21133_(Attributes.f_22282_);
            if (entity instanceof LivingEntity) {
                damage += EnchantmentHelper.m_44833_((ItemStack)this.boss.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this.boss);
            }
            if ((i = EnchantmentHelper.m_44914_((LivingEntity)this.boss)) > 0) {
                entity.m_20254_(i * 4);
            }
            if (flag = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), damage)) {
                if (knockback > 0.0f && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.boss.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.boss.m_146908_() * ((float)Math.PI / 180)))));
                    this.boss.m_20256_(this.boss.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.maybeDisableShield(player, this.boss.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
                this.boss.m_19970_((LivingEntity)this.boss, entity);
                this.boss.m_21335_(entity);
            }
            return flag;
        }

        private void maybeDisableShield(Player p_21425_, ItemStack p_21426_, ItemStack p_21427_) {
            if (!p_21426_.m_41619_() && !p_21427_.m_41619_() && p_21426_.m_41720_() instanceof AxeItem && p_21427_.m_150930_(Items.f_42740_)) {
                float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this.boss) * 0.05f;
                if (this.boss.f_19796_.nextFloat() < f) {
                    p_21425_.m_36335_().m_41524_(Items.f_42740_, 100);
                    this.boss.f_19853_.m_7605_((Entity)p_21425_, (byte)30);
                }
            }
        }

        private Vec3 getParticleDirection(int angle) {
            if (angle >= 0 && angle < 90) {
                int x = angle;
                return new Vec3(Math.sin(Math.toRadians(x)), 0.0, Math.cos(Math.toRadians(x)));
            }
            if (angle >= 90 && angle < 180) {
                int x = angle - 90;
                return new Vec3(Math.cos(Math.toRadians(x)), 0.0, -Math.sin(Math.toRadians(x)));
            }
            if (angle >= 180 && angle < 270) {
                int x = angle - 180;
                return new Vec3(-Math.sin(Math.toRadians(x)), 0.0, -Math.cos(Math.toRadians(x)));
            }
            int x = angle - 270;
            return new Vec3(-Math.cos(Math.toRadians(x)), 0.0, Math.sin(Math.toRadians(x)));
        }

        public void m_8037_() {
            ++this.lengthTick;
            if (this.lengthTick == 4) {
                this.waveAttack(3.0f);
            } else if (this.lengthTick == 6) {
                this.waveAttack(5.5f);
            } else if (this.lengthTick == 8) {
                this.waveAttack(8.0f);
            }
            super.m_8037_();
        }

        public void m_8041_() {
            this.boss.setCharged(false);
            this.lengthTick = 0;
            super.m_8041_();
        }
    }

    public static class StunByAttackGoal
    extends Goal {
        MechaCerberusBoss boss;
        static final int MAX_STUN = 60;
        int stunTick;

        public StunByAttackGoal(MechaCerberusBoss mechaCerberus) {
            this.boss = mechaCerberus;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.boss.isStunned();
        }

        public void m_8056_() {
            ((AzureNavigation)this.boss.m_21573_()).hardStop();
            super.m_8056_();
        }

        public void m_8041_() {
            List nearbyPlayers = this.boss.f_19853_.m_6249_((Entity)this.boss, this.boss.m_142469_().m_82400_(32.0), EntitySelector.f_20408_.and(Entity::m_6087_).and(EntitySelector.f_20403_).and(IS_PLAYER));
            for (Entity e : nearbyPlayers) {
                if (!(e instanceof Player)) continue;
                Player player = (Player)e;
                player.m_21195_((MobEffect)CelestialEffects.STATIC_EFFECT.get());
            }
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.stunTick;
            Level level = this.boss.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.stunTick % 2 == 0) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CelestialParticles.STUN_PARTICLE.get()), this.boss.headLeft.m_20182_().m_7096_(), this.boss.headLeft.m_20182_().m_7098_() + 2.0, this.boss.headLeft.m_20182_().m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CelestialParticles.STUN_PARTICLE.get()), this.boss.headCenter.m_20182_().m_7096_(), this.boss.headCenter.m_20182_().m_7098_() + 2.0, this.boss.headCenter.m_20182_().m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CelestialParticles.STUN_PARTICLE.get()), this.boss.headRight.m_20182_().m_7096_(), this.boss.headRight.m_20182_().m_7098_() + 2.0, this.boss.headRight.m_20182_().m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.stunTick > 60) {
                this.boss.setStunned(false);
                this.stunTick = 0;
            }
        }
    }

    public static class SummonMinionsGoal
    extends Goal {
        MechaCerberusBoss boss;
        int summonLength;

        public SummonMinionsGoal(MechaCerberusBoss mechaCerberus) {
            this.boss = mechaCerberus;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.summonLength = 0;
        }

        public boolean m_8036_() {
            List nearbyMinions = this.boss.f_19853_.m_6249_((Entity)this.boss, this.boss.m_142469_().m_82400_(32.0), EntitySelector.f_20408_.and(Entity::m_6087_).and(EntitySelector.f_20403_).and(entity -> entity instanceof MechaDog));
            List nearbyPlayers = this.boss.f_19853_.m_6249_((Entity)this.boss, this.boss.m_142469_().m_82400_(32.0), EntitySelector.f_20408_.and(Entity::m_6087_).and(EntitySelector.f_20403_).and(IS_PLAYER));
            if (nearbyMinions.size() >= nearbyPlayers.size() * 3) {
                return false;
            }
            return this.boss.summonMinionsTick > 500 && !this.boss.isCharging() && !this.boss.isCharged() && !this.boss.isStunned();
        }

        public boolean m_8045_() {
            return this.summonLength < 30;
        }

        public void m_8037_() {
            ++this.summonLength;
            super.m_8037_();
        }

        public void m_8056_() {
            ((AzureNavigation)this.boss.m_21573_()).hardStop();
            this.boss.setHowling(true);
            SoundEvent soundevent = this.boss.getHowlSound();
            if (soundevent != null) {
                this.boss.m_5496_(soundevent, this.boss.m_6121_(), this.boss.m_6100_());
            }
        }

        public void m_8041_() {
            this.boss.setHowling(false);
            this.summonLength = 0;
            int rand = this.boss.f_19796_.nextInt(9);
            int minionCount = switch (rand) {
                case 0 -> 3;
                case 1, 2, 3 -> 2;
                default -> 1;
            };
            List nearbyPlayers = this.boss.f_19853_.m_6249_((Entity)this.boss, this.boss.m_142469_().m_82400_(32.0), EntitySelector.f_20408_.and(Entity::m_6087_).and(EntitySelector.f_20403_).and(IS_PLAYER));
            minionCount *= nearbyPlayers.size();
            for (int i = 0; i <= minionCount; ++i) {
                if (this.boss.f_19853_.m_5776_()) continue;
                ServerLevel serverLevel = (ServerLevel)this.boss.f_19853_;
                int xOffset = this.boss.f_19796_.nextInt(4) - 2;
                int zOffset = this.boss.f_19796_.nextInt(4) - 2;
                BlockPos pos = this.boss.m_142538_().m_142386_(xOffset).m_142390_(zOffset);
                if (!this.boss.f_19853_.m_45772_(((EntityType)CelestialEntities.MECHADOG.get()).m_20585_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) continue;
                MechaDog dog = (MechaDog)((EntityType)CelestialEntities.MECHADOG.get()).m_20615_(this.boss.f_19853_);
                dog.m_20035_(pos, this.boss.m_146908_(), this.boss.m_146909_());
                dog.m_6710_(this.boss.m_5448_());
                serverLevel.m_47205_((Entity)dog);
            }
            this.boss.summonMinionsTick = 0;
            super.m_8041_();
        }
    }

    public static class IsStuckGoal
    extends Goal {
        MechaCerberusBoss boss;

        public IsStuckGoal(MechaCerberusBoss mechaCerberus) {
        }

        public boolean m_8036_() {
            return false;
        }
    }
}

