/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.robots;

import com.shim.celestialexploration.entity.DyeType;
import com.shim.celestialexploration.entity.IDyeable;
import com.shim.celestialexploration.entity.client.dispatchers.MechaDogDispatcher;
import com.shim.celestialexploration.entity.goals.NearestAttackableTargetPeacefulGoal;
import com.shim.celestialexploration.entity.mob.Gust;
import java.util.EnumSet;
import java.util.function.Predicate;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MechaDog
extends TamableAnimal
implements IDyeable {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(MechaDog.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(MechaDog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype == EntityType.f_20520_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20452_;
    };
    public final MechaDogDispatcher dispatcher;
    private final MoveAnalysis moveAnalysis;
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 20.0f;
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private final Item foodItem = Items.f_42451_;

    public MechaDog(EntityType<? extends MechaDog> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.dispatcher = new MechaDogDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public boolean m_142668_() {
        return false;
    }

    public boolean m_7848_(Animal p_27569_) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean m_5957_() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MechaDogPanicGoal(1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, new MechaDogAvoidEntityGoal<Gust>(this, Gust.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new NearestAttackableTargetPeacefulGoal<Player>((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)DyeType.RED.ordinal());
    }

    protected void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getDyeType().getName());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Type", 8)) {
            this.setDyeType(DyeType.byName(tag.m_128461_("Type")));
        }
    }

    @Override
    public void setDyeType(DyeType p_38333_) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)p_38333_.ordinal());
    }

    @Override
    public DyeType getDyeType() {
        return DyeType.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected SoundEvent m_7515_() {
        if (this.f_19796_.nextInt(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.isWet && !this.isShaking && !this.m_21691_() && this.f_19861_) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.moveAnalysis.update();
        if (this.m_6084_()) {
            if (this.f_19853_.m_5776_()) {
                if (this.m_21825_() || this.m_21827_()) {
                    this.dispatcher.sit();
                } else {
                    boolean isMovingOnGround;
                    boolean bl = isMovingOnGround = this.moveAnalysis.isMovingHorizontally() && this.m_20096_();
                    if (isMovingOnGround) {
                        this.dispatcher.walk();
                    } else {
                        this.dispatcher.idle();
                    }
                }
            }
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.m_20071_()) {
                this.isWet = true;
                if (this.isShaking && !this.f_19853_.f_46443_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_157787_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    public void m_6667_(DamageSource p_30384_) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.m_6667_(p_30384_);
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float p_30447_) {
        return Math.min(0.5f + Mth.m_14179_((float)p_30447_, (float)this.shakeAnimO, (float)this.shakeAnim) / 2.0f * 0.5f, 1.0f);
    }

    public float getBodyRollAngle(float p_30433_, float p_30434_) {
        float f = (Mth.m_14179_((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim) + p_30434_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float p_30449_) {
        return Mth.m_14179_((float)p_30449_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    protected float m_6431_(Pose p_30409_, EntityDimensions p_30410_) {
        return p_30410_.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean m_6469_(DamageSource p_30386_, float p_30387_) {
        if (this.m_6673_(p_30386_)) {
            return false;
        }
        Entity entity = p_30386_.m_7639_();
        if (!this.f_19853_.f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(p_30386_, p_30387_);
    }

    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        return flag;
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)p_30412_) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(5.0f);
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(p_30412_, p_30413_);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)p_30412_)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    public void m_7822_(byte p_30379_) {
        if (p_30379_ == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (p_30379_ == 56) {
            this.cancelShake();
        } else {
            super.m_7822_(p_30379_);
        }
    }

    public float getTailAngle() {
        return this.m_21824_() ? (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean m_6898_(ItemStack p_30440_) {
        return p_30440_.m_150930_(this.foodItem);
    }

    public int m_5792_() {
        return 8;
    }

    public void setIsInterested(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    public boolean m_7757_(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof MechaDog) {
                MechaDog mechadog = (MechaDog)p_30389_;
                return !mechadog.m_21824_() || mechadog.m_142480_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    class MechaDogPanicGoal
    extends PanicGoal {
        public MechaDogPanicGoal(double p_203124_) {
            super((PathfinderMob)MechaDog.this, p_203124_);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
        }
    }

    class MechaDogAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final MechaDog mechadog;

        public MechaDogAvoidEntityGoal(MechaDog p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.mechadog = p_30454_;
        }

        public boolean m_8036_() {
            if (super.m_8036_() && this.f_25016_ instanceof Llama) {
                return !this.mechadog.m_21824_() && this.avoidLlama((Llama)this.f_25016_);
            }
            return false;
        }

        private boolean avoidLlama(Llama p_30461_) {
            return p_30461_.m_30823_() >= MechaDog.this.f_19796_.nextInt(5);
        }

        public void m_8056_() {
            MechaDog.this.m_6710_(null);
            super.m_8056_();
        }

        public void m_8037_() {
            MechaDog.this.m_6710_(null);
            super.m_8037_();
        }
    }

    class BegGoal
    extends Goal {
        private final MechaDog mechadog;
        @javax.annotation.Nullable
        private Player player;
        private final Level level;
        private final float lookDistance;
        private int lookTime;
        private final TargetingConditions begTargeting;

        public BegGoal(MechaDog p_25063_, float p_25064_) {
            this.mechadog = p_25063_;
            this.level = p_25063_.f_19853_;
            this.lookDistance = p_25064_;
            this.begTargeting = TargetingConditions.m_148353_().m_26883_((double)p_25064_);
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.level.m_45946_(this.begTargeting, (LivingEntity)this.mechadog);
            return this.player != null && this.playerHoldingInteresting(this.player);
        }

        public boolean m_8045_() {
            if (!this.player.m_6084_()) {
                return false;
            }
            if (this.mechadog.m_20280_((Entity)this.player) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0 && this.playerHoldingInteresting(this.player);
        }

        public void m_8056_() {
            this.mechadog.setIsInterested(true);
            this.lookTime = this.m_183277_(40 + this.mechadog.m_21187_().nextInt(40));
        }

        public void m_8041_() {
            this.mechadog.setIsInterested(false);
            this.player = null;
        }

        public void m_8037_() {
            this.mechadog.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.mechadog.m_8132_());
            --this.lookTime;
        }

        private boolean playerHoldingInteresting(Player p_25067_) {
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack = p_25067_.m_21120_(interactionhand);
                if (this.mechadog.m_21824_() && itemstack.m_150930_(this.mechadog.foodItem)) {
                    return true;
                }
                if (!this.mechadog.m_6898_(itemstack)) continue;
                return true;
            }
            return false;
        }
    }
}

