/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.robots;

import com.shim.celestialexploration.entity.client.dispatchers.RoverDispatcher;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class Rover
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.m_135353_(Rover.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    public final RoverDispatcher dispatcher = new RoverDispatcher(this);
    private final MoveAnalysis moveAnalysis = new MoveAnalysis((Entity)this);

    public Rover(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.f_21345_.m_25352_(9, (Goal)new RoverLeaveBlockGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new RoverTakeBlockGoal(this));
    }

    public static boolean checkRoverSpawnRules(EntityType<Rover> rover, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        return random.nextInt(10) == 0 && Rover.m_21400_(rover, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.moveAnalysis.update();
        if (this.f_19853_.m_5776_()) {
            boolean isMovingOnGround;
            boolean bl = isMovingOnGround = this.moveAnalysis.isMovingHorizontally() && this.m_20096_();
            if (isMovingOnGround) {
                this.dispatcher.roll();
            } else {
                this.dispatcher.idle();
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CARRY_STATE, Optional.empty());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            nbt.m_128365_("carriedBlockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        BlockState blockstate = null;
        if (nbt.m_128425_("carriedBlockState", 10) && (blockstate = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("carriedBlockState"))).m_60795_()) {
            blockstate = null;
        }
        this.setCarriedBlock(blockstate);
    }

    public void setCarriedBlock(@Nullable BlockState p_32522_) {
        this.f_19804_.m_135381_(DATA_CARRY_STATE, Optional.ofNullable(p_32522_));
    }

    @Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_CARRY_STATE)).orElse(null);
    }

    static class RoverLeaveBlockGoal
    extends Goal {
        private final Rover rover;

        public RoverLeaveBlockGoal(Rover p_32556_) {
            this.rover = p_32556_;
        }

        public boolean m_8036_() {
            if (this.rover.getCarriedBlock() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.rover.f_19853_, (Entity)this.rover)) {
                return false;
            }
            return this.rover.m_21187_().nextInt(RoverLeaveBlockGoal.m_186073_((int)2000)) == 0;
        }

        public void m_8037_() {
            Random random = this.rover.m_21187_();
            Level level = this.rover.f_19853_;
            int i = Mth.m_14107_((double)(this.rover.m_20185_() - 1.0 + random.nextDouble() * 2.0));
            int j = Mth.m_14107_((double)(this.rover.m_20186_() + random.nextDouble() * 2.0));
            int k = Mth.m_14107_((double)(this.rover.m_20189_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = level.m_8055_(blockpos);
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate1 = level.m_8055_(blockpos1);
            BlockState blockstate2 = this.rover.getCarriedBlock();
            if (blockstate2 != null && this.canPlaceBlock(level, blockpos, blockstate2 = Block.m_49931_((BlockState)blockstate2, (LevelAccessor)this.rover.f_19853_, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.rover, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                level.m_7731_(blockpos, blockstate2, 3);
                level.m_142346_((Entity)this.rover, GameEvent.f_157797_, blockpos);
                this.rover.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(Level p_32559_, BlockPos p_32560_, BlockState p_32561_, BlockState p_32562_, BlockState p_32563_, BlockPos p_32564_) {
            return p_32562_.m_60795_() && !p_32563_.m_60795_() && !p_32563_.m_60713_(Blocks.f_50752_) && !p_32563_.m_204336_(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_32563_.m_60838_((BlockGetter)p_32559_, p_32564_) && p_32561_.m_60710_((LevelReader)p_32559_, p_32560_) && p_32559_.m_45933_((Entity)this.rover, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)p_32560_))).isEmpty();
        }
    }

    static class RoverTakeBlockGoal
    extends Goal {
        private final Rover rover;

        public RoverTakeBlockGoal(Rover p_32585_) {
            this.rover = p_32585_;
        }

        public boolean m_8036_() {
            if (this.rover.getCarriedBlock() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.rover.f_19853_, (Entity)this.rover)) {
                return false;
            }
            return this.rover.m_21187_().nextInt(RoverTakeBlockGoal.m_186073_((int)20)) == 0;
        }

        public void m_8037_() {
            Random random = this.rover.m_21187_();
            Level level = this.rover.f_19853_;
            int i = Mth.m_14107_((double)(this.rover.m_20185_() - 2.0 + random.nextDouble() * 4.0));
            int j = Mth.m_14107_((double)(this.rover.m_20186_() + random.nextDouble() * 3.0));
            int k = Mth.m_14107_((double)(this.rover.m_20189_() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = level.m_8055_(blockpos);
            Vec3 vec3 = new Vec3((double)this.rover.m_146903_() + 0.5, (double)j + 0.5, (double)this.rover.m_146907_() + 0.5);
            Vec3 vec31 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockhitresult = level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.rover));
            boolean flag = blockhitresult.m_82425_().equals((Object)blockpos);
            if (blockstate.m_204336_(BlockTags.f_13046_) && flag) {
                level.m_7471_(blockpos, false);
                level.m_142346_((Entity)this.rover, GameEvent.f_157794_, blockpos);
                this.rover.setCarriedBlock(blockstate.m_60734_().m_49966_());
            }
        }
    }
}

