/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.vehicle;

import com.google.common.collect.Lists;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.blockentities.TaxiStationBlockEntity;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.vehicle.Spaceship;
import com.shim.celestialexploration.inventory.menus.SpaceTaxiMenu;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialItems;
import com.shim.celestialexploration.util.CelestialUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpaceTaxi
extends Spaceship
implements ContainerListener,
MenuProvider {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_ID_TIME_ON_GROUND = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_INVENTORY_COOLDOWN = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_FUEL_TICKS = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_FUEL = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TICKS_ASCENDED = SynchedEntityData.m_135353_(SpaceTaxi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float outOfControlTicks;
    public float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Status status;
    private static final float SPACE_TAXI_SPEED = (float)((Double)CelestialCommonConfig.SPACESHIP_SPEED.get()).doubleValue() - 0.15f;
    protected SimpleContainer inventory;
    private static final int MAX_FUEL_TICKS = (Integer)CelestialCommonConfig.SPACESHIP_FUEL_RATE.get();
    private int teleportationCooldown = 60;
    public static int maxTimeOnGround = 15;
    private final int LOW_FUEL = 300;
    protected final ContainerData data;
    Entity firstSelectedEntity;
    Entity secondSelectedEntity;
    BlockPos selectedPos = new BlockPos(0, 0, 0);
    ResourceKey<Level> selectedDimension;
    boolean hasEmeralds = false;
    boolean readyToGo = false;
    boolean shouldAscend = false;
    boolean shouldDescend = false;
    int ticksAscended = 0;
    int ticksDescended = 0;
    TaxiCapability.TaxiStationData taxiStation;
    private LazyOptional<?> itemHandler = null;

    public SpaceTaxi(EntityType<? extends SpaceTaxi> p_38290_, Level p_38291_) {
        super(p_38290_, p_38291_);
        this.f_19850_ = true;
        this.createInventory();
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 6 -> {
                        if (SpaceTaxi.this.hasEmeralds) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> {
                        if (SpaceTaxi.this.readyToGo) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        SpaceTaxi.this.firstSelectedEntity = SpaceTaxi.this.f_19853_.m_6815_(value);
                        break;
                    }
                    case 1: {
                        SpaceTaxi.this.secondSelectedEntity = SpaceTaxi.this.f_19853_.m_6815_(value);
                        break;
                    }
                    case 2: {
                        SpaceTaxi.this.selectedPos = new BlockPos(value, SpaceTaxi.this.selectedPos.m_123342_(), SpaceTaxi.this.selectedPos.m_123343_());
                        break;
                    }
                    case 3: {
                        SpaceTaxi.this.selectedPos = new BlockPos(SpaceTaxi.this.selectedPos.m_123341_(), value, SpaceTaxi.this.selectedPos.m_123343_());
                        break;
                    }
                    case 4: {
                        SpaceTaxi.this.selectedPos = new BlockPos(SpaceTaxi.this.selectedPos.m_123341_(), SpaceTaxi.this.selectedPos.m_123342_(), value);
                        break;
                    }
                    case 5: {
                        SpaceTaxi.this.selectedDimension = CelestialUtil.getDimensionFromId(value);
                        break;
                    }
                    case 6: {
                        SpaceTaxi.this.hasEmeralds = value == 1;
                        break;
                    }
                    case 7: {
                        SpaceTaxi.this.readyToGo = value == 1;
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public SpaceTaxi(Level p_38293_, double p_38294_, double p_38295_, double p_38296_) {
        this((EntityType<? extends SpaceTaxi>)((EntityType)CelestialEntities.SPACE_TAXI.get()), p_38293_);
        this.m_6034_(p_38294_, p_38295_, p_38296_);
        this.f_19854_ = p_38294_;
        this.f_19855_ = p_38295_;
        this.f_19856_ = p_38296_;
        this.m_20242_(true);
    }

    @Override
    public void m_5757_(Container p_18983_) {
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new SpaceTaxiMenu(containerId, inventory, this, this.data);
    }

    @Override
    public Component m_5446_() {
        return new TranslatableComponent("entity.celestialexploration.space_taxi");
    }

    @Override
    protected float m_6380_(Pose p_38327_, EntityDimensions p_38328_) {
        return p_38328_.f_20378_;
    }

    @Override
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TICKS_ASCENDED, (Object)0);
    }

    @Override
    public boolean m_7337_(Entity p_38376_) {
        return SpaceTaxi.canVehicleCollide(this, p_38376_);
    }

    public static boolean canVehicleCollide(Entity p_38324_, Entity p_38325_) {
        return (p_38325_.m_5829_() || p_38325_.m_6094_()) && !p_38324_.m_20365_(p_38325_);
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    @Override
    protected Vec3 m_7643_(Direction.Axis p_38335_, BlockUtil.FoundRectangle p_38336_) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(p_38335_, p_38336_));
    }

    @Override
    public boolean m_6469_(DamageSource p_38319_, float p_38320_) {
        if (this.m_6673_(p_38319_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_38320_ * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_157808_, p_38319_.m_7639_());
            boolean bl = flag = p_38319_.m_7639_() instanceof Player && ((Player)p_38319_.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                this.m_19998_((ItemLike)this.getDropItem());
                for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                    if (this.inventory.m_8020_(i) == null) continue;
                    this.m_19983_(this.inventory.m_8020_(i));
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    @Override
    public Item getDropItem() {
        return (Item)CelestialItems.WHITE_SPACESHIP.get();
    }

    @Override
    public void m_6053_() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    @Override
    public boolean m_6087_() {
        return !this.m_146910_();
    }

    @Override
    public void m_6453_(double lerpX, double lerpY, double lerpZ, float lerpYRot, float lerpXRot, int p_38304_, boolean p_38305_) {
        this.lerpX = lerpX;
        this.lerpY = lerpY;
        this.lerpZ = lerpZ;
        this.lerpYRot = lerpYRot;
        this.lerpXRot = lerpXRot;
        this.lerpSteps = 10;
    }

    @Override
    @NotNull
    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    @Override
    public void m_8119_() {
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.f_19853_.f_46443_ && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        if (this.m_6109_()) {
            if (this.f_19853_.f_46443_) {
                // empty if block
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.hasEmeralds = this.inventory.m_8020_(0).m_41656_(new ItemStack((ItemLike)Items.f_42616_, 3));
        if (!this.f_19853_.f_46443_) {
            if (this.readyToGo && this.hasEmeralds && this.firstSelectedEntity != null && this.selectedDimension != null) {
                this.inventory.m_8020_(0).m_41774_(3);
                this.m_19983_(this.inventory.m_8020_(0));
                this.inventory.m_8020_(0).m_41774_(this.inventory.m_8020_(0).m_41613_());
                this.m_20153_();
                this.firstSelectedEntity.m_20329_((Entity)this);
                if (this.secondSelectedEntity != null) {
                    this.secondSelectedEntity.m_20329_((Entity)this);
                }
                this.setTicksAscended(0);
                this.shouldAscend = true;
                this.readyToGo = false;
            }
            if (this.shouldAscend && this.getTicksAscended() < 60) {
                this.m_20334_(0.0, SPACE_TAXI_SPEED, 0.0);
                this.incrementTicksAscended();
            }
            if (this.getTicksAscended() >= 60) {
                this.shouldAscend = false;
                this.m_20334_(0.0, 0.0, 0.0);
                BlockEntity blockEntity = this.f_19853_.m_7702_(this.selectedPos);
                CelestialExploration.LOGGER.debug("blockEntity: " + blockEntity + ", at: " + this.selectedPos);
                if (blockEntity instanceof TaxiStationBlockEntity) {
                    TaxiStationBlockEntity station = (TaxiStationBlockEntity)blockEntity;
                    station.setIncomingTaxi(this, this.m_20197_());
                    for (Entity passenger : this.m_20197_()) {
                        passenger.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
                    }
                    this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
                }
            }
            if (this.shouldDescend) {
                this.m_20334_(0.0, -SPACE_TAXI_SPEED, 0.0);
            }
            if (this.f_19861_) {
                this.shouldDescend = false;
            }
        }
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 2 && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    private Status getStatus() {
        Status spacetaxi$status = this.isUnderwater();
        if (spacetaxi$status != null) {
            return spacetaxi$status;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    @Override
    public float getGroundFriction() {
        AABB aabb = this.m_142469_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.f_19853_, (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    @javax.annotation.Nullable
    private Status isUnderwater() {
        AABB aabb = this.m_142469_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    public static Vec3 translateWithXRotation(@Nonnull Vec3 baseIn, double rotationIn, double xOffsetIn, double yOffsetIn, double zOffsetIn) {
        double rotation = Math.toRadians(rotationIn);
        double offsetXRotated = xOffsetIn * -Math.sin(rotation) + zOffsetIn * Math.cos(rotation);
        double offsetZRotated = xOffsetIn * Math.cos(rotation) + zOffsetIn * Math.sin(rotation);
        return new Vec3(baseIn.f_82479_ + offsetXRotated, baseIn.f_82480_ + yOffsetIn, baseIn.f_82481_ + offsetZRotated);
    }

    @Override
    public double m_6048_() {
        return 0.45;
    }

    @Override
    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            int i;
            float f = 0.9f;
            float f1 = (float)((this.m_146910_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            if (this.m_20197_().size() > 1 && (i = this.m_20197_().indexOf(passenger)) == 0) {
                f = -0.5f;
            }
            if (passenger instanceof Animal) {
                f += 0.2f;
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
            this.clampRotation(passenger);
        }
    }

    @Override
    public Vec3 m_7688_(LivingEntity p_38357_) {
        double d1;
        Vec3 vec3 = SpaceTaxi.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)p_38357_.m_20205_(), (float)p_38357_.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        BlockPos blockpos = new BlockPos(d0, this.m_142469_().f_82292_, d1 = this.m_20189_() + vec3.f_82481_);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.f_19853_.m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.f_19853_.m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : p_38357_.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.f_19853_, (Vec3)vec31, (LivingEntity)p_38357_, (Pose)pose)) continue;
                    p_38357_.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(p_38357_);
    }

    @Override
    public void clampRotation(Entity p_38322_) {
        p_38322_.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(p_38322_.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        p_38322_.f_19859_ += f1 - f;
        p_38322_.m_146922_(p_38322_.m_146908_() + f1 - f);
        p_38322_.m_5616_(p_38322_.m_146908_());
    }

    @Override
    public void m_7340_(Entity p_38383_) {
        this.clampRotation(p_38383_);
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128379_("readyToGo", this.readyToGo);
        tag.m_128365_("Items", (Tag)listtag);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        ListTag listtag = tag.m_128437_("Items", 10);
        this.createInventory();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        this.readyToGo = tag.m_128471_("readyToGo");
        this.updateContainerEquipment();
    }

    @Override
    public void m_20258_(CompoundTag tag) {
        ListTag listtag = tag.m_128437_("Items", 10);
        this.createInventory();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        this.updateContainerEquipment();
        super.m_20258_(tag);
    }

    @Override
    protected int getInventorySize() {
        return 31;
    }

    @Override
    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    @Override
    protected boolean getFlag(int p_30648_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & p_30648_) != 0;
    }

    @Override
    protected void setFlag(int p_30598_, boolean p_30599_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (p_30599_) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | p_30598_)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~p_30598_)));
        }
    }

    @Override
    protected void updateContainerEquipment() {
        if (!this.f_19853_.f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_142049_()));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.f_19853_.f_46443_) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7840_(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
        if (!this.m_20159_()) {
            if (p_38308_) {
                if (this.f_19789_ > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_) && p_38307_ < 0.0) {
                this.f_19789_ -= (float)p_38307_;
            }
        }
    }

    @Override
    public void setDamage(float p_38312_) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(p_38312_));
    }

    @Override
    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    @Override
    public void setHurtTime(int p_38355_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_38355_);
    }

    public int getTicksAscended() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TICKS_ASCENDED);
    }

    public void setTicksAscended(int tick) {
        this.f_19804_.m_135381_(DATA_ID_TICKS_ASCENDED, (Object)tick);
    }

    public void incrementTicksAscended() {
        this.f_19804_.m_135381_(DATA_ID_TICKS_ASCENDED, (Object)(this.getTicksAscended() + 1));
    }

    @Override
    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    @Override
    public void setHurtDir(int p_38363_) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)p_38363_);
    }

    @Override
    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    @Override
    protected boolean m_7310_(Entity p_38390_) {
        return this.m_20197_().size() < 2 && !this.m_204029_(FluidTags.f_13131_);
    }

    @Override
    @javax.annotation.Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    @Override
    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    public void setPassenger(Entity passenger, int passengerNumber) {
        if (passengerNumber == 1) {
            this.firstSelectedEntity = passenger;
        } else if (passengerNumber == 2 && this.firstSelectedEntity != null) {
            this.secondSelectedEntity = passenger;
        }
    }

    public void setReadyForTakeoff() {
        this.readyToGo = true;
    }

    public void setDestination(BlockPos pos, ResourceKey<Level> destination) {
        this.selectedPos = pos;
        this.selectedDimension = destination;
    }

    public void setStation(TaxiCapability.TaxiStationData stationData) {
        this.taxiStation = stationData;
    }

    public void setDescent() {
        this.shouldDescend = true;
    }

    @Override
    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

