/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.events;

import com.mojang.datafixers.util.Either;
import com.shim.celestialexploration.blocks.AirlockDoorBlock;
import com.shim.celestialexploration.blocks.HangarDoorBlock;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.CelestialCatSpawner;
import com.shim.celestialexploration.entity.projectile.MeteorProjectile;
import com.shim.celestialexploration.entity.vehicle.Spaceship;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialTags;
import com.shim.celestiallib.api.blocks.AbstractPortalBlock;
import com.shim.celestiallib.api.effects.CLibEffects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="celestialexploration", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CelestialForgeEventBus {
    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Spaceship spaceship;
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof Spaceship && !(spaceship = (Spaceship)entity).m_146910_() && !event.getWorldObj().f_46443_) {
            event.setCanceled(spaceship.getTimeOnGround() < Spaceship.maxTimeOnGround);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent event) {
        Level level = event.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.haveTime()) {
                MeteorProjectile meteor;
                Random random;
                ServerPlayer player;
                new CelestialCatSpawner().m_7995_(serverLevel, true, true);
                if (serverLevel.m_46470_() && (player = serverLevel.m_8890_()) != null && serverLevel.m_204166_(player.m_142538_()).m_203656_(CelestialTags.Biomes.METEOR_SHOWER_BIOMES) && (random = new Random()).nextInt(3) == 0 && (meteor = (MeteorProjectile)((EntityType)CelestialEntities.METEOR.get()).m_20615_((Level)serverLevel)) != null) {
                    double height = Math.min(player.m_20182_().f_82480_ + (double)random.nextInt(128) - 16.0, (double)serverLevel.m_151558_());
                    meteor.m_6027_(player.m_20182_().f_82479_ + (double)random.nextInt(128) - 64.0, height, player.m_20182_().f_82481_ - (double)random.nextInt(64));
                    serverLevel.m_7967_((Entity)meteor);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTakeDamage(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().m_146707_() && ((Boolean)CelestialCommonConfig.USE_GRAVITY_EFFECTS.get()).booleanValue() && (entity.m_21023_((MobEffect)CLibEffects.LOW_GRAVITY.get()) || entity.m_21023_((MobEffect)CLibEffects.EXTRA_LOW_GRAVITY.get()))) {
            if (event.getAmount() <= 3.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount(event.getAmount() - 3.0f);
            }
        }
    }

    @SubscribeEvent
    public static void clickEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (event.getSide() == LogicalSide.SERVER && player != null) {
            if (event.getItemStack() != null && event.getItemStack().m_41720_() == Items.f_42409_) {
                if (((Boolean)CelestialCommonConfig.PORTALS.get()).booleanValue()) {
                    Level level = event.getWorld();
                    if (player.f_19853_.m_204166_(player.m_20097_()).m_203656_(CelestialTags.Biomes.CELESTIAL_BODIES) || player.f_19853_.m_46472_() == Level.f_46428_) {
                        block0: for (Direction direction : Direction.Plane.VERTICAL) {
                            BlockPos framePos = event.getPos().m_142300_(direction);
                            for (RegistryObject<? extends AbstractPortalBlock> block : CelestialBlocks.PORTAL_BLOCKS) {
                                if (!((AbstractPortalBlock)block.get()).trySpawnPortal((LevelAccessor)level, framePos)) continue;
                                level.m_5594_(player, framePos, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
                                event.setCanceled(true);
                                event.setCancellationResult(InteractionResult.CONSUME);
                                continue block0;
                            }
                        }
                    }
                }
            } else if (event.getItemStack() != null && event.getItemStack().m_41720_() instanceof ShovelItem) {
                BlockPos pos;
                Level level = event.getWorld();
                BlockState block = level.m_8055_(pos = event.getHitVec().m_82425_());
                if (block.m_60713_((Block)CelestialBlocks.MOON_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.MOON_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.MARS_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.MARS_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.VENUS_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.VENUS_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.MERCURY_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.MERCURY_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.IO_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.IO_SAND_PATH.get()).m_49966_(), 1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (((Boolean)CelestialCommonConfig.STORMS.get()).booleanValue()) {
            LivingEntity livingEntity;
            if (event.getWorld().m_46471_() && event.getWorld().m_204166_(entity.m_142538_()).m_203656_(CelestialTags.Biomes.DUST_STORM_BIOMES) && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player)) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 7000, 0, false, false, true));
                }
            }
            if (!event.getWorld().m_46471_() && event.getWorld().m_204166_(entity.m_142538_()).m_203656_(CelestialTags.Biomes.DUST_STORM_BIOMES) && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player)) {
                    livingEntity.m_21195_(MobEffects.f_19597_);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal() != null && event.getPlayer() != null) {
            event.getOriginal().reviveCaps();
            TaxiCapability.ITaxi oldTaxiData = (TaxiCapability.ITaxi)event.getOriginal().getCapability(CelestialCapabilities.TAXI_CAPABILITY).orElse(null);
            TaxiCapability.ITaxi newTaxiData = (TaxiCapability.ITaxi)event.getPlayer().getCapability(CelestialCapabilities.TAXI_CAPABILITY).orElse(null);
            if (oldTaxiData != null && newTaxiData != null) {
                newTaxiData.setData(oldTaxiData.getData());
            }
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onToolTipRender(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().m_150930_(((AirlockDoorBlock)((Object)CelestialBlocks.AIRLOCK_PANEL_DOOR.get())).m_5456_()) || event.getItemStack().m_150930_(((AirlockDoorBlock)((Object)CelestialBlocks.AIRLOCK_PANEL_DOOR_WINDOW.get())).m_5456_())) {
            event.getTooltipElements().add(Either.left((Object)new TranslatableComponent("item.celestialexploration.door.airlock_panel_door")));
        }
        if (event.getItemStack().m_150930_(((HangarDoorBlock)((Object)CelestialBlocks.HANGAR_DOOR.get())).m_5456_()) || event.getItemStack().m_150930_(((HangarDoorBlock)((Object)CelestialBlocks.HANGAR_DOOR_WINDOW.get())).m_5456_())) {
            event.getTooltipElements().add(Either.left((Object)new TranslatableComponent("item.celestialexploration.door.hangar_door")));
        }
    }
}

