/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.menus;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.entity.vehicle.SpaceTaxi;
import com.shim.celestialexploration.packets.CelestialPacketHandler;
import com.shim.celestialexploration.packets.TaxiDestinationPacket;
import com.shim.celestialexploration.packets.TaxiPassengersPacket;
import com.shim.celestialexploration.packets.TaxiReadyForTakeoffPacket;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import com.shim.celestialexploration.registry.CelestialMenus;
import com.shim.celestialexploration.util.CelestialUtil;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SpaceTaxiMenu
extends AbstractContainerMenu {
    private final Entity entity;
    private final Level level;
    private final List<Entity> nearbyEntites;
    private final List<TaxiCapability.TaxiStationData> taxiStations;
    private List<Entity> selectedEntities;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public SpaceTaxiMenu(int containerId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, inventory, inventory.f_35978_.f_19853_.m_6815_(friendlyByteBuf.readInt()), (ContainerData)new SimpleContainerData(8));
    }

    public SpaceTaxiMenu(int containerId, Inventory inv, Entity entity, ContainerData data) {
        super((MenuType)CelestialMenus.SPACE_TAXI_MENU.get(), containerId);
        SpaceTaxiMenu.m_38869_((Container)inv, (int)6);
        SpaceTaxiMenu.m_38886_((ContainerData)data, (int)8);
        this.entity = (SpaceTaxi)entity;
        this.level = inv.f_35978_.f_19853_;
        Player player = inv.f_35978_;
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.nearbyEntites = this.level.m_6249_((Entity)player, player.m_142469_().m_82400_(32.0), EntitySelector.f_20408_.and(Entity::m_6087_).and(EntitySelector.f_20403_));
        TaxiCapability.ITaxi taxiCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.TAXI_CAPABILITY);
        this.taxiStations = taxiCap != null ? taxiCap.getTaxiStations() : null;
        this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 178, 42)));
        this.m_38884_(this.data);
    }

    public void m_7511_(int p_39044_, int p_39045_) {
        super.m_7511_(p_39044_, p_39045_);
        this.m_150429_();
        this.m_38946_();
    }

    public List<Entity> getNearbyEntites() {
        return this.nearbyEntites;
    }

    public List<TaxiCapability.TaxiStationData> getTaxiStations() {
        return this.taxiStations;
    }

    public void setSelectedEntity(Entity entity, int passengerNum) {
        CelestialPacketHandler.INSTANCE.sendToServer((Object)new TaxiPassengersPacket(this.entity.m_142049_(), entity.m_142049_(), passengerNum));
    }

    public void setSelectedLocation(TaxiCapability.TaxiStationData stationData) {
        this.data.m_8050_(2, stationData.pos().m_123341_());
        this.data.m_8050_(3, stationData.pos().m_123342_());
        this.data.m_8050_(4, stationData.pos().m_123343_());
        this.data.m_8050_(5, CelestialUtil.getIdFromDimension(stationData.dimension()));
        this.m_7511_(2, stationData.pos().m_123341_());
        this.m_7511_(3, stationData.pos().m_123342_());
        this.m_7511_(4, stationData.pos().m_123343_());
        this.m_7511_(5, CelestialUtil.getIdFromDimension(stationData.dimension()));
        CelestialPacketHandler.INSTANCE.sendToServer((Object)new TaxiDestinationPacket(this.entity.m_142049_(), stationData.pos(), stationData.dimension()));
    }

    public boolean hasEmeralds() {
        return this.data.m_6413_(6) == 1;
    }

    public void setButtonClicked() {
        this.data.m_8050_(7, 1);
        this.m_7511_(7, 1);
        CelestialPacketHandler.INSTANCE.sendToServer((Object)new TaxiReadyForTakeoffPacket(this.entity.m_142049_()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 38, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 38) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return this.entity.m_20270_((Entity)player) < 8.0f;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18 + 100, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18 + 100, 142));
        }
    }
}

