/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.menus;

import com.google.common.collect.ImmutableSet;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.blockentities.WorkbenchBlockEntity;
import com.shim.celestialexploration.inventory.FuelSlot;
import com.shim.celestialexploration.inventory.WorkbenchResultSlot;
import com.shim.celestialexploration.inventory.containers.WorkbenchCraftingContainer;
import com.shim.celestialexploration.recipes.WorkbenchCraftingRecipe;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialItems;
import com.shim.celestialexploration.registry.CelestialMenus;
import com.shim.celestialexploration.util.CelestialUtil;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class WorkbenchMenu
extends RecipeBookMenu<WorkbenchCraftingContainer> {
    private final WorkbenchBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final WorkbenchCraftingContainer craftSlots;
    private final ResultContainer resultSlots = new ResultContainer();
    private final Player player;
    private final ContainerLevelAccess access;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 12;

    public WorkbenchMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(8), ContainerLevelAccess.f_39287_);
    }

    public WorkbenchMenu(int containerId, Inventory inv, BlockEntity entity, ContainerData data, ContainerLevelAccess access) {
        super((MenuType)CelestialMenus.WORKBENCH_MENU.get(), containerId);
        WorkbenchMenu.m_38869_((Container)inv, (int)12);
        this.blockEntity = (WorkbenchBlockEntity)entity;
        this.player = inv.f_35978_;
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.access = access;
        this.craftSlots = new WorkbenchCraftingContainer(this, 3, 3, ((WorkbenchBlockEntity)entity).getFluidTank());
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 13, 17));
            this.m_38897_((Slot)new FuelSlot((IItemHandler)handler, 1, 13, 53));
            this.m_38897_(new Slot((Container)this.craftSlots, 0, 66, 17));
            this.m_38897_(new Slot((Container)this.craftSlots, 1, 84, 17));
            this.m_38897_(new Slot((Container)this.craftSlots, 2, 102, 17));
            this.m_38897_(new Slot((Container)this.craftSlots, 3, 66, 35));
            this.m_38897_(new Slot((Container)this.craftSlots, 4, 84, 35));
            this.m_38897_(new Slot((Container)this.craftSlots, 5, 102, 35));
            this.m_38897_(new Slot((Container)this.craftSlots, 6, 66, 53));
            this.m_38897_(new Slot((Container)this.craftSlots, 7, 84, 53));
            this.m_38897_(new Slot((Container)this.craftSlots, 8, 102, 53));
            this.m_38897_(new WorkbenchResultSlot(this.player, this.craftSlots, (Container)this.resultSlots, 9, 144, 35));
        });
        this.m_38884_(data);
    }

    public FluidStack getFluid() {
        return CelestialUtil.getFluidFromId(this.data.m_6413_(6), this.data.m_6413_(4));
    }

    public int getMaxFluidAmount() {
        return this.data.m_6413_(5);
    }

    public boolean isSmelting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getFluidLevel() {
        int progress = this.getFluid().getAmount();
        int maxProgress = this.data.m_6413_(5);
        int progressSize = 52;
        return maxProgress != 0 && progress != 0 ? progress * progressSize / maxProgress : 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 19;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 48, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 48) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return WorkbenchMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)CelestialBlocks.WORKBENCH.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getBurnProgress() {
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.m_6413_(3);
        int j = this.data.m_6413_(2);
        if (i == 0) {
            i = 200;
        }
        return j * 13 / i;
    }

    public boolean isLit() {
        return this.data.m_6413_(2) > 0;
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, WorkbenchCraftingContainer craftingContainer, ResultContainer resultContainer) {
        if (!level.f_46443_) {
            WorkbenchCraftingRecipe craftingRecipe;
            int index;
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional recipe = level.m_7465_().m_44015_((RecipeType)WorkbenchCraftingRecipe.Type.INSTANCE, (Container)craftingContainer, level);
            if (craftingContainer.m_18949_((Set)ImmutableSet.of((Object)((Item)CelestialItems.FLUID_BASIN.get()))) && (index = WorkbenchMenu.getIndexOfItem(craftingContainer, ((Item)CelestialItems.FLUID_BASIN.get()).m_7968_())) != -1 && WorkbenchMenu.canAddFluid(craftingContainer.m_8020_(index), craftingContainer.getMenu().getFluid())) {
                ItemStack existingBasin = craftingContainer.m_8020_(index);
                itemstack = new ItemStack((ItemLike)CelestialItems.FLUID_BASIN.get());
                IFluidHandlerItem craftingCap = (IFluidHandlerItem)CelestialExploration.getCapability(existingBasin, CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                IFluidHandlerItem resultCap = (IFluidHandlerItem)CelestialExploration.getCapability(itemstack, CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                if (craftingCap != null && resultCap != null) {
                    int amount = Math.min(resultCap.getTankCapacity(0) - resultCap.getFluidInTank(0).getAmount(), craftingContainer.getMenu().getFluid().getAmount() + craftingCap.getFluidInTank(0).getAmount());
                    FluidStack fluid = new FluidStack(craftingContainer.getMenu().getFluid().getFluid(), amount);
                    resultCap.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    if (resultCap.getTankCapacity(0) - resultCap.getFluidInTank(0).getAmount() == 0) {
                        craftingContainer.setFluidToLeaveBehind(craftingCap.getFluidInTank(0).getAmount());
                    }
                }
            }
            if (recipe.isPresent() && resultContainer.m_40135_(level, serverplayer, (Recipe)(craftingRecipe = (WorkbenchCraftingRecipe)recipe.get()))) {
                itemstack = craftingRecipe.assemble(craftingContainer);
            }
            resultContainer.m_6836_(9, itemstack);
            menu.m_150404_(9, itemstack);
            serverplayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), 9, itemstack));
        }
    }

    protected static boolean canAddFluid(ItemStack basin, FluidStack fluidToAdd) {
        IFluidHandlerItem cap = (IFluidHandlerItem)CelestialExploration.getCapability(basin, CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap != null) {
            if (cap.getFluidInTank(0).isEmpty()) {
                return true;
            }
            if (!cap.getFluidInTank(0).isFluidEqual(fluidToAdd)) {
                return false;
            }
            return cap.getTankCapacity(0) - cap.getFluidInTank(0).getAmount() != 0;
        }
        return false;
    }

    public static int getIndexOfItem(WorkbenchCraftingContainer craftingContainer, ItemStack item) {
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack = craftingContainer.m_8020_(i);
            if (!item.m_150930_(itemstack.m_41720_()) || itemstack.m_41613_() <= 0) continue;
            return i;
        }
        return -1;
    }

    public void m_6199_(Container container) {
        this.access.m_39292_((p_39386_, p_39387_) -> WorkbenchMenu.slotChangedCraftingGrid((AbstractContainerMenu)this, p_39386_, this.player, this.craftSlots, this.resultSlots));
    }

    public void setFluidAmount(int amount) {
        this.data.m_8050_(4, amount);
    }

    public void m_5816_(StackedContents p_40117_) {
        this.craftSlots.m_5809_(p_40117_);
    }

    public void m_6650_() {
        this.craftSlots.m_6211_();
        this.resultSlots.m_6211_();
    }

    public boolean m_6032_(Recipe<? super WorkbenchCraftingContainer> p_40118_) {
        return p_40118_.m_5818_((Container)this.craftSlots, this.player.f_19853_);
    }

    public void m_6877_(Player p_39389_) {
        super.m_6877_(p_39389_);
        this.access.m_39292_((p_39371_, p_39372_) -> this.m_150411_(p_39389_, this.craftSlots));
    }

    public int m_6636_() {
        return 9;
    }

    public int m_6635_() {
        return this.craftSlots.getWidth();
    }

    public int m_6656_() {
        return this.craftSlots.getHeight();
    }

    public int m_6653_() {
        return 12;
    }

    public RecipeBookType m_5867_() {
        return null;
    }

    public boolean m_142157_(int p_150553_) {
        return p_150553_ != this.m_6636_();
    }
}

