/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shim.celestialexploration.inventory.menus.PlanetChartMenu;
import com.shim.celestialexploration.util.CelestialUtil;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlanetChartScreen
extends AbstractContainerScreen<PlanetChartMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("celestialexploration", "textures/gui/planet_chart.png");
    private List<Component> tooltip = Lists.newArrayList();
    protected static Component coordinatesString = new TranslatableComponent("celestialexploration.planet_details.location");

    public PlanetChartScreen(PlanetChartMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.f_97726_ = 176;
        this.f_97727_ = 176;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_7286_(poseStack, delta, mouseX, mouseY);
        this.m_7025_(poseStack, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.m_6774_(x - i + 75 + 6, y - j + 73 + 5, 18, 18, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 0, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 + 26, y - j + 73 + 12, 3, 3, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 1, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 + 12, y - j + 73 + 29, 4, 4, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 2, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 - 10, y - j + 73 + 12, 4, 4, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 3, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 + 12, y - j + 73 - 19, 4, 4, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 4, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 + 56, y - j + 73 + 11, 9, 9, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 5, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 + 9, y - j + 73 + 67, 11, 9, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 6, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 - 47, y - j + 73 + 11, 6, 6, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 7, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 75 + 11, y - j + 73 - 54, 5, 5, mouseX, mouseY)) {
            this.getPlanetDataTooltip(poseStack, 8, mouseX, mouseY);
        }
    }

    public void getPlanetDataTooltip(PoseStack poseStack, int index, int mouseX, int mouseY) {
        this.tooltip = Lists.newArrayList();
        this.tooltip.add(CelestialUtil.getPlanetDetail(index).name());
        this.tooltip.add(CelestialUtil.getPlanetDetail(index).location());
        this.tooltip.add(CelestialUtil.getPlanetDetail(index).resources());
        this.tooltip.add(CelestialUtil.getPlanetDetail(index).moons());
        this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
    }
}

