/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.item.armor;

import com.shim.celestialexploration.util.CelestialUtil;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneProvider;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class SpacesuitRenderer
extends AzArmorRenderer {
    private static final ResourceLocation GEO = CelestialUtil.getModLoc("geo/spacesuit.geo.json");

    public SpacesuitRenderer(ResourceLocation texture) {
        super((AzRendererConfig)AzArmorRendererConfig.builder((ResourceLocation)GEO, (ResourceLocation)texture).build());
    }

    public SpacesuitRenderer(String texture) {
        this(CelestialUtil.getModLoc("textures/models/armor/" + texture + ".png"));
    }

    protected AzArmorRendererPipeline createPipeline(AzRendererConfig config) {
        return new AzArmorRendererPipeline(config, this){

            protected AzRendererPipelineContext<ItemStack> createContext(AzRendererPipeline<ItemStack> rendererPipeline) {
                return new AzArmorRendererPipelineContext(rendererPipeline){

                    public AzArmorBoneContext boneContext() {
                        return new AzArmorBoneContext(){
                            private AzBone armorWaistBone;

                            public AzBone getArmorLeggingTorsoBone(AzBakedModel model) {
                                return model.getBone("bipedWaist").orElse(null);
                            }

                            public void grabRelevantBones(AzBakedModel model, AzArmorBoneProvider boneProvider) {
                                super.grabRelevantBones(model, boneProvider);
                                this.armorWaistBone = this.getArmorLeggingTorsoBone(model);
                            }

                            public void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
                                this.setAllVisible(false);
                                this.setBoneVisible(this.armorWaistBone, false);
                                switch (currentSlot) {
                                    case HEAD: {
                                        this.setBoneVisible(this.head, true);
                                        break;
                                    }
                                    case CHEST: {
                                        this.setBoneVisible(this.body, true);
                                        this.setBoneVisible(this.rightArm, true);
                                        this.setBoneVisible(this.leftArm, true);
                                        break;
                                    }
                                    case LEGS: {
                                        this.setBoneVisible(this.armorWaistBone, true);
                                        this.setBoneVisible(this.rightLeg, true);
                                        this.setBoneVisible(this.leftLeg, true);
                                        break;
                                    }
                                    case FEET: {
                                        this.setBoneVisible(this.rightBoot, true);
                                        this.setBoneVisible(this.leftBoot, true);
                                        break;
                                    }
                                }
                            }

                            public void applyBaseTransformations(HumanoidModel<?> baseModel) {
                                super.applyBaseTransformations(baseModel);
                                if (this.armorWaistBone != null) {
                                    ModelPart modelPart = baseModel.f_102810_;
                                    RenderUtils.matchModelPartRot((ModelPart)modelPart, (AzBone)this.armorWaistBone);
                                    this.armorWaistBone.updatePosition(modelPart.f_104200_, -modelPart.f_104201_, modelPart.f_104202_);
                                }
                            }
                        };
                    }
                };
            }
        };
    }
}

