/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.vehicle.SpaceTaxi;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class TaxiAscensionTicksPacket {
    int taxiId;
    int ticks;

    public TaxiAscensionTicksPacket(int taxiId, int fuelTicks) {
        this.taxiId = taxiId;
        this.ticks = this.ticks;
    }

    public static void encoder(TaxiAscensionTicksPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.taxiId);
        buffer.writeInt(packet.ticks);
    }

    public static TaxiAscensionTicksPacket decoder(FriendlyByteBuf buffer) {
        return new TaxiAscensionTicksPacket(buffer.readInt(), buffer.readInt());
    }

    public static void handle(TaxiAscensionTicksPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.taxiId)) instanceof SpaceTaxi) {
                SpaceTaxi taxi = (SpaceTaxi)entity;
                taxi.setTicksAscended(message.ticks);
            }
        });
        context.setPacketHandled(true);
    }
}

