/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.vehicle.SpaceTaxi;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class TaxiDestinationPacket {
    int taxiId;
    BlockPos pos;
    ResourceKey<Level> dimensionId;

    public TaxiDestinationPacket(int taxiId, BlockPos pos, ResourceLocation dimensionId) {
        this(taxiId, pos, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionId));
    }

    public TaxiDestinationPacket(int taxiId, BlockPos pos, ResourceKey<Level> dimensionId) {
        this.taxiId = taxiId;
        this.pos = pos;
        this.dimensionId = dimensionId;
    }

    public static void encoder(TaxiDestinationPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.taxiId);
        buffer.m_130064_(packet.pos);
        buffer.m_130085_(packet.dimensionId.m_135782_());
    }

    public static TaxiDestinationPacket decoder(FriendlyByteBuf buffer) {
        return new TaxiDestinationPacket(buffer.readInt(), buffer.m_130135_(), buffer.m_130281_());
    }

    public static void handle(TaxiDestinationPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.taxiId)) instanceof SpaceTaxi) {
                SpaceTaxi taxi = (SpaceTaxi)entity;
                taxi.setDestination(message.pos, message.dimensionId);
            }
        });
        context.setPacketHandled(true);
    }
}

