/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CelestialJsonHelper {
    public static FluidStack getFluidStackFromJson(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe, String string) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)string);
        Fluid fluid = CelestialJsonHelper.getFluid(fluidName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            CompoundTag nbt = CraftingHelper.getNBT((JsonElement)json.get("nbt"));
            CompoundTag tmp = new CompoundTag();
            if (nbt.m_128441_("ForgeCaps")) {
                tmp.m_128365_("ForgeCaps", nbt.m_128423_("ForgeCaps"));
                nbt.m_128473_("ForgeCaps");
            }
            tmp.m_128365_("tag", (Tag)nbt);
            tmp.m_128359_("id", fluidName);
            tmp.m_128405_("Count", GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
            return FluidStack.loadFluidStackFromNBT((CompoundTag)tmp);
        }
        return new FluidStack(fluid, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
    }

    public static Fluid getFluid(String fluidName, boolean disallowsAirInRecipe) {
        ResourceLocation fluidKey = new ResourceLocation(fluidName);
        if (!ForgeRegistries.FLUIDS.containsKey(fluidKey)) {
            throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey);
        if (disallowsAirInRecipe && fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Invalid fluid: " + fluidName);
        }
        return Objects.requireNonNull(fluid);
    }
}

