/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util;

import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.registry.CelestialFluids;
import com.shim.celestialexploration.registry.CelestialGalaxies;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class CelestialUtil {
    @Deprecated
    public static final Map<String, Vec3> PLANET_LOCATION = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put((Object)"Mercury", (Object)new Vec3(1.0, 0.0, 1.0));
        dimension.put((Object)"Venus", (Object)new Vec3(0.0, 0.0, 2.0));
        dimension.put((Object)"Overworld", (Object)new Vec3(-2.0, 0.0, 0.0));
        dimension.put((Object)"Mars", (Object)new Vec3(1.0, 0.0, -3.0));
        dimension.put((Object)"Jupiter", (Object)new Vec3(6.0, 0.0, 2.0));
        dimension.put((Object)"Saturn", (Object)new Vec3(-2.0, 0.0, 10.0));
        dimension.put((Object)"Uranus", (Object)new Vec3(-15.0, 0.0, -3.0));
        dimension.put((Object)"Neptune", (Object)new Vec3(6.0, 0.0, -24.0));
    });
    @Deprecated
    protected static final Map<ResourceKey<Level>, Vec3> PLANET_LOCATIONS = new HashMap<ResourceKey<Level>, Vec3>();
    private static final ArrayList<CelestialBodyDetails> PLANET_DETAILS = (ArrayList)Util.m_137469_(new ArrayList(), list -> {
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.sun_name"), new Vec2(0.0f, 0.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.sun_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.mercury_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)1).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)1).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.mercury_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.venus_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)2).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)2).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.venus_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.overworld_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)3).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)3).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.overworld_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.overworld_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.mars_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)4).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)4).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.mars_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.jupiter_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)5).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)5).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.jupiter_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.jupiter_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.saturn_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)6).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)6).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.saturn_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.saturn_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.uranus_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)7).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)7).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.uranus_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.uranus_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.neptune_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)8).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)8).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.neptune_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.neptune_moons")));
    });

    public static ResourceLocation getModLoc(String texture) {
        return new ResourceLocation("celestialexploration", texture);
    }

    public static int getSpaceRatio() {
        return ((Galaxy)CelestialGalaxies.MILKY_WAY_GALAXY.get()).getGalaxyRatio();
    }

    @Deprecated
    public static Vec3 getPlanetLocation(ResourceKey<Level> dimension) {
        return PLANET_LOCATIONS.get(dimension);
    }

    @Deprecated
    public static Map<ResourceKey<Level>, Vec3> getPlanetLocations() {
        return PLANET_LOCATIONS;
    }

    @Deprecated
    public static Vec3 getPlanetaryChunkCoordinates(ResourceKey<Level> planet) {
        Vec3 coord = CelestialUtil.getPlanetLocation(planet);
        coord = new Vec3(coord.f_82479_ * (double)CelestialUtil.getSpaceRatio(), coord.f_82480_, coord.f_82481_ * (double)CelestialUtil.getSpaceRatio());
        return coord;
    }

    @Deprecated
    public static Vec3 getPlanetaryChunkCoordinates(int planetNum) {
        switch (planetNum) {
            case 1: {
                int x = 1;
                int z = 1;
                break;
            }
            case 2: {
                int x = 0;
                int z = 2;
                break;
            }
            case 3: {
                int x = -2;
                int z = 0;
                break;
            }
            case 4: {
                int x = 1;
                int z = -3;
                break;
            }
            case 5: {
                int x = 6;
                int z = 2;
                break;
            }
            case 6: {
                int x = -2;
                int z = 10;
                break;
            }
            case 7: {
                int x = -15;
                int z = -3;
                break;
            }
            case 8: {
                int x = 6;
                int z = -24;
                break;
            }
            default: {
                int x = 0;
                int z = 0;
            }
        }
        return new Vec3((double)(x *= CelestialUtil.getSpaceRatio()), 0.0, (double)(z *= CelestialUtil.getSpaceRatio()));
    }

    public static boolean isInRectangle(int centerX, int centerY, int radius, int x, int y) {
        return x >= centerX - radius && x <= centerX + radius && y >= centerY - radius && y <= centerY + radius;
    }

    public static boolean isPointInCircle(int centerX, int centerY, int radius, int x, int y) {
        if (CelestialUtil.isInRectangle(centerX, centerY, radius, x, y)) {
            int distanceSquared;
            int dx = centerX - x;
            int dy = centerY - y;
            int radiusSquared = radius * radius;
            return (distanceSquared = (dx *= dx) + (dy *= dy)) <= radiusSquared;
        }
        return false;
    }

    public static int getCalculatedCircleRadius(double radius) {
        return (int)(radius * (double)CelestialUtil.getSpaceRatio());
    }

    public static int getIdFromFluid(FluidStack fluidStack) {
        if (fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_)) {
            return 1;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_)) {
            return 2;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)CelestialFluids.MOLTEN_IRON.get())) {
            return 3;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)CelestialFluids.MOLTEN_STEEL.get())) {
            return 4;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)CelestialFluids.MOLTEN_COPPER.get())) {
            return 5;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)CelestialFluids.MOLTEN_GOLD.get())) {
            return 6;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)CelestialFluids.MOLTEN_ALUMINUM.get())) {
            return 8;
        }
        return 0;
    }

    public static FluidStack getFluidFromId(int id, int amount) {
        return switch (id) {
            case 1 -> new FluidStack((Fluid)Fluids.f_76193_, amount);
            case 2 -> new FluidStack((Fluid)Fluids.f_76195_, amount);
            case 3 -> new FluidStack((Fluid)CelestialFluids.MOLTEN_IRON.get(), amount);
            case 4 -> new FluidStack((Fluid)CelestialFluids.MOLTEN_STEEL.get(), amount);
            case 5 -> new FluidStack((Fluid)CelestialFluids.MOLTEN_COPPER.get(), amount);
            case 6 -> new FluidStack((Fluid)CelestialFluids.MOLTEN_GOLD.get(), amount);
            case 8 -> new FluidStack((Fluid)CelestialFluids.MOLTEN_ALUMINUM.get(), amount);
            default -> FluidStack.EMPTY;
        };
    }

    public static int getIdFromDimension(ResourceKey<Level> dimension) {
        if (dimension.equals(CelestialDimensions.MERCURY)) {
            return 1;
        }
        if (dimension.equals(CelestialDimensions.VENUS)) {
            return 2;
        }
        if (dimension.equals((Object)Level.f_46428_)) {
            return 3;
        }
        if (dimension.equals(CelestialDimensions.MOON)) {
            return 4;
        }
        if (dimension.equals(CelestialDimensions.MARS)) {
            return 5;
        }
        if (dimension.equals(CelestialDimensions.JUPITER)) {
            return 6;
        }
        return 0;
    }

    public static ResourceKey<Level> getDimensionFromId(int id) {
        return switch (id) {
            case 1 -> CelestialDimensions.MERCURY;
            case 2 -> CelestialDimensions.VENUS;
            case 3 -> Level.f_46428_;
            case 4 -> CelestialDimensions.MOON;
            case 5 -> CelestialDimensions.MARS;
            case 6 -> CelestialDimensions.JUPITER;
            default -> null;
        };
    }

    public static CelestialBodyDetails getPlanetDetail(int index) {
        return PLANET_DETAILS.get(index);
    }

    public record CelestialBodyDetails(Component name, Component location, Component resources, Component moons) {
        private static final Component coordinatesString = new TranslatableComponent("celestialexploration.planet_details.location");
        private static final Component moonsString = new TranslatableComponent("celestialexploration.planet_details.moons");
        private static final Component noMoons = new TranslatableComponent("celestialexploration.planet_details.no_moons");
        private static final Component resourcesString = new TranslatableComponent("celestialexploration.planet_details.resources");

        CelestialBodyDetails(Component name, Vec2 coordinates, Component resources) {
            this(name, coordinates, resources, noMoons);
        }

        CelestialBodyDetails(Component name, Vec2 coordinates, Component resources, Component moons) {
            this(name, (Component)new TextComponent(coordinatesString.getString() + ": " + (int)coordinates.f_82470_ + "," + (int)coordinates.f_82471_), (Component)new TextComponent(resourcesString.getString() + ": " + resources.getString()), (Component)new TextComponent(moonsString.getString() + ": " + moons.getString()));
        }
    }
}

