/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.gen;

import com.shim.celestialexploration.registry.CelestialEntities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class CelestialEntityGeneration {
    public static void onEntitySpawn(BiomeLoadingEvent event) {
        CelestialEntityGeneration.addEntityToMoonBiomes(event, (EntityType)CelestialEntities.LURKER.get(), 100, 1, 1);
        CelestialEntityGeneration.addEntityToMoonBiomes(event, (EntityType)CelestialEntities.LUNAR_SLIME.get(), 80, 0, 2);
        CelestialEntityGeneration.addEntityToMarsBiomes(event, (EntityType)CelestialEntities.MARS_MALLOW.get(), 30, 0, 2);
        CelestialEntityGeneration.addEntityToMarsBiomes(event, (EntityType)CelestialEntities.RUST_SLIME.get(), 80, 0, 2);
        CelestialEntityGeneration.addEntityToMarsBiomes(event, (EntityType)CelestialEntities.LURKER.get(), 100, 1, 1);
        CelestialEntityGeneration.addEntityToSpaceBiomes(event, (EntityType)CelestialEntities.LURKER.get(), 100, 1, 1);
    }

    private static void addEntityToMarsBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        boolean isBiomeSelected;
        boolean bl = isBiomeSelected = event.getName().toString().equals("celestialexploration:mars_craters") || event.getName().toString().equals("celestialexploration:mars_flats") || event.getName().toString().equals("celestialexploration:mars_dunes") || event.getName().toString().equals("celestialexploration:mars_eroded_flats") || event.getName().toString().equals("celestialexploration:mars_desert") || event.getName().toString().equals("celestialexploration:mars_dry_ice_peaks") || event.getName().toString().equals("celestialexploration:mars_dry_ice_flats") || event.getName().toString().equals("celestialexploration:mars_deep_craters");
        if (isBiomeSelected) {
            CelestialEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToMoonBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        boolean isBiomeSelected;
        boolean bl = isBiomeSelected = event.getName().toString().equals("celestialexploration:moon_craters") || event.getName().toString().equals("celestialexploration:moon_desert") || event.getName().toString().equals("celestialexploration:moon_lava_flats") || event.getName().toString().equals("celestialexploration:moon_lower_plains") || event.getName().toString().equals("celestialexploration:moon_plains");
        if (isBiomeSelected) {
            CelestialEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToSpaceBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        boolean isBiomeSelected;
        boolean bl = isBiomeSelected = event.getName().toString().equals("celestialexploration:asteroid_field") || event.getName().toString().equals("celestialexploration:large_asteroid") || event.getName().toString().equals("celestialexploration:sparse_asteroid_field");
        if (isBiomeSelected) {
            CelestialEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            CelestialEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    @SafeVarargs
    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            CelestialEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllOverworldBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND) && !event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) {
            CelestialEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomesNoNether(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomesNoEnd(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = event.getSpawns().getSpawner(type.m_20674_());
        base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
    }
}

