/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.renderer;

import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.world.renderer.CallistoSkyHandler;
import com.shim.celestialexploration.world.renderer.EuropaSkyHandler;
import com.shim.celestialexploration.world.renderer.GanymedeSkyHandler;
import com.shim.celestialexploration.world.renderer.IoSkyHandler;
import com.shim.celestialexploration.world.renderer.JupiterSkyHandler;
import com.shim.celestialexploration.world.renderer.MarsSkyHandler;
import com.shim.celestialexploration.world.renderer.MercurySkyHandler;
import com.shim.celestialexploration.world.renderer.MoonSkyHandler;
import com.shim.celestialexploration.world.renderer.SpaceSkyHandler;
import com.shim.celestialexploration.world.renderer.StormWeatherHandler;
import com.shim.celestialexploration.world.renderer.StormWeatherParticleHandler;
import com.shim.celestialexploration.world.renderer.VenusSkyHandler;
import com.shim.celestialexploration.world.renderer.VenusWeatherHandler;
import com.shim.celestialexploration.world.renderer.VenusWeatherParticleHandler;
import com.shim.celestiallib.api.world.renderer.DimensionRenderers;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;

@OnlyIn(value=Dist.CLIENT)
public class CelestialDimensionRenderers
extends DimensionRenderers {
    public static void setDimensionEffects() {
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.MARS.m_135782_(), (Object)new MarsEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.MOON.m_135782_(), (Object)new MoonEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.MILKY_WAY.m_135782_(), (Object)new SpaceEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.VENUS.m_135782_(), (Object)new VenusEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.MERCURY.m_135782_(), (Object)new MercuryEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.JUPITER.m_135782_(), (Object)new JupiterEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.EUROPA.m_135782_(), (Object)new EuropaEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.CALLISTO.m_135782_(), (Object)new CallistoEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.IO.m_135782_(), (Object)new IoEffects());
        DimensionSpecialEffects.f_108857_.put((Object)CelestialDimensions.GANYMEDE.m_135782_(), (Object)new GanymedeEffects());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MarsEffects
    extends DimensionRenderers.PlanetEffects {
        private final float[] sunriseCol = new float[4];

        public MarsEffects() {
            super((ISkyRenderHandler)new MarsSkyHandler(), (IWeatherRenderHandler)new StormWeatherHandler(), (IWeatherParticleRenderHandler)new StormWeatherParticleHandler());
        }

        public float[] m_7518_(float p_230492_1_, float p_230492_2_) {
            float f = 0.4f;
            float f1 = (float)(Math.cos(p_230492_1_ * ((float)Math.PI * 2)) - 0.0);
            float f2 = -0.0f;
            if (f1 >= -0.4f && f1 <= 0.4f) {
                float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
                float f4 = (float)(1.0 - (1.0 - Math.sin(f3 * (float)Math.PI)) * (double)0.99f);
                f4 *= f4;
                this.sunriseCol[0] = f3 * 0.3f - 5.7f;
                this.sunriseCol[1] = f3 * f3 * 0.7f + 3.2f;
                this.sunriseCol[2] = f3 * f3 * 0.0f + 3.2f;
                this.sunriseCol[3] = f4;
                return this.sunriseCol;
            }
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MoonEffects
    extends DimensionRenderers.PlanetEffects {
        public MoonEffects() {
            super((ISkyRenderHandler)new MoonSkyHandler(), null, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SpaceEffects
    extends DimensionRenderers.PlanetEffects {
        ISkyRenderHandler skyHandler = new SpaceSkyHandler();

        public SpaceEffects() {
            super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, true, false, (ISkyRenderHandler)new SpaceSkyHandler(), null, null);
        }

        public Vec3 m_5927_(Vec3 color, float brightness) {
            return color;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VenusEffects
    extends DimensionRenderers.PlanetEffects {
        public VenusEffects() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, true, (ISkyRenderHandler)new VenusSkyHandler(), (IWeatherRenderHandler)new VenusWeatherHandler(), (IWeatherParticleRenderHandler)new VenusWeatherParticleHandler());
        }

        public Vec3 m_5927_(Vec3 p_108901_, float p_108902_) {
            return p_108901_;
        }

        public boolean m_5781_(int x, int z) {
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MercuryEffects
    extends DimensionRenderers.PlanetEffects {
        public MercuryEffects() {
            super((ISkyRenderHandler)new MercurySkyHandler(), null, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class JupiterEffects
    extends DimensionRenderers.PlanetEffects {
        public JupiterEffects() {
            super(416.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false, (ISkyRenderHandler)new JupiterSkyHandler(), (IWeatherRenderHandler)new StormWeatherHandler(), (IWeatherParticleRenderHandler)new StormWeatherParticleHandler());
        }

        public boolean m_5781_(int x, int z) {
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EuropaEffects
    extends DimensionRenderers.PlanetEffects {
        public EuropaEffects() {
            super((ISkyRenderHandler)new EuropaSkyHandler(), null, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CallistoEffects
    extends DimensionRenderers.PlanetEffects {
        public CallistoEffects() {
            super((ISkyRenderHandler)new CallistoSkyHandler(), null, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class IoEffects
    extends DimensionRenderers.PlanetEffects {
        public IoEffects() {
            super((ISkyRenderHandler)new IoSkyHandler(), null, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GanymedeEffects
    extends DimensionRenderers.PlanetEffects {
        public GanymedeEffects() {
            super((ISkyRenderHandler)new GanymedeSkyHandler(), null, null);
        }
    }
}

