/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.world.structures.CelestialConfiguration;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class CelestialPlacement {
    public static Optional<PieceGenerator<CelestialConfiguration>> addPieces(PieceGeneratorSupplier.Context<CelestialConfiguration> p_210285_, PieceFactory p_210286_, BlockPos p_210287_, boolean p_210288_, boolean p_210289_) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(p_210285_.f_197354_(), p_210285_.f_197355_().f_45578_, p_210285_.f_197355_().f_45579_);
        RegistryAccess registryaccess = p_210285_.f_197360_();
        CelestialConfiguration jigsawconfiguration = (CelestialConfiguration)p_210285_.f_197356_();
        ChunkGenerator chunkgenerator = p_210285_.f_197352_();
        StructureManager structuremanager = p_210285_.f_197359_();
        LevelHeightAccessor levelheightaccessor = p_210285_.f_197357_();
        Predicate predicate = p_210285_.f_197358_();
        StructureFeature.m_67096_();
        Registry registry = registryaccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)jigsawconfiguration.startPool().m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_210585_((Random)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolelementstructurepiece = p_210286_.create(structuremanager, structurepoolelement, p_210287_, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_207470_(structuremanager, p_210287_, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = p_210289_ ? p_210287_.m_123342_() + chunkgenerator.m_156174_(i, j, Heightmap.Types.WORLD_SURFACE_WG, levelheightaccessor) : p_210287_.m_123342_();
        if (!predicate.test(chunkgenerator.m_203495_(QuartPos.m_175400_((int)i), QuartPos.m_175400_((int)k), QuartPos.m_175400_((int)j)))) {
            return Optional.empty();
        }
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        return Optional.of((p_210282_, p_210283_) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (jigsawconfiguration.maxDepth() > 0) {
                int i1 = 80;
                AABB aabb = new AABB((double)(i - 80), (double)(k - 80), (double)(j - 80), (double)(i + 80 + 1), (double)(k + 80 + 1), (double)(j + 80 + 1));
                Placer jigsawplacement$placer = new Placer((Registry<StructureTemplatePool>)registry, jigsawconfiguration.maxDepth(), p_210286_, chunkgenerator, structuremanager, list, (Random)worldgenrandom);
                jigsawplacement$placer.placing.addLast(new PieceState(poolelementstructurepiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_)), 0));
                while (!jigsawplacement$placer.placing.isEmpty()) {
                    PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
                    jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, p_210288_, levelheightaccessor);
                }
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_210282_).m_142679_(arg_0));
            }
        });
    }

    public static void addPieces(RegistryAccess p_210291_, PoolElementStructurePiece p_210292_, int p_210293_, PieceFactory p_210294_, ChunkGenerator p_210295_, StructureManager p_210296_, List<? super PoolElementStructurePiece> p_210297_, Random p_210298_, LevelHeightAccessor p_210299_) {
        Registry registry = p_210291_.m_175515_(Registry.f_122884_);
        Placer jigsawplacement$placer = new Placer((Registry<StructureTemplatePool>)registry, p_210293_, p_210294_, p_210295_, p_210296_, p_210297_, p_210298_);
        jigsawplacement$placer.placing.addLast(new PieceState(p_210292_, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.f_83036_), 0));
        while (!jigsawplacement$placer.placing.isEmpty()) {
            PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, false, p_210299_);
        }
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece create(StructureManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final PieceFactory factory;
        private final ChunkGenerator chunkGenerator;
        private final StructureManager structureManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final Random random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> p_210323_, int p_210324_, PieceFactory p_210325_, ChunkGenerator p_210326_, StructureManager p_210327_, List<? super PoolElementStructurePiece> p_210328_, Random p_210329_) {
            this.pools = p_210323_;
            this.maxDepth = p_210324_;
            this.factory = p_210325_;
            this.chunkGenerator = p_210326_;
            this.structureManager = p_210327_;
            this.pieces = p_210328_;
            this.random = p_210329_;
        }

        void tryPlacingChildren(PoolElementStructurePiece p_210334_, MutableObject<VoxelShape> p_210335_, int p_210336_, boolean p_210337_, LevelHeightAccessor p_210338_) {
            StructurePoolElement structurepoolelement = p_210334_.m_209918_();
            BlockPos blockpos = p_210334_.m_72646_();
            Rotation rotation = p_210334_.m_6830_();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.m_210539_();
            boolean flag = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = p_210334_.m_73547_();
            int i = boundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.m_207245_(this.structureManager, blockpos, rotation, this.random)) {
                Direction direction = JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_);
                BlockPos blockpos1 = structuretemplate$structureblockinfo.f_74675_;
                BlockPos blockpos2 = blockpos1.m_142300_(direction);
                int j = blockpos1.m_123342_() - i;
                int k = -1;
                ResourceLocation resourcelocation = new ResourceLocation(structuretemplate$structureblockinfo.f_74677_.m_128461_("pool"));
                Optional optional = this.pools.m_6612_(resourcelocation);
                if (optional.isPresent() && (((StructureTemplatePool)optional.get()).m_210590_() != 0 || Objects.equals(resourcelocation, Pools.f_127186_.m_135782_()))) {
                    ResourceLocation resourcelocation1 = ((StructureTemplatePool)optional.get()).m_210573_();
                    Optional optional1 = this.pools.m_6612_(resourcelocation1);
                    if (optional1.isPresent() && (((StructureTemplatePool)optional1.get()).m_210590_() != 0 || Objects.equals(resourcelocation1, Pools.f_127186_.m_135782_()))) {
                        StructurePoolElement structurepoolelement1;
                        MutableObject<VoxelShape> mutableobject1;
                        boolean flag1 = boundingbox.m_71051_((Vec3i)blockpos2);
                        if (flag1) {
                            mutableobject1 = mutableobject;
                            if (mutableobject.getValue() == null) {
                                mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)));
                            }
                        } else {
                            mutableobject1 = p_210335_;
                        }
                        ArrayList list = Lists.newArrayList();
                        if (p_210336_ != this.maxDepth) {
                            list.addAll(((StructureTemplatePool)optional.get()).m_210588_(this.random));
                        }
                        list.addAll(((StructureTemplatePool)optional1.get()).m_210588_(this.random));
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (structurepoolelement1 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                            for (Rotation rotation1 : Rotation.m_55958_((Random)this.random)) {
                                List list1 = structurepoolelement1.m_207245_(this.structureManager, BlockPos.f_121853_, rotation1, this.random);
                                BoundingBox boundingbox1 = structurepoolelement1.m_207470_(this.structureManager, BlockPos.f_121853_, rotation1);
                                int l = p_210337_ && boundingbox1.m_71057_() <= 16 ? list1.stream().mapToInt(p_210332_ -> {
                                    if (!boundingbox1.m_71051_((Vec3i)p_210332_.f_74675_.m_142300_(JigsawBlock.m_54250_((BlockState)p_210332_.f_74676_)))) {
                                        return 0;
                                    }
                                    ResourceLocation resourcelocation2 = new ResourceLocation(p_210332_.f_74677_.m_128461_("pool"));
                                    Optional optional2 = this.pools.m_6612_(resourcelocation2);
                                    Optional<Integer> optional3 = optional2.flatMap(p_210344_ -> this.pools.m_6612_(p_210344_.m_210573_()));
                                    int j3 = optional2.map(p_210342_ -> p_210342_.m_210580_(this.structureManager)).orElse(0);
                                    int k3 = optional3.map(p_210340_ -> p_210340_.m_210580_(this.structureManager)).orElse(0);
                                    return Math.max(j3, k3);
                                }).max().orElse(0) : 0;
                                for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo1 : list1) {
                                    int l2;
                                    int l1;
                                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo, (StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo1)) continue;
                                    BlockPos blockpos3 = structuretemplate$structureblockinfo1.f_74675_;
                                    BlockPos blockpos4 = blockpos2.m_141950_((Vec3i)blockpos3);
                                    BoundingBox boundingbox2 = structurepoolelement1.m_207470_(this.structureManager, blockpos4, rotation1);
                                    int i1 = boundingbox2.m_162396_();
                                    StructureTemplatePool.Projection structuretemplatepool$projection1 = structurepoolelement1.m_210539_();
                                    boolean flag2 = structuretemplatepool$projection1 == StructureTemplatePool.Projection.RIGID;
                                    int j1 = blockpos3.m_123342_();
                                    int k1 = j - j1 + JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_).m_122430_();
                                    if (flag && flag2) {
                                        l1 = i + k1;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.m_156174_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_210338_);
                                        }
                                        l1 = k - j1;
                                    }
                                    int i2 = l1 - i1;
                                    BoundingBox boundingbox3 = boundingbox2.m_71045_(0, i2, 0);
                                    BlockPos blockpos5 = blockpos4.m_142082_(0, i2, 0);
                                    if (l > 0) {
                                        int j2 = Math.max(l + 1, boundingbox3.m_162400_() - boundingbox3.m_162396_());
                                        boundingbox3.m_162371_(new BlockPos(boundingbox3.m_162395_(), boundingbox3.m_162396_() + j2, boundingbox3.m_162398_()));
                                    }
                                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                                    mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.f_82685_));
                                    int i3 = p_210334_.m_72647_();
                                    int k2 = flag2 ? i3 - k1 : structurepoolelement1.m_210540_();
                                    PoolElementStructurePiece poolelementstructurepiece = this.factory.create(this.structureManager, structurepoolelement1, blockpos5, k2, rotation1, boundingbox3);
                                    if (flag) {
                                        l2 = i + j;
                                    } else if (flag2) {
                                        l2 = l1 + j1;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.m_156174_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_210338_);
                                        }
                                        l2 = k + k1 / 2;
                                    }
                                    p_210334_.m_209916_(new JigsawJunction(blockpos2.m_123341_(), l2 - j + i3, blockpos2.m_123343_(), k1, structuretemplatepool$projection1));
                                    poolelementstructurepiece.m_209916_(new JigsawJunction(blockpos1.m_123341_(), l2 - j1 + k2, blockpos1.m_123343_(), -k1, structuretemplatepool$projection));
                                    this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                                    if (p_210336_ + 1 > this.maxDepth) continue block0;
                                    this.placing.addLast(new PieceState(poolelementstructurepiece, mutableobject1, p_210336_ + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    CelestialExploration.LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)resourcelocation1);
                    continue;
                }
                CelestialExploration.LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcelocation);
            }
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece p_210311_, MutableObject<VoxelShape> p_210312_, int p_210313_) {
            this.piece = p_210311_;
            this.free = p_210312_;
            this.depth = p_210313_;
        }
    }
}

