/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.shim.celestialexploration.entity.vehicle.MagCartChest;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialLootTables;
import com.shim.celestialexploration.registry.CelestialStructurePieceType;
import com.shim.celestialexploration.world.structures.ResearchTunnelStructure;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.slf4j.Logger;

public class ResearchTunnelPieces {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_SHAFT_WIDTH = 3;
    private static final int DEFAULT_SHAFT_HEIGHT = 3;
    private static final int DEFAULT_SHAFT_LENGTH = 5;
    private static final int MAX_PILLAR_HEIGHT = 20;
    private static final int MAX_CHAIN_HEIGHT = 50;
    private static final int MAX_DEPTH = 8;
    public static final int MAGIC_START_Y = 50;

    private static ResearchTunnelPiece createRandomShaftPiece(StructurePieceAccessor p_162481_, Random p_162482_, int p_162483_, int p_162484_, int p_162485_, @Nullable Direction p_162486_, int p_162487_, ResearchTunnelStructure.Type p_162488_) {
        int i = p_162482_.nextInt(100);
        if (i >= 80) {
            BoundingBox boundingbox = ResearchTunnelCrossing.findCrossing(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if (boundingbox != null) {
                return new ResearchTunnelCrossing(p_162487_, boundingbox, p_162486_, p_162488_);
            }
        } else if (i >= 70) {
            BoundingBox boundingbox1 = ResearchTunnelStairs.findStairs(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if (boundingbox1 != null) {
                return new ResearchTunnelStairs(p_162487_, boundingbox1, p_162486_, p_162488_);
            }
        } else {
            BoundingBox boundingbox2 = ResearchTunnelCorridor.findCorridorSize(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if (boundingbox2 != null) {
                return new ResearchTunnelCorridor(p_162487_, p_162482_, boundingbox2, p_162486_, p_162488_);
            }
        }
        return null;
    }

    static ResearchTunnelPiece generateAndAddPiece(StructurePiece p_162472_, StructurePieceAccessor p_162473_, Random p_162474_, int p_162475_, int p_162476_, int p_162477_, Direction p_162478_, int p_162479_) {
        if (p_162479_ > 8) {
            return null;
        }
        if (Math.abs(p_162475_ - p_162472_.m_73547_().m_162395_()) <= 80 && Math.abs(p_162477_ - p_162472_.m_73547_().m_162398_()) <= 80) {
            ResearchTunnelStructure.Type tunnelfeature$type = ((ResearchTunnelPiece)p_162472_).type;
            ResearchTunnelPiece tunnelpieces$tunnelpiece = ResearchTunnelPieces.createRandomShaftPiece(p_162473_, p_162474_, p_162475_, p_162476_, p_162477_, p_162478_, p_162479_ + 1, tunnelfeature$type);
            if (tunnelpieces$tunnelpiece != null) {
                p_162473_.m_142679_((StructurePiece)tunnelpieces$tunnelpiece);
                tunnelpieces$tunnelpiece.m_142537_(p_162472_, p_162473_, p_162474_);
            }
            return tunnelpieces$tunnelpiece;
        }
        return null;
    }

    public static class ResearchTunnelCrossing
    extends ResearchTunnelPiece {
        private final Direction direction;
        private final boolean isTwoFloored;

        public ResearchTunnelCrossing(CompoundTag p_192041_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_CROSSING, p_192041_);
            this.isTwoFloored = p_192041_.m_128471_("tf");
            this.direction = Direction.m_122407_((int)p_192041_.m_128451_("D"));
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192051_, CompoundTag p_192052_) {
            super.m_183620_(p_192051_, p_192052_);
            p_192052_.m_128379_("tf", this.isTwoFloored);
            p_192052_.m_128405_("D", this.direction.m_122416_());
        }

        public ResearchTunnelCrossing(int p_71430_, BoundingBox p_71431_, @Nullable Direction p_71432_, ResearchTunnelStructure.Type p_71433_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_CROSSING, p_71430_, p_71433_, p_71431_);
            this.direction = p_71432_;
            this.isTwoFloored = p_71431_.m_71057_() > 3;
        }

        @Nullable
        public static BoundingBox findCrossing(StructurePieceAccessor p_162564_, Random p_162565_, int p_162566_, int p_162567_, int p_162568_, Direction p_162569_) {
            int i = p_162565_.nextInt(4) == 0 ? 6 : 2;
            BoundingBox boundingbox = switch (p_162569_) {
                case Direction.NORTH -> new BoundingBox(-1, 0, -4, 3, i, 0);
                case Direction.SOUTH -> new BoundingBox(-1, 0, 0, 3, i, 4);
                case Direction.WEST -> new BoundingBox(-4, 0, -1, 0, i, 3);
                case Direction.EAST -> new BoundingBox(0, 0, -1, 4, i, 3);
                default -> new BoundingBox(-1, 0, -4, 3, i, 0);
            };
            boundingbox.m_162367_(p_162566_, p_162567_, p_162568_);
            return p_162564_.m_141921_(boundingbox) != null ? null : boundingbox;
        }

        public void m_142537_(StructurePiece p_162560_, StructurePieceAccessor p_162561_, Random p_162562_) {
            int i = this.m_73548_();
            switch (this.direction) {
                default: {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, i);
                }
            }
            if (this.isTwoFloored) {
                if (p_162562_.nextBoolean()) {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                }
                if (p_162562_.nextBoolean()) {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() + 1, Direction.WEST, i);
                }
                if (p_162562_.nextBoolean()) {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() + 1, Direction.EAST, i);
                }
                if (p_162562_.nextBoolean()) {
                    ResearchTunnelPieces.generateAndAddPiece(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                }
            }
        }

        public void m_183269_(WorldGenLevel p_192043_, StructureFeatureManager p_192044_, ChunkGenerator p_192045_, Random p_192046_, BoundingBox p_192047_, ChunkPos p_192048_, BlockPos p_192049_) {
            if (!this.edgesLiquid((BlockGetter)p_192043_, p_192047_)) {
                BlockState blockstate = this.type.getPlanksState();
                if (this.isTwoFloored) {
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3 - 1, this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 3 - 1, this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162400_() - 2, this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_(), this.f_73383_.m_162400_() - 2, this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                } else {
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                    this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                }
                this.placeSupportPillar(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162400_());
                this.placeSupportPillar(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - 1, this.f_73383_.m_162400_());
                this.placeSupportPillar(p_192043_, p_192047_, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162400_());
                this.placeSupportPillar(p_192043_, p_192047_, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - 1, this.f_73383_.m_162400_());
                int i = this.f_73383_.m_162396_() - 1;
                for (int j = this.f_73383_.m_162395_(); j <= this.f_73383_.m_162399_(); ++j) {
                    for (int k = this.f_73383_.m_162398_(); k <= this.f_73383_.m_162401_(); ++k) {
                        this.setPlanksBlock(p_192043_, p_192047_, blockstate, j, i, k);
                    }
                }
            }
        }

        private void placeSupportPillar(WorldGenLevel p_71446_, BoundingBox p_71447_, int p_71448_, int p_71449_, int p_71450_, int p_71451_) {
            if (!this.m_73398_((BlockGetter)p_71446_, p_71448_, p_71451_ + 1, p_71450_, p_71447_).m_60795_()) {
                this.m_73441_(p_71446_, p_71447_, p_71448_, p_71449_, p_71450_, p_71448_, p_71451_, p_71450_, this.type.getPlanksState(), f_73382_, false);
            }
        }
    }

    public static class ResearchTunnelStairs
    extends ResearchTunnelPiece {
        public ResearchTunnelStairs(int p_71513_, BoundingBox p_71514_, Direction p_71515_, ResearchTunnelStructure.Type p_71516_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_STAIRS, p_71513_, p_71516_, p_71514_);
            this.m_73519_(p_71515_);
        }

        public ResearchTunnelStairs(CompoundTag p_192070_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_STAIRS, p_192070_);
        }

        @Nullable
        public static BoundingBox findStairs(StructurePieceAccessor p_162615_, Random p_162616_, int p_162617_, int p_162618_, int p_162619_, Direction p_162620_) {
            BoundingBox boundingbox = switch (p_162620_) {
                default -> new BoundingBox(0, -5, -8, 2, 2, 0);
                case Direction.SOUTH -> new BoundingBox(0, -5, 0, 2, 2, 8);
                case Direction.WEST -> new BoundingBox(-8, -5, 0, 0, 2, 2);
                case Direction.EAST -> new BoundingBox(0, -5, 0, 8, 2, 2);
            };
            boundingbox.m_162367_(p_162617_, p_162618_, p_162619_);
            return p_162615_.m_141921_(boundingbox) != null ? null : boundingbox;
        }

        public void m_142537_(StructurePiece p_162611_, StructurePieceAccessor p_162612_, Random p_162613_) {
            int i = this.m_73548_();
            Direction direction = this.m_73549_();
            if (direction != null) {
                switch (direction) {
                    default: {
                        ResearchTunnelPieces.generateAndAddPiece(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        ResearchTunnelPieces.generateAndAddPiece(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        ResearchTunnelPieces.generateAndAddPiece(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        ResearchTunnelPieces.generateAndAddPiece(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.EAST, i);
                    }
                }
            }
        }

        public void m_183269_(WorldGenLevel p_192072_, StructureFeatureManager p_192073_, ChunkGenerator p_192074_, Random p_192075_, BoundingBox p_192076_, ChunkPos p_192077_, BlockPos p_192078_) {
            if (!this.edgesLiquid((BlockGetter)p_192072_, p_192076_)) {
                this.m_73441_(p_192072_, p_192076_, 0, 5, 0, 2, 7, 1, f_73382_, f_73382_, false);
                this.m_73441_(p_192072_, p_192076_, 0, 0, 7, 2, 2, 8, f_73382_, f_73382_, false);
                for (int i = 0; i < 5; ++i) {
                    this.m_73441_(p_192072_, p_192076_, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, f_73382_, f_73382_, false);
                }
            }
        }
    }

    public static class ResearchTunnelCorridor
    extends ResearchTunnelPiece {
        private final boolean hasRails;
        private final boolean spiderCorridor;
        private boolean hasPlacedSpider;
        private final int numSections;

        public ResearchTunnelCorridor(CompoundTag p_192028_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_CORRIDOR, p_192028_);
            this.hasRails = p_192028_.m_128471_("hr");
            this.spiderCorridor = p_192028_.m_128471_("sc");
            this.hasPlacedSpider = p_192028_.m_128471_("hps");
            this.numSections = p_192028_.m_128451_("Num");
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192038_, CompoundTag p_192039_) {
            super.m_183620_(p_192038_, p_192039_);
            p_192039_.m_128379_("hr", this.hasRails);
            p_192039_.m_128379_("sc", this.spiderCorridor);
            p_192039_.m_128379_("hps", this.hasPlacedSpider);
            p_192039_.m_128405_("Num", this.numSections);
        }

        public ResearchTunnelCorridor(int p_71373_, Random p_71374_, BoundingBox p_71375_, Direction p_71376_, ResearchTunnelStructure.Type p_71377_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_CORRIDOR, p_71373_, p_71377_, p_71375_);
            this.m_73519_(p_71376_);
            this.hasRails = p_71374_.nextInt(3) == 0;
            this.spiderCorridor = !this.hasRails && p_71374_.nextInt(23) == 0;
            this.numSections = this.m_73549_().m_122434_() == Direction.Axis.Z ? p_71375_.m_71058_() / 5 : p_71375_.m_71056_() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static BoundingBox findCorridorSize(StructurePieceAccessor p_162538_, Random p_162539_, int p_162540_, int p_162541_, int p_162542_, Direction p_162543_) {
            int i = p_162539_.nextInt(3) + 2;
            while (i > 0) {
                int j = i * 5;
                BoundingBox boundingbox = switch (p_162543_) {
                    default -> new BoundingBox(0, 0, -(j - 1), 2, 2, 0);
                    case Direction.SOUTH -> new BoundingBox(0, 0, 0, 2, 2, j - 1);
                    case Direction.WEST -> new BoundingBox(-(j - 1), 0, 0, 0, 2, 2);
                    case Direction.EAST -> new BoundingBox(0, 0, 0, j - 1, 2, 2);
                };
                boundingbox.m_162367_(p_162540_, p_162541_, p_162542_);
                if (p_162538_.m_141921_(boundingbox) == null) {
                    return boundingbox;
                }
                --i;
            }
            return null;
        }

        public void m_142537_(StructurePiece p_162534_, StructurePieceAccessor p_162535_, Random p_162536_) {
            block24: {
                int i = this.m_73548_();
                int j = p_162536_.nextInt(4);
                Direction direction = this.m_73549_();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j <= 1) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), Direction.WEST, i);
                                break;
                            }
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() - 3, Direction.WEST, i);
                                break;
                            }
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), direction, i);
                                break;
                            }
                            if (j == 2) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                                break;
                            }
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), direction, i);
                                break;
                            }
                            if (j == 2) {
                                ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() - 3, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                                break;
                            }
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() - 3, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int i1 = this.f_73383_.m_162395_() + 3;
                    while (i1 + 3 <= this.f_73383_.m_162399_()) {
                        int j1 = p_162536_.nextInt(5);
                        if (j1 == 0) {
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, i1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, i + 1);
                        } else if (j1 == 1) {
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, i1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.f_73383_.m_162398_() + 3;
                    while (k + 3 <= this.f_73383_.m_162401_()) {
                        int l = p_162536_.nextInt(5);
                        if (l == 0) {
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            ResearchTunnelPieces.generateAndAddPiece(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean m_5606_(WorldGenLevel level, BoundingBox p_71408_, Random p_71409_, int p_71410_, int p_71411_, int p_71412_, ResourceLocation p_71413_) {
            BlockPos.MutableBlockPos blockpos = this.m_163582_(p_71410_, p_71411_, p_71412_);
            if (p_71408_.m_71051_((Vec3i)blockpos) && level.m_8055_((BlockPos)blockpos).m_60795_() && !level.m_8055_(blockpos.m_7495_()).m_60795_()) {
                BlockState blockstate = (BlockState)((Block)CelestialBlocks.MAGRAIL.get()).m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)(p_71409_.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                this.m_73434_(level, blockstate, p_71410_, p_71411_, p_71412_, p_71408_);
                MagCartChest magcartchest = new MagCartChest((Level)level.m_6018_(), (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5);
                magcartchest.setLootTable(p_71413_, p_71409_.nextLong());
                level.m_7967_((Entity)magcartchest);
                return true;
            }
            return false;
        }

        public void m_183269_(WorldGenLevel p_192030_, StructureFeatureManager p_192031_, ChunkGenerator p_192032_, Random p_192033_, BoundingBox p_192034_, ChunkPos p_192035_, BlockPos p_192036_) {
            if (!this.edgesLiquid((BlockGetter)p_192030_, p_192034_)) {
                boolean i = false;
                int j = 2;
                boolean k = false;
                int l = 2;
                int i1 = this.numSections * 5 - 1;
                BlockState blockstate = this.type.getPlanksState();
                this.m_73441_(p_192030_, p_192034_, 0, 0, 0, 2, 1, i1, f_73382_, f_73382_, false);
                this.m_73476_(p_192030_, p_192034_, p_192033_, 0.8f, 0, 2, 0, 2, 2, i1, f_73382_, f_73382_, false, false);
                if (this.spiderCorridor) {
                    this.m_73476_(p_192030_, p_192034_, p_192033_, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.f_50033_.m_49966_(), f_73382_, false, true);
                }
                for (int j1 = 0; j1 < this.numSections; ++j1) {
                    int k1 = 2 + j1 * 5;
                    this.placeSupport(p_192030_, p_192034_, 0, 0, k1, 2, 2, p_192033_);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.1f, 0, 2, k1 - 1);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.1f, 2, 2, k1 - 1);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.1f, 0, 2, k1 + 1);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.1f, 2, 2, k1 + 1);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.05f, 0, 2, k1 - 2);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.05f, 2, 2, k1 - 2);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.05f, 0, 2, k1 + 2);
                    this.maybePlaceCobWeb(p_192030_, p_192034_, p_192033_, 0.05f, 2, 2, k1 + 2);
                    if (p_192033_.nextInt(100) == 0) {
                        this.m_5606_(p_192030_, p_192034_, p_192033_, 2, 0, k1 - 1, CelestialLootTables.RESEARCH_TUNNEL);
                    }
                    if (p_192033_.nextInt(100) == 0) {
                        this.m_5606_(p_192030_, p_192034_, p_192033_, 0, 0, k1 + 1, CelestialLootTables.RESEARCH_TUNNEL);
                    }
                    if (!this.spiderCorridor || this.hasPlacedSpider) continue;
                    boolean l1 = true;
                    int i2 = k1 - 1 + p_192033_.nextInt(3);
                    BlockPos.MutableBlockPos blockpos = this.m_163582_(1, 0, i2);
                    if (!p_192034_.m_71051_((Vec3i)blockpos) || !this.m_73414_((LevelReader)p_192030_, 1, 0, i2, p_192034_)) continue;
                    this.hasPlacedSpider = true;
                    p_192030_.m_7731_((BlockPos)blockpos, Blocks.f_50085_.m_49966_(), 2);
                    BlockEntity blockentity = p_192030_.m_7702_((BlockPos)blockpos);
                    if (!(blockentity instanceof SpawnerBlockEntity)) continue;
                    ((SpawnerBlockEntity)blockentity).m_59801_().m_45462_((EntityType)CelestialEntities.VOID_CRAWLER.get());
                }
                for (int j2 = 0; j2 <= 2; ++j2) {
                    for (int l2 = 0; l2 <= i1; ++l2) {
                        this.setPlanksBlock(p_192030_, p_192034_, blockstate, j2, -1, l2);
                    }
                }
                int k2 = 2;
                this.placeDoubleLowerOrUpperSupport(p_192030_, p_192034_, 0, -1, 2);
                if (this.numSections > 1) {
                    int i3 = i1 - 2;
                    this.placeDoubleLowerOrUpperSupport(p_192030_, p_192034_, 0, -1, i3);
                }
                if (this.hasRails) {
                    BlockState blockstate1 = (BlockState)((Block)CelestialBlocks.MAGRAIL.get()).m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.NORTH_SOUTH);
                    for (int j3 = 0; j3 <= i1; ++j3) {
                        BlockState blockstate2 = this.m_73398_((BlockGetter)p_192030_, 1, -1, j3, p_192034_);
                        if (blockstate2.m_60795_() || !blockstate2.m_60804_((BlockGetter)p_192030_, (BlockPos)this.m_163582_(1, -1, j3))) continue;
                        float f = this.m_73414_((LevelReader)p_192030_, 1, 0, j3, p_192034_) ? 0.7f : 0.9f;
                        this.m_73491_(p_192030_, p_192034_, p_192033_, f, 1, 0, j3, blockstate1);
                    }
                }
            }
        }

        private void placeDoubleLowerOrUpperSupport(WorldGenLevel p_162513_, BoundingBox p_162514_, int p_162515_, int p_162516_, int p_162517_) {
            BlockState blockstate = this.type.getWoodState();
            BlockState blockstate1 = this.type.getPlanksState();
            if (this.m_73398_((BlockGetter)p_162513_, p_162515_, p_162516_, p_162517_, p_162514_).m_60713_(blockstate1.m_60734_())) {
                this.fillPillarDownOrChainUp(p_162513_, blockstate, p_162515_, p_162516_, p_162517_, p_162514_);
            }
            if (this.m_73398_((BlockGetter)p_162513_, p_162515_ + 2, p_162516_, p_162517_, p_162514_).m_60713_(blockstate1.m_60734_())) {
                this.fillPillarDownOrChainUp(p_162513_, blockstate, p_162515_ + 2, p_162516_, p_162517_, p_162514_);
            }
        }

        protected void m_73528_(WorldGenLevel p_162500_, BlockState p_162501_, int p_162502_, int p_162503_, int p_162504_, BoundingBox p_162505_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = this.m_163582_(p_162502_, p_162503_, p_162504_);
            if (p_162505_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                int i = blockpos$mutableblockpos.m_123342_();
                while (this.m_163572_(p_162500_.m_8055_((BlockPos)blockpos$mutableblockpos)) && blockpos$mutableblockpos.m_123342_() > p_162500_.m_141937_() + 1) {
                    blockpos$mutableblockpos.m_122173_(Direction.DOWN);
                }
                if (this.canPlaceColumnOnTopOf((LevelReader)p_162500_, (BlockPos)blockpos$mutableblockpos, p_162500_.m_8055_((BlockPos)blockpos$mutableblockpos))) {
                    while (blockpos$mutableblockpos.m_123342_() < i) {
                        blockpos$mutableblockpos.m_122173_(Direction.UP);
                        p_162500_.m_7731_((BlockPos)blockpos$mutableblockpos, p_162501_, 2);
                    }
                }
            }
        }

        protected void fillPillarDownOrChainUp(WorldGenLevel p_162545_, BlockState p_162546_, int p_162547_, int p_162548_, int p_162549_, BoundingBox p_162550_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = this.m_163582_(p_162547_, p_162548_, p_162549_);
            if (p_162550_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                int i = blockpos$mutableblockpos.m_123342_();
                int j = 1;
                boolean flag = true;
                boolean flag1 = true;
                while (flag || flag1) {
                    if (flag) {
                        boolean flag2;
                        blockpos$mutableblockpos.m_142448_(i - j);
                        BlockState blockstate = p_162545_.m_8055_((BlockPos)blockpos$mutableblockpos);
                        boolean bl = flag2 = this.m_163572_(blockstate) && !blockstate.m_60713_(Blocks.f_49991_);
                        if (!flag2 && this.canPlaceColumnOnTopOf((LevelReader)p_162545_, (BlockPos)blockpos$mutableblockpos, blockstate)) {
                            ResearchTunnelCorridor.fillColumnBetween(p_162545_, p_162546_, blockpos$mutableblockpos, i - j + 1, i);
                            return;
                        }
                        boolean bl2 = flag = j <= 20 && flag2 && blockpos$mutableblockpos.m_123342_() > p_162545_.m_141937_() + 1;
                    }
                    if (flag1) {
                        blockpos$mutableblockpos.m_142448_(i + j);
                        BlockState blockstate1 = p_162545_.m_8055_((BlockPos)blockpos$mutableblockpos);
                        boolean flag3 = this.m_163572_(blockstate1);
                        if (!flag3 && this.canHangChainBelow((LevelReader)p_162545_, (BlockPos)blockpos$mutableblockpos, blockstate1)) {
                            p_162545_.m_7731_((BlockPos)blockpos$mutableblockpos.m_142448_(i + 1), this.type.getFenceState(), 2);
                            ResearchTunnelCorridor.fillColumnBetween(p_162545_, Blocks.f_50184_.m_49966_(), blockpos$mutableblockpos, i + 2, i + j);
                            return;
                        }
                        flag1 = j <= 50 && flag3 && blockpos$mutableblockpos.m_123342_() < p_162545_.m_151558_() - 1;
                    }
                    ++j;
                }
            }
        }

        private static void fillColumnBetween(WorldGenLevel p_162507_, BlockState p_162508_, BlockPos.MutableBlockPos p_162509_, int p_162510_, int p_162511_) {
            for (int i = p_162510_; i < p_162511_; ++i) {
                p_162507_.m_7731_((BlockPos)p_162509_.m_142448_(i), p_162508_, 2);
            }
        }

        private boolean canPlaceColumnOnTopOf(LevelReader p_203133_, BlockPos p_203134_, BlockState p_203135_) {
            return p_203135_.m_60783_((BlockGetter)p_203133_, p_203134_, Direction.UP);
        }

        private boolean canHangChainBelow(LevelReader p_162496_, BlockPos p_162497_, BlockState p_162498_) {
            return Block.m_49863_((LevelReader)p_162496_, (BlockPos)p_162497_, (Direction)Direction.DOWN) && !(p_162498_.m_60734_() instanceof FallingBlock);
        }

        private void placeSupport(WorldGenLevel p_71390_, BoundingBox p_71391_, int p_71392_, int p_71393_, int p_71394_, int p_71395_, int p_71396_, Random p_71397_) {
            if (this.isSupportingBox((BlockGetter)p_71390_, p_71391_, p_71392_, p_71396_, p_71395_, p_71394_)) {
                BlockState blockstate = this.type.getPlanksState();
                BlockState blockstate1 = this.type.getFenceState();
                this.m_73441_(p_71390_, p_71391_, p_71392_, p_71393_, p_71394_, p_71392_, p_71395_ - 1, p_71394_, blockstate1, f_73382_, false);
                this.m_73441_(p_71390_, p_71391_, p_71396_, p_71393_, p_71394_, p_71396_, p_71395_ - 1, p_71394_, blockstate1, f_73382_, false);
                if (p_71397_.nextInt(4) == 0) {
                    this.m_73441_(p_71390_, p_71391_, p_71392_, p_71395_, p_71394_, p_71392_, p_71395_, p_71394_, blockstate, f_73382_, false);
                    this.m_73441_(p_71390_, p_71391_, p_71396_, p_71395_, p_71394_, p_71396_, p_71395_, p_71394_, blockstate, f_73382_, false);
                } else {
                    this.m_73441_(p_71390_, p_71391_, p_71392_, p_71395_, p_71394_, p_71396_, p_71395_, p_71394_, blockstate, f_73382_, false);
                    this.m_73491_(p_71390_, p_71391_, p_71397_, 0.05f, p_71392_ + 1, p_71395_, p_71394_ - 1, (BlockState)((Block)CelestialBlocks.GLOW_STRIP.get()).m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)Direction.SOUTH));
                    this.m_73491_(p_71390_, p_71391_, p_71397_, 0.05f, p_71392_ + 1, p_71395_, p_71394_ + 1, (BlockState)((Block)CelestialBlocks.GLOW_STRIP.get()).m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)Direction.NORTH));
                }
            }
        }

        private void maybePlaceCobWeb(WorldGenLevel p_162526_, BoundingBox p_162527_, Random p_162528_, float p_162529_, int p_162530_, int p_162531_, int p_162532_) {
            if (this.m_73414_((LevelReader)p_162526_, p_162530_, p_162531_, p_162532_, p_162527_) && p_162528_.nextFloat() < p_162529_ && this.hasSturdyNeighbours(p_162526_, p_162527_, p_162530_, p_162531_, p_162532_, 2)) {
                this.m_73434_(p_162526_, Blocks.f_50033_.m_49966_(), p_162530_, p_162531_, p_162532_, p_162527_);
            }
        }

        private boolean hasSturdyNeighbours(WorldGenLevel p_162519_, BoundingBox p_162520_, int p_162521_, int p_162522_, int p_162523_, int p_162524_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = this.m_163582_(p_162521_, p_162522_, p_162523_);
            int i = 0;
            for (Direction direction : Direction.values()) {
                blockpos$mutableblockpos.m_122173_(direction);
                if (p_162520_.m_71051_((Vec3i)blockpos$mutableblockpos) && p_162519_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60783_((BlockGetter)p_162519_, (BlockPos)blockpos$mutableblockpos, direction.m_122424_()) && ++i >= p_162524_) {
                    return true;
                }
                blockpos$mutableblockpos.m_122173_(direction.m_122424_());
            }
            return false;
        }
    }

    static abstract class ResearchTunnelPiece
    extends StructurePiece {
        protected ResearchTunnelStructure.Type type;

        public ResearchTunnelPiece(StructurePieceType p_209876_, int p_209877_, ResearchTunnelStructure.Type p_209878_, BoundingBox p_209879_) {
            super(p_209876_, p_209877_, p_209879_);
            this.type = p_209878_;
        }

        public ResearchTunnelPiece(StructurePieceType p_209881_, CompoundTag p_209882_) {
            super(p_209881_, p_209882_);
            this.type = ResearchTunnelStructure.Type.byId(p_209882_.m_128451_("MST"));
        }

        protected boolean m_142085_(LevelReader p_162582_, int p_162583_, int p_162584_, int p_162585_, BoundingBox p_162586_) {
            BlockState blockstate = this.m_73398_((BlockGetter)p_162582_, p_162583_, p_162584_, p_162585_, p_162586_);
            return !blockstate.m_60713_(this.type.getPlanksState().m_60734_()) && !blockstate.m_60713_(this.type.getWoodState().m_60734_()) && !blockstate.m_60713_(this.type.getFenceState().m_60734_()) && !blockstate.m_60713_(Blocks.f_50184_);
        }

        protected void m_183620_(StructurePieceSerializationContext p_192054_, CompoundTag p_192055_) {
            p_192055_.m_128405_("MST", this.type.ordinal());
        }

        protected boolean isSupportingBox(BlockGetter p_71475_, BoundingBox p_71476_, int p_71477_, int p_71478_, int p_71479_, int p_71480_) {
            for (int i = p_71477_; i <= p_71478_; ++i) {
                if (!this.m_73398_(p_71475_, i, p_71479_ + 1, p_71480_, p_71476_).m_60795_()) continue;
                return false;
            }
            return true;
        }

        protected boolean edgesLiquid(BlockGetter p_162579_, BoundingBox p_162580_) {
            int i = Math.max(this.f_73383_.m_162395_() - 1, p_162580_.m_162395_());
            int j = Math.max(this.f_73383_.m_162396_() - 1, p_162580_.m_162396_());
            int k = Math.max(this.f_73383_.m_162398_() - 1, p_162580_.m_162398_());
            int l = Math.min(this.f_73383_.m_162399_() + 1, p_162580_.m_162399_());
            int i1 = Math.min(this.f_73383_.m_162400_() + 1, p_162580_.m_162400_());
            int j1 = Math.min(this.f_73383_.m_162401_() + 1, p_162580_.m_162401_());
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = k; l1 <= j1; ++l1) {
                    if (p_162579_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k1, j, l1)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k1, i1, l1)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            for (int i2 = i; i2 <= l; ++i2) {
                for (int k2 = j; k2 <= i1; ++k2) {
                    if (p_162579_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(i2, k2, k)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(i2, k2, j1)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            for (int j2 = k; j2 <= j1; ++j2) {
                for (int l2 = j; l2 <= i1; ++l2) {
                    if (p_162579_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(i, l2, j2)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(l, l2, j2)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void setPlanksBlock(WorldGenLevel p_162588_, BoundingBox p_162589_, BlockState p_162590_, int p_162591_, int p_162592_, int p_162593_) {
            BlockPos.MutableBlockPos blockpos;
            BlockState blockstate;
            if (this.m_73414_((LevelReader)p_162588_, p_162591_, p_162592_, p_162593_, p_162589_) && !(blockstate = p_162588_.m_8055_((BlockPos)(blockpos = this.m_163582_(p_162591_, p_162592_, p_162593_)))).m_60783_((BlockGetter)p_162588_, (BlockPos)blockpos, Direction.UP)) {
                p_162588_.m_7731_((BlockPos)blockpos, p_162590_, 2);
            }
        }
    }

    public static class ResearchTunnelRoom
    extends ResearchTunnelPiece {
        private final List<BoundingBox> childEntranceBoxes = Lists.newLinkedList();

        public ResearchTunnelRoom(int p_71486_, Random p_71487_, int p_71488_, int p_71489_, ResearchTunnelStructure.Type p_71490_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_ROOM, p_71486_, p_71490_, new BoundingBox(p_71488_, 50, p_71489_, p_71488_ + 7 + p_71487_.nextInt(6), 54 + p_71487_.nextInt(6), p_71489_ + 7 + p_71487_.nextInt(6)));
            this.type = p_71490_;
        }

        public ResearchTunnelRoom(CompoundTag p_192057_) {
            super(CelestialStructurePieceType.RESEARCH_TUNNEL_ROOM, p_192057_);
            BoundingBox.f_162354_.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)p_192057_.m_128437_("Entrances", 11)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.childEntranceBoxes::addAll);
        }

        public void m_142537_(StructurePiece p_162601_, StructurePieceAccessor p_162602_, Random p_162603_) {
            int k;
            int i = this.m_73548_();
            int j = this.f_73383_.m_71057_() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.f_73383_.m_71056_() && (k += p_162603_.nextInt(this.f_73383_.m_71056_())) + 3 <= this.f_73383_.m_71056_(); k += 4) {
                ResearchTunnelPiece tunnelpieces$tunnelpiece = ResearchTunnelPieces.generateAndAddPiece(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() + k, this.f_73383_.m_162396_() + p_162603_.nextInt(j) + 1, this.f_73383_.m_162398_() - 1, Direction.NORTH, i);
                if (tunnelpieces$tunnelpiece == null) continue;
                BoundingBox boundingbox = tunnelpieces$tunnelpiece.m_73547_();
                this.childEntranceBoxes.add(new BoundingBox(boundingbox.m_162395_(), boundingbox.m_162396_(), this.f_73383_.m_162398_(), boundingbox.m_162399_(), boundingbox.m_162400_(), this.f_73383_.m_162398_() + 1));
            }
            for (k = 0; k < this.f_73383_.m_71056_() && (k += p_162603_.nextInt(this.f_73383_.m_71056_())) + 3 <= this.f_73383_.m_71056_(); k += 4) {
                ResearchTunnelPiece tunnelpieces$tunnelpiece1 = ResearchTunnelPieces.generateAndAddPiece(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() + k, this.f_73383_.m_162396_() + p_162603_.nextInt(j) + 1, this.f_73383_.m_162401_() + 1, Direction.SOUTH, i);
                if (tunnelpieces$tunnelpiece1 == null) continue;
                BoundingBox boundingbox1 = tunnelpieces$tunnelpiece1.m_73547_();
                this.childEntranceBoxes.add(new BoundingBox(boundingbox1.m_162395_(), boundingbox1.m_162396_(), this.f_73383_.m_162401_() - 1, boundingbox1.m_162399_(), boundingbox1.m_162400_(), this.f_73383_.m_162401_()));
            }
            for (k = 0; k < this.f_73383_.m_71058_() && (k += p_162603_.nextInt(this.f_73383_.m_71058_())) + 3 <= this.f_73383_.m_71058_(); k += 4) {
                ResearchTunnelPiece tunnelpieces$tunnelpiece2 = ResearchTunnelPieces.generateAndAddPiece(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162603_.nextInt(j) + 1, this.f_73383_.m_162398_() + k, Direction.WEST, i);
                if (tunnelpieces$tunnelpiece2 == null) continue;
                BoundingBox boundingbox2 = tunnelpieces$tunnelpiece2.m_73547_();
                this.childEntranceBoxes.add(new BoundingBox(this.f_73383_.m_162395_(), boundingbox2.m_162396_(), boundingbox2.m_162398_(), this.f_73383_.m_162395_() + 1, boundingbox2.m_162400_(), boundingbox2.m_162401_()));
            }
            for (k = 0; k < this.f_73383_.m_71058_() && (k += p_162603_.nextInt(this.f_73383_.m_71058_())) + 3 <= this.f_73383_.m_71058_(); k += 4) {
                ResearchTunnelPiece structurepiece = ResearchTunnelPieces.generateAndAddPiece(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162603_.nextInt(j) + 1, this.f_73383_.m_162398_() + k, Direction.EAST, i);
                if (structurepiece == null) continue;
                BoundingBox boundingbox3 = structurepiece.m_73547_();
                this.childEntranceBoxes.add(new BoundingBox(this.f_73383_.m_162399_() - 1, boundingbox3.m_162396_(), boundingbox3.m_162398_(), this.f_73383_.m_162399_(), boundingbox3.m_162400_(), boundingbox3.m_162401_()));
            }
        }

        public void m_183269_(WorldGenLevel p_192059_, StructureFeatureManager p_192060_, ChunkGenerator p_192061_, Random p_192062_, BoundingBox p_192063_, ChunkPos p_192064_, BlockPos p_192065_) {
            if (!this.edgesLiquid((BlockGetter)p_192059_, p_192063_)) {
                this.m_73441_(p_192059_, p_192063_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 1, this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), Math.min(this.f_73383_.m_162396_() + 3, this.f_73383_.m_162400_()), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                for (BoundingBox boundingbox : this.childEntranceBoxes) {
                    this.m_73441_(p_192059_, p_192063_, boundingbox.m_162395_(), boundingbox.m_162400_() - 2, boundingbox.m_162398_(), boundingbox.m_162399_(), boundingbox.m_162400_(), boundingbox.m_162401_(), f_73382_, f_73382_, false);
                }
                this.m_73453_(p_192059_, p_192063_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 4, this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, false);
            }
        }

        public void m_6324_(int p_71495_, int p_71496_, int p_71497_) {
            super.m_6324_(p_71495_, p_71496_, p_71497_);
            for (BoundingBox boundingbox : this.childEntranceBoxes) {
                boundingbox.m_162367_(p_71495_, p_71496_, p_71497_);
            }
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192067_, CompoundTag p_192068_) {
            super.m_183620_(p_192067_, p_192068_);
            BoundingBox.f_162354_.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.childEntranceBoxes).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_162606_ -> p_192068_.m_128365_("Entrances", p_162606_));
        }
    }
}

