/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.erraticexplosions.ErraticExplosions;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.file.AnnoyingResource;

public class ErraticConfig {
    @NotNull
    private static final Random RANDOM = new Random();
    @NotNull
    private final AnnoyingResource config;
    public final boolean tnt;
    public final boolean creepers;
    public final boolean otherExplosives;
    @NotNull
    public final Fuse fuse;
    @NotNull
    public final Power power;
    @NotNull
    public final Invulnerability invulnerability;

    public ErraticConfig(@NotNull ErraticExplosions plugin) {
        this.config = new AnnoyingResource((AnnoyingPlugin)plugin, "config.yml");
        this.tnt = this.config.getBoolean("tnt", true);
        this.creepers = this.config.getBoolean("creepers", true);
        this.otherExplosives = this.config.getBoolean("other-explosives", true);
        this.fuse = new Fuse();
        this.power = new Power();
        this.invulnerability = new Invulnerability();
    }

    public static enum Type {
        ALLOW,
        DENY;


        @NotNull
        public static Type fromString(@Nullable String name) {
            if (name == null) {
                return ALLOW;
            }
            try {
                return Type.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return ALLOW;
            }
        }
    }

    public class Invulnerability {
        @NotNull
        public Type type = Type.ALLOW;
        @NotNull
        public final Set<EntityType> entities = new HashSet<EntityType>();

        public Invulnerability() {
            ConfigurationSection section = ErraticConfig.this.config.getConfigurationSection("invulnerability");
            if (section != null) {
                this.type = Type.fromString(section.getString("type"));
                for (String entity : section.getStringList("entities")) {
                    try {
                        this.entities.add(EntityType.valueOf((String)entity.toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        AnnoyingPlugin.log(Level.WARNING, "Invalid entity type in invulnerability.entities: " + entity, e);
                    }
                }
            }
        }

        public boolean isInvulnerable(@NotNull EntityType entityType) {
            return this.type == Type.ALLOW && this.entities.contains(entityType) || this.type == Type.DENY && !this.entities.contains(entityType);
        }
    }

    public class Power {
        private float min = 4.0f;
        private float max = 4.0f;

        public Power() {
            ConfigurationSection section = ErraticConfig.this.config.getConfigurationSection("power");
            if (section != null) {
                this.min = (float)section.getDouble("min", (double)this.min);
                this.max = (float)section.getDouble("max", (double)this.max);
            }
            this.max = this.max - this.min + 1.0f;
        }

        public float getRandom() {
            return RANDOM.nextFloat() * this.max + this.min;
        }
    }

    public class Fuse {
        private int min = 20;
        private int max = 100;

        public Fuse() {
            ConfigurationSection section = ErraticConfig.this.config.getConfigurationSection("fuse");
            if (section != null) {
                this.min = section.getInt("min", this.min);
                this.max = section.getInt("max", this.max);
            }
            this.max = this.max - this.min + 1;
        }

        public int getRandom() {
            return RANDOM.nextInt(this.max) + this.min;
        }
    }
}

