/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.cooldown;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.cooldown.CooldownManager;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.parents.Stringable;

public class AnnoyingCooldown
extends Stringable {
    @NotNull
    private final CooldownManager manager;
    @NotNull
    public final String type;
    @NotNull
    public final String key;
    @Nullable
    private Long expires;

    public AnnoyingCooldown(@NotNull CooldownManager manager, @NotNull Object type, @NotNull String key) {
        this.manager = manager;
        this.key = key;
        this.type = type.toString();
    }

    public AnnoyingCooldown(@NotNull AnnoyingPlugin plugin, @NotNull Object type, @NotNull String key) {
        this(plugin.cooldownManager, type, key);
    }

    public long getRemaining() {
        return this.expires == null ? 0L : this.expires - System.currentTimeMillis();
    }

    public boolean isOnCooldown() {
        return this.getRemaining() > 0L;
    }

    public boolean isOnCooldownStart(long duration) {
        boolean onCooldown = this.isOnCooldown();
        if (!onCooldown) {
            this.start(duration);
        }
        return onCooldown;
    }

    public boolean isOnCooldownStop() {
        boolean onCooldown = this.isOnCooldown();
        if (onCooldown) {
            this.stop();
        }
        return onCooldown;
    }

    public void start(long duration) {
        this.expires = System.currentTimeMillis() + duration;
        this.manager.cooldowns.add(this);
    }

    public void stop() {
        this.expires = null;
        this.manager.cooldowns.remove(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnoyingCooldown)) {
            return false;
        }
        AnnoyingCooldown cooldown = (AnnoyingCooldown)other;
        return this.type.equals(cooldown.type) && this.key.equals(cooldown.key);
    }

    public int hashCode() {
        return this.type.hashCode() + this.key.hashCode();
    }
}

