/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.dependency;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.PluginPlatform;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.utility.ConfigurationUtility;

public class AnnoyingDependency
extends Stringable {
    @NotNull
    public final String name;
    @NotNull
    public final PluginPlatform.Multi platforms;
    public final boolean required;
    public final boolean enableAfterDownload;
    @NotNull
    public final File file;

    public AnnoyingDependency(@NotNull String name, @NotNull PluginPlatform.Multi platforms, boolean required, boolean enableAfterDownload) {
        this.name = name;
        this.platforms = platforms;
        this.required = required;
        this.enableAfterDownload = enableAfterDownload;
        this.file = new File(Bukkit.getUpdateFolderFile().getParentFile(), name + ".jar");
    }

    public AnnoyingDependency(@NotNull String name, boolean required, boolean enableAfterDownload, @NotNull PluginPlatform.Multi platforms) {
        this(name, platforms, required, enableAfterDownload);
    }

    public AnnoyingDependency(@NotNull String name, boolean required, boolean enableAfterDownload, PluginPlatform ... platforms) {
        this(name, new PluginPlatform.Multi(platforms), required, enableAfterDownload);
    }

    @NotNull
    public static AnnoyingDependency load(@NotNull ConfigurationSection section) {
        String name = section.getName();
        if (name.isEmpty() && (name = section.getString("name")) == null) {
            throw new IllegalArgumentException("The name of the dependency is missing");
        }
        return new AnnoyingDependency(name, PluginPlatform.Multi.load(section, "platforms"), section.getBoolean("required"), section.getBoolean("enableAfterDownload"));
    }

    @NotNull
    public static List<AnnoyingDependency> loadList(@NotNull ConfigurationSection section, @NotNull String key) {
        ConfigurationSection dependenciesSection = section.getConfigurationSection(key);
        return (dependenciesSection == null ? ConfigurationUtility.toConfigurationList(section.getMapList(key)).stream() : dependenciesSection.getKeys(false).stream().map(arg_0 -> ((ConfigurationSection)dependenciesSection).getConfigurationSection(arg_0)).filter(Objects::nonNull)).map(AnnoyingDependency::load).collect(Collectors.toList());
    }

    public boolean isNotInstalled() {
        return Bukkit.getPluginManager().getPlugin(this.name) == null;
    }
}

