/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.events;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.events.CustomEventHandler;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.parents.Registrable;

public class PlayerDamageByPlayerEvent
extends EntityEvent
implements Cancellable {
    @NotNull
    private static final HandlerList HANDLERS = new HandlerList();
    private boolean cancelled = false;
    @NotNull
    private final Player damager;
    @NotNull
    private final EntityDamageEvent.DamageCause cause;
    private double damage;

    public PlayerDamageByPlayerEvent(@NotNull Player damager, @NotNull Player damagee, @NotNull EntityDamageEvent.DamageCause cause, double damage) {
        super((Entity)damagee);
        this.damager = damager;
        this.cause = cause;
        this.damage = damage;
    }

    public PlayerDamageByPlayerEvent(@NotNull EntityDamageByEntityEvent event) {
        this((Player)event.getDamager(), (Player)event.getEntity(), event.getCause(), event.getDamage());
        this.setCancelled(event.isCancelled());
    }

    @NotNull
    public String toString() {
        return Stringable.toString((Object)this);
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public HandlerList getHandlers() {
        return PlayerDamageByPlayerEvent.getHandlerList();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public Player getDamager() {
        return this.damager;
    }

    @NotNull
    public Player getEntity() {
        return (Player)super.getEntity();
    }

    @NotNull
    public Player getDamagee() {
        return this.getEntity();
    }

    @NotNull
    public EntityType getEntityType() {
        return EntityType.PLAYER;
    }

    @NotNull
    public EntityDamageEvent.DamageCause getCause() {
        return this.cause;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    @Registrable.Ignore
    public static class Handler
    extends CustomEventHandler {
        public Handler(@NotNull AnnoyingPlugin plugin) {
            super(plugin);
        }

        @EventHandler
        public void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
            if (!(event.getDamager() instanceof Player) || !(event.getEntity() instanceof Player)) {
                return;
            }
            PlayerDamageByPlayerEvent newEvent = new PlayerDamageByPlayerEvent(event);
            Bukkit.getPluginManager().callEvent((Event)newEvent);
            event.setCancelled(newEvent.isCancelled());
            event.setDamage(newEvent.getDamage());
        }
    }
}

