/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtility {
    public static boolean DEBUG = false;

    @NotNull
    public static <T> Optional<T> get(@NotNull String userAgent, @NotNull String url, @NotNull Function<InputStreamReader, T> function, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Object result;
        block6: {
            result = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", userAgent);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (connection.getResponseCode() == 404) {
                    if (DEBUG) {
                        System.out.println("[JU] 404: " + url);
                    }
                    return Optional.empty();
                }
                result = function.apply(new InputStreamReader(connection.getInputStream()));
            }
            catch (IOException e) {
                if (!DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return Optional.ofNullable(result);
    }

    @NotNull
    public static Optional<String> getString(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.get(userAgent, urlString, reader -> new BufferedReader((Reader)reader).lines().collect(Collectors.joining("\n")), connectionConsumer);
    }

    @NotNull
    public static Optional<JsonElement> getJson(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.get(userAgent, urlString, reader -> new JsonParser().parse((Reader)reader), connectionConsumer);
    }

    public static int postJson(@NotNull String userAgent, @NotNull String urlString, @NotNull JsonElement data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        int responseCode;
        block4: {
            responseCode = -1;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                connection.getOutputStream().write(data.toString().getBytes());
                responseCode = connection.getResponseCode();
            }
            catch (IOException e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return responseCode;
    }

    public static int putJson(@NotNull String userAgent, @NotNull String urlString, @NotNull JsonElement data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        int responseCode;
        block4: {
            responseCode = -1;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("PUT");
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                connection.getOutputStream().write(data.toString().getBytes());
                responseCode = connection.getResponseCode();
            }
            catch (IOException e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return responseCode;
    }

    public static int delete(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        int responseCode;
        block4: {
            responseCode = -1;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("DELETE");
                connection.setRequestProperty("User-Agent", userAgent);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                responseCode = connection.getResponseCode();
            }
            catch (IOException e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return responseCode;
    }

    private HttpUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

