/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.manipulation;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.StringUtility;

public class DurationFormatter {
    @NotNull
    private static String padWithZeros(boolean padWithZeros, int integer, int size) {
        String string = Integer.toString(integer);
        int length = string.length();
        if (!padWithZeros || length >= size) {
            return string;
        }
        int pads = size - length;
        if (pads > 8192) {
            return string;
        }
        return StringUtility.repeat("0", pads) + string;
    }

    @NotNull
    public static String formatDuration(long durationMillis, @NotNull String format) {
        return DurationFormatter.formatDuration(durationMillis, format, true);
    }

    @NotNull
    public static String formatDuration(long durationMillis, @NotNull String format, boolean padWithZeros) {
        char[] array = format.toCharArray();
        ArrayList<Token> tokens = new ArrayList<Token>(array.length);
        boolean inLiteral = false;
        StringBuilder literalBuilder = null;
        Token previous = null;
        block22: for (char character : array) {
            if (inLiteral && character != '\'') {
                literalBuilder.append(character);
                continue;
            }
            switch (character) {
                case '\'': {
                    if (inLiteral) {
                        inLiteral = false;
                        literalBuilder = null;
                    } else {
                        inLiteral = true;
                        literalBuilder = new StringBuilder();
                        tokens.add(new Token(literalBuilder, true));
                    }
                    previous = null;
                    continue block22;
                }
                case 'H': 
                case 'M': 
                case 'S': 
                case 'd': 
                case 'm': 
                case 's': 
                case 'y': {
                    literalBuilder = null;
                    String value = String.valueOf(character);
                    if (previous != null && previous.value.toString().equals(value)) {
                        previous.count++;
                        continue block22;
                    }
                    Token token = new Token(new StringBuilder(value), false);
                    tokens.add(token);
                    previous = token;
                    continue block22;
                }
                default: {
                    if (literalBuilder == null) {
                        literalBuilder = new StringBuilder();
                        tokens.add(new Token(literalBuilder, true));
                    }
                    literalBuilder.append(character);
                    previous = null;
                }
            }
        }
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        if (Token.containsTokenWithValue(tokens, "y")) {
            years = (int)(durationMillis / 31557600000L);
            durationMillis -= (long)years * 31557600000L;
        }
        if (Token.containsTokenWithValue(tokens, "M")) {
            months = (int)(durationMillis / 2629800000L);
            durationMillis -= (long)months * 2629800000L;
        }
        if (Token.containsTokenWithValue(tokens, "d")) {
            days = (int)(durationMillis / 86400000L);
            durationMillis -= (long)days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, "H")) {
            hours = (int)(durationMillis / 3600000L);
            durationMillis -= (long)hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, "m")) {
            minutes = (int)(durationMillis / 60000L);
            durationMillis -= (long)minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, "s")) {
            seconds = (int)(durationMillis / 1000L);
            durationMillis -= (long)seconds * 1000L;
        }
        if (Token.containsTokenWithValue(tokens, "S")) {
            milliseconds = (int)durationMillis;
        }
        StringBuilder builder = new StringBuilder();
        boolean lastOutputSeconds = false;
        block23: for (Token token : tokens) {
            String value = token.value.toString();
            if (token.literal) {
                builder.append(value);
                continue;
            }
            int count = token.count;
            switch (value) {
                case "y": {
                    builder.append(DurationFormatter.padWithZeros(padWithZeros, years, count));
                    lastOutputSeconds = false;
                    continue block23;
                }
                case "M": {
                    builder.append(DurationFormatter.padWithZeros(padWithZeros, months, count));
                    lastOutputSeconds = false;
                    continue block23;
                }
                case "d": {
                    builder.append(DurationFormatter.padWithZeros(padWithZeros, days, count));
                    lastOutputSeconds = false;
                    continue block23;
                }
                case "H": {
                    builder.append(DurationFormatter.padWithZeros(padWithZeros, hours, count));
                    lastOutputSeconds = false;
                    continue block23;
                }
                case "m": {
                    builder.append(DurationFormatter.padWithZeros(padWithZeros, minutes, count));
                    lastOutputSeconds = false;
                    continue block23;
                }
                case "s": {
                    builder.append(DurationFormatter.padWithZeros(padWithZeros, seconds, count));
                    lastOutputSeconds = true;
                    continue block23;
                }
                case "S": {
                    String millisecondsString = DurationFormatter.padWithZeros(padWithZeros, milliseconds, count);
                    if (!lastOutputSeconds) {
                        builder.append(millisecondsString);
                        continue block23;
                    }
                    milliseconds += 1000;
                    builder.append(millisecondsString.substring(1));
                    lastOutputSeconds = false;
                    continue block23;
                }
            }
            builder.append(value);
            lastOutputSeconds = false;
        }
        return builder.toString();
    }

    private DurationFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Token {
        @NotNull
        private final StringBuilder value;
        private int count = 1;
        private final boolean literal;

        private Token(@NotNull StringBuilder value, boolean literal) {
            this.value = value;
            this.literal = literal;
        }

        @Contract(pure=true)
        static boolean containsTokenWithValue(@NotNull List<Token> tokens, @NotNull String value) {
            for (Token token : tokens) {
                if (token.literal || !token.value.toString().equals(value)) continue;
                return true;
            }
            return false;
        }
    }
}

