/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.manipulation;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.manipulation.Mapper;

public class DurationParser {
    @NotNull
    private static final Duration[] DURATIONS = new Duration[]{ChronoUnit.YEARS.getDuration(), ChronoUnit.MONTHS.getDuration(), ChronoUnit.WEEKS.getDuration(), ChronoUnit.DAYS.getDuration(), ChronoUnit.HOURS.getDuration(), ChronoUnit.MINUTES.getDuration(), ChronoUnit.SECONDS.getDuration()};
    private static final int DURATIONS_LENGTH = DURATIONS.length;
    @NotNull
    private static final Pattern PATTERN = Pattern.compile(Stream.of("y(?:ear)?s?", "mo(?:nth)?s?", "w(?:eek)?s?", "d(?:ay)?s?", "h(?:our|r)?s?", "m(?:inute|in)?s?", "s(?:econd|ec)?s?").map(pattern -> "(?:(\\d+)\\s*" + pattern + "[,\\s]*)?").collect(Collectors.joining("", "^\\s*", "$")), 2);

    @NotNull
    public static Optional<Duration> parse(@NotNull String input) {
        Matcher matcher = PATTERN.matcher(input);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        Duration duration = Duration.ZERO;
        for (int i = 0; i < DURATIONS_LENGTH; ++i) {
            Optional<Integer> number;
            String group = matcher.group(i + 1);
            if (group == null || group.isEmpty() || !(number = Mapper.toInt(group)).isPresent()) continue;
            duration = duration.plus(DURATIONS[i].multipliedBy(number.get().intValue()));
        }
        return Optional.of(duration);
    }

    private DurationParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

