/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.message;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.file.AnnoyingResource;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.message.AnnoyingJSON;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.message.BroadcastType;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.message.ReplaceType;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.reflection.net.md_5.bungee.api.chat.RefClickEvent;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.reflection.org.bukkit.entity.RefPlayer;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.utility.BukkitUtility;

public class AnnoyingMessage
extends Stringable {
    @NotNull
    private final AnnoyingPlugin plugin;
    @NotNull
    private final String key;
    private final boolean parsePapiPlaceholders;
    @NotNull
    private final Set<Replacement> replacements = new HashSet<Replacement>();
    @Nullable
    private String splitterPlaceholder;
    @Nullable
    private BaseComponent[] components;

    public AnnoyingMessage(@NotNull AnnoyingPlugin plugin, @NotNull String key, boolean parsePapiPlaceholders) {
        this.plugin = plugin;
        this.key = key;
        this.parsePapiPlaceholders = parsePapiPlaceholders;
        plugin.globalPlaceholders.forEach((placeholder, value) -> this.replace("%" + placeholder + "%", value));
    }

    public AnnoyingMessage(@NotNull AnnoyingPlugin plugin, @NotNull String key) {
        this(plugin, key, true);
    }

    public AnnoyingMessage(@NotNull AnnoyingMessage message) {
        this.plugin = message.plugin;
        this.key = message.key;
        this.parsePapiPlaceholders = message.parsePapiPlaceholders;
        this.replacements.addAll(message.replacements);
        this.splitterPlaceholder = message.splitterPlaceholder;
        this.components = message.components;
    }

    public AnnoyingMessage(@NotNull AnnoyingMessage message, @NotNull String newKey) {
        this.plugin = message.plugin;
        this.key = newKey;
        this.parsePapiPlaceholders = message.parsePapiPlaceholders;
        this.replacements.addAll(message.replacements);
        this.splitterPlaceholder = message.splitterPlaceholder;
    }

    @NotNull
    public AnnoyingMessage replace(@NotNull String placeholder, @Nullable Object value, @Nullable ReplaceType type) {
        if (this.components != null) {
            this.components = null;
        }
        this.replacements.add(new Replacement(placeholder, value, type));
        return this;
    }

    @NotNull
    public AnnoyingMessage replace(@NotNull String before, @Nullable Object after) {
        return this.replace(before, after, null);
    }

    @NotNull
    public BaseComponent[] getComponents(@Nullable AnnoyingSender sender) {
        if (this.components != null) {
            return this.components;
        }
        AnnoyingJSON json = new AnnoyingJSON();
        AnnoyingResource messages = this.plugin.messages;
        if (messages == null) {
            return json.build();
        }
        this.replaceCommand(sender);
        Player player = sender == null || !sender.isPlayer ? null : sender.getPlayer();
        String splitterJson = this.plugin.getMessagesString(this.plugin.options.messagesOptions.keys.splitterJson);
        ConfigurationSection section = messages.getConfigurationSection(this.key);
        if (section == null) {
            String string = messages.getString(this.key);
            if (string == null) {
                return json.append(this.key, "&cCheck &4" + this.plugin.options.messagesOptions.fileName + "&c!").build();
            }
            for (Replacement replacement : this.replacements) {
                string = replacement.process(string);
            }
            if (this.parsePapiPlaceholders) {
                string = this.plugin.parsePapiPlaceholders((OfflinePlayer)player, string);
            }
            String[] split = string.split(splitterJson, 3);
            BaseComponent[] newComponents = json.append(split[0], this.extractHover(split), ClickEvent.Action.SUGGEST_COMMAND, this.extractFunction(split)).build();
            if (!string.contains("%command%")) {
                this.components = newComponents;
            }
            return newComponents;
        }
        boolean shouldCache = true;
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            String subKey = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) {
                json.append(this.key + "." + subKey, "&cCheck &4" + this.plugin.options.messagesOptions.fileName + "&c!");
                continue;
            }
            String subMessage = (String)value;
            if (shouldCache && subMessage.contains("%command%")) {
                shouldCache = false;
            }
            for (Replacement replacement : this.replacements) {
                subMessage = replacement.process(subMessage);
            }
            if (this.parsePapiPlaceholders) {
                subMessage = this.plugin.parsePapiPlaceholders((OfflinePlayer)player, subMessage);
            }
            String[] split = subMessage.split(splitterJson, 3);
            String display = split[0];
            String hover = this.extractHover(split);
            String function = this.extractFunction(split);
            if (function == null) {
                json.append(display, hover);
                continue;
            }
            if (subKey.startsWith("suggest")) {
                json.append(display, hover, ClickEvent.Action.SUGGEST_COMMAND, function);
                continue;
            }
            if (RefClickEvent.RefAction.COPY_TO_CLIPBOARD != null && subKey.startsWith("copy")) {
                json.append(display, hover, RefClickEvent.RefAction.COPY_TO_CLIPBOARD, function);
                continue;
            }
            if (subKey.startsWith("chat")) {
                json.append(display, hover, ClickEvent.Action.RUN_COMMAND, function);
                continue;
            }
            if (subKey.startsWith("web")) {
                json.append(display, hover, ClickEvent.Action.OPEN_URL, function);
                continue;
            }
            json.append(display, hover);
        }
        BaseComponent[] newComponents = json.build();
        if (shouldCache) {
            this.components = newComponents;
        }
        return newComponents;
    }

    @NotNull
    public BaseComponent[] getComponents() {
        return this.getComponents(null);
    }

    @NotNull
    public String toString(@Nullable AnnoyingSender sender) {
        StringBuilder builder = new StringBuilder();
        for (BaseComponent component : this.getComponents(sender)) {
            builder.append(component.toLegacyText());
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String toString() {
        return this.toString(null);
    }

    public void broadcast(@NotNull BroadcastType type, @Nullable AnnoyingSender sender, @Nullable Integer fadeIn, @Nullable Integer stay, @Nullable Integer fadeOut) {
        if (type.isTitle()) {
            if (fadeIn == null) {
                fadeIn = 10;
            }
            if (stay == null) {
                stay = 70;
            }
            if (fadeOut == null) {
                fadeOut = 20;
            }
            if (type.equals((Object)BroadcastType.TITLE) || type.equals((Object)BroadcastType.SUBTITLE)) {
                String message = this.toString();
                if (type.equals((Object)BroadcastType.TITLE)) {
                    this.broadcastTitle(message, "", fadeIn, stay, fadeOut);
                    return;
                }
                this.broadcastTitle("", message, fadeIn, stay, fadeOut);
                return;
            }
            this.broadcastTitle(new AnnoyingMessage(this, this.key + ".title").toString(sender), new AnnoyingMessage(this, this.key + ".subtitle").toString(sender), fadeIn, stay, fadeOut);
            return;
        }
        BaseComponent[] compiledComponents = this.getComponents(sender);
        if (type.equals((Object)BroadcastType.ACTIONBAR) && RefPlayer.RefSpigot.PLAYER_SPIGOT_SEND_MESSAGE_METHOD != null) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                try {
                    RefPlayer.RefSpigot.PLAYER_SPIGOT_SEND_MESSAGE_METHOD.invoke((Object)player.spigot(), ChatMessageType.ACTION_BAR, compiledComponents);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            });
            return;
        }
        Bukkit.spigot().broadcast(compiledComponents);
    }

    public void broadcast(@NotNull BroadcastType type, @Nullable Integer fadeIn, @Nullable Integer stay, @Nullable Integer fadeOut) {
        this.broadcast(type, null, fadeIn, stay, fadeOut);
    }

    public void broadcast(@NotNull BroadcastType type, @Nullable AnnoyingSender sender) {
        this.broadcast(type, sender, null, null, null);
    }

    public void broadcast(@NotNull BroadcastType type) {
        this.broadcast(type, null, null, null, null);
    }

    public void send(@NotNull AnnoyingSender sender) {
        if (sender.isPlayer) {
            sender.getPlayer().spigot().sendMessage(this.getComponents(sender));
            return;
        }
        sender.cmdSender.sendMessage(this.toString(sender));
    }

    public void send(@NotNull CommandSender sender) {
        this.send(new AnnoyingSender(this.plugin, sender));
    }

    public void log(@Nullable Level level) {
        AnnoyingPlugin.log(level, this.toString());
    }

    public void log() {
        this.log(null);
    }

    private void replaceCommand(@Nullable AnnoyingSender sender) {
        this.replace("%command%", sender != null ? "/" + sender.getFullCommand() : "");
    }

    @Nullable
    private String extractHover(@NotNull String[] split) {
        String hover = split.length >= 2 ? split[1] : null;
        return hover != null && BukkitUtility.stripUntranslatedColor(hover).isEmpty() ? null : hover;
    }

    @Nullable
    private String extractFunction(@NotNull String[] split) {
        String function = split.length >= 3 ? split[2] : null;
        return function != null && BukkitUtility.stripUntranslatedColor(function).isEmpty() ? null : function;
    }

    private void broadcastTitle(@NotNull String title, @NotNull String subtitle, int fadeIn, int stay, int fadeOut) {
        Collection players = Bukkit.getOnlinePlayers();
        if (RefPlayer.PLAYER_SEND_TITLE_METHOD != null) {
            try {
                for (Player player2 : players) {
                    RefPlayer.PLAYER_SEND_TITLE_METHOD.invoke((Object)player2, title, subtitle, fadeIn, stay, fadeOut);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        players.forEach(player -> player.sendTitle(title, subtitle));
    }

    private class Replacement
    extends Stringable {
        @NotNull
        private final String before;
        @NotNull
        private final String value;
        @Nullable
        private final ReplaceType type;

        public Replacement(@Nullable String before, @Nullable Object value, ReplaceType type) {
            this.before = before;
            this.value = String.valueOf(value);
            this.type = type;
        }

        @NotNull
        public String process(@NotNull String input) {
            String parameter;
            String match;
            Matcher matcher;
            if (this.type == null) {
                return input.replace(this.before, this.value);
            }
            if (AnnoyingMessage.this.splitterPlaceholder == null) {
                AnnoyingMessage.this.splitterPlaceholder = AnnoyingMessage.this.plugin.getMessagesString(((AnnoyingMessage)AnnoyingMessage.this).plugin.options.messagesOptions.keys.splitterPlaceholder);
            }
            if ((matcher = Pattern.compile("%" + Pattern.quote(this.before.replace("%", "") + AnnoyingMessage.this.splitterPlaceholder) + ".*?%").matcher(input)).find()) {
                match = matcher.group();
                String split = match.split(AnnoyingMessage.this.splitterPlaceholder, 2)[1];
                parameter = split.substring(0, split.length() - 1);
            } else {
                match = this.before;
                parameter = this.type.getDefaultInput();
            }
            return input.replace(match, (CharSequence)this.type.getOutputOperator().apply(parameter, this.value));
        }
    }
}

