/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.options;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.parents.Registrable;

public class RegistrationOptions
extends Stringable {
    @NotNull
    public AutomaticRegistration automaticRegistration = new AutomaticRegistration();
    @NotNull
    public Set<Registrable> toRegister = new HashSet<Registrable>();
    @NotNull
    public Supplier<Object> papiExpansionToRegister = () -> null;

    @NotNull
    public static RegistrationOptions load(@NotNull ConfigurationSection section) {
        RegistrationOptions options = new RegistrationOptions();
        ConfigurationSection automaticRegistrationSection = section.getConfigurationSection("automaticRegistration");
        if (automaticRegistrationSection != null) {
            options.automaticRegistration(AutomaticRegistration.load(automaticRegistrationSection));
        }
        return options;
    }

    @NotNull
    public Optional<PlaceholderExpansion> getPapiExpansionToRegister() {
        Object expansion = this.papiExpansionToRegister.get();
        return expansion instanceof PlaceholderExpansion ? Optional.of((PlaceholderExpansion)expansion) : Optional.empty();
    }

    @NotNull
    public RegistrationOptions automaticRegistration(@NotNull AutomaticRegistration automaticRegistration) {
        this.automaticRegistration = automaticRegistration;
        return this;
    }

    @NotNull
    public RegistrationOptions automaticRegistration(@NotNull Consumer<AutomaticRegistration> automaticRegistration) {
        automaticRegistration.accept(this.automaticRegistration);
        return this;
    }

    @NotNull
    public RegistrationOptions toRegister(@NotNull Collection<Registrable> toRegister) {
        this.toRegister.addAll(toRegister);
        return this;
    }

    @NotNull
    public RegistrationOptions toRegister(Registrable ... toRegister) {
        return this.toRegister(Arrays.asList(toRegister));
    }

    @NotNull
    public RegistrationOptions toRegister(@NotNull AnnoyingPlugin plugin, @NotNull Collection<Class<? extends Registrable>> toRegister) {
        for (Class<? extends Registrable> registrable : toRegister) {
            try {
                this.toRegister.add(registrable.getConstructor(((Object)((Object)plugin)).getClass()).newInstance(new Object[]{plugin}));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    @SafeVarargs
    @NotNull
    public final RegistrationOptions toRegister(@NotNull AnnoyingPlugin plugin, Class<? extends Registrable> ... toRegister) {
        return this.toRegister(plugin, Arrays.asList(toRegister));
    }

    @NotNull
    public RegistrationOptions papiExpansionToRegister(@NotNull Supplier<Object> papiExpansionToRegister) {
        this.papiExpansionToRegister = papiExpansionToRegister;
        return this;
    }

    public static class AutomaticRegistration
    extends Stringable {
        @NotNull
        public final Set<String> packages = new HashSet<String>();
        @NotNull
        public final Set<Class<? extends Registrable>> ignoredClasses = new HashSet<Class<? extends Registrable>>();

        @NotNull
        public static AutomaticRegistration load(@NotNull ConfigurationSection section) {
            AutomaticRegistration automaticRegistration = new AutomaticRegistration();
            if (section.contains("packages")) {
                automaticRegistration.packages(section.getStringList("packages"));
            }
            return automaticRegistration;
        }

        @NotNull
        public AutomaticRegistration packages(@NotNull Collection<String> packages) {
            this.packages.addAll(packages);
            return this;
        }

        @NotNull
        public AutomaticRegistration packages(String ... packages) {
            return this.packages(Arrays.asList(packages));
        }

        @NotNull
        public AutomaticRegistration ignoredClasses(@NotNull Collection<Class<? extends Registrable>> ignoredClasses) {
            this.ignoredClasses.addAll(ignoredClasses);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final AutomaticRegistration ignoredClasses(Class<? extends Registrable> ... ignoredClasses) {
            return this.ignoredClasses(Arrays.asList(ignoredClasses));
        }
    }
}

