/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.storage;

import java.io.File;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.library.RuntimeLibrary;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.ConnectionException;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.Dialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.JSONDialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.YAMLDialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql.H2Dialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql.MariaDBDialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql.MySQLDialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql.PostgreSQLDialect;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql.SQLiteDialect;

public enum StorageMethod {
    H2(H2Dialect::new, "org{}h2{}Driver", dataFolder -> "jdbc:h2:file:.\\" + dataFolder + "\\data\\h2\\data", RuntimeLibrary.H2),
    SQLITE(SQLiteDialect::new, "org{}sqlite{}JDBC", dataFolder -> "jdbc:sqlite:" + dataFolder + "\\data\\sqlite\\data.db", null),
    MYSQL(MySQLDialect::new, StorageMethod.getMysqlMariadbDriver(), "jdbc:mysql://", null, 3306),
    MARIADB(MariaDBDialect::new, StorageMethod.getMysqlMariadbDriver(), "jdbc:mysql://", null, 3306),
    POSTGRESQL(PostgreSQLDialect::new, "org{}postgresql{}Driver", "jdbc:postgresql://", RuntimeLibrary.POSTGRESQL, 5432),
    JSON(JSONDialect::new),
    YAML(YAMLDialect::new);

    @NotNull
    public final DialectFunction dialect;
    @Nullable
    private final String driver;
    @Nullable
    public final Function<File, String> url;
    @Nullable
    public final RuntimeLibrary library;
    @Nullable
    public final Integer defaultPort;

    private StorageMethod(@NotNull DialectFunction dialect, @Nullable String driver, Function<File, String> url, RuntimeLibrary library) {
        this.dialect = dialect;
        this.driver = driver;
        this.url = url;
        this.library = library;
        this.defaultPort = null;
    }

    private StorageMethod(@NotNull DialectFunction dialect, @Nullable String driver, String url, RuntimeLibrary library, int defaultPort) {
        this.dialect = dialect;
        this.driver = driver;
        this.url = file -> url;
        this.library = library;
        this.defaultPort = defaultPort;
    }

    private StorageMethod(DialectFunction dialect) {
        this.dialect = dialect;
        this.driver = null;
        this.url = null;
        this.library = null;
        this.defaultPort = null;
    }

    @NotNull
    public Optional<String> getDriver() {
        return this.driver != null ? Optional.of(AnnoyingPlugin.replaceBrackets(this.driver)) : Optional.empty();
    }

    public boolean isRemote() {
        return this.defaultPort != null;
    }

    public boolean isSQL() {
        return this.driver != null;
    }

    @NotNull
    public static StorageMethod get(@Nullable String name) {
        if (name != null) {
            try {
                return StorageMethod.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return H2;
    }

    @NotNull
    private static String getMysqlMariadbDriver() {
        return AnnoyingPlugin.MINECRAFT_VERSION.isGreaterThanOrEqualTo(1, 16, 5) ? "com{}mysql{}cj{}jdbc{}Driver" : "com{}mysql{}jdbc{}Driver";
    }

    public static interface DialectFunction {
        @NotNull
        public Dialect apply(@NotNull DataManager var1) throws ConnectionException;
    }
}

