/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.ConnectionException;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.FailedSet;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.Value;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.storage.dialects.sql.SQLDialect;

public class SQLiteDialect
extends SQLDialect {
    public SQLiteDialect(@NotNull DataManager dataManager) throws ConnectionException {
        super(dataManager);
    }

    @Override
    @NotNull
    public PreparedStatement getTablesImpl() throws SQLException {
        return this.connection.prepareStatement("SELECT name FROM sqlite_master WHERE type='table'");
    }

    @Override
    @NotNull
    public PreparedStatement createTableImpl(@NotNull String table) throws SQLException {
        return this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS \"" + table + "\" (\"" + "target" + "\" TEXT PRIMARY KEY)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public PreparedStatement createKeyImpl(@NotNull String table, @NotNull String key) throws SQLException {
        try (ResultSet result = this.connection.createStatement().executeQuery("PRAGMA table_info(\"" + table + "\")");){
            if (result == null) return this.connection.prepareStatement("ALTER TABLE \"" + table + "\" ADD COLUMN \"" + key + "\" TEXT");
            do {
                if (!result.next()) return this.connection.prepareStatement("ALTER TABLE \"" + table + "\" ADD COLUMN \"" + key + "\" TEXT");
            } while (!result.getString("name").equals(key));
            PreparedStatement preparedStatement = null;
            return preparedStatement;
        }
        catch (SQLException e) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to get table info for &4" + table, e);
        }
        return this.connection.prepareStatement("ALTER TABLE \"" + table + "\" ADD COLUMN \"" + key + "\" TEXT");
    }

    @Override
    @NotNull
    protected PreparedStatement getAllValuesFromDatabaseImpl(@NotNull String table) throws SQLException {
        return this.connection.prepareStatement("SELECT * FROM \"" + table + "\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Optional<String> getFromDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String column) {
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT \"" + column + "\" FROM \"" + table + "\" WHERE " + "target" + " = ?");){
            statement.setString(1, target);
            ResultSet result = statement.executeQuery();
            if (!result.next()) return Optional.empty();
            Optional<String> optional = Optional.ofNullable(result.getString(column));
            return optional;
        }
        catch (SQLException e) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to get &4" + column + "&c for &4" + target + "&c in &4" + table + "&c | DEVELOPERS: Make sure you added the table/key to DataOptions!", e);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public FailedSet setToDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String column, @NotNull String value) {
        FailedSet failedSet;
        block8: {
            PreparedStatement statement = this.connection.prepareStatement("INSERT OR REPLACE INTO `" + table + "` (`" + "target" + "`, `" + column + "`) VALUES(?, ?)");
            try {
                statement.setString(1, target);
                statement.setString(2, value);
                statement.executeUpdate();
                failedSet = null;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return new FailedSet(table, target, column, value, e);
                }
            }
            statement.close();
        }
        return failedSet;
    }

    @Override
    @NotNull
    public Set<FailedSet> setToDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull ConcurrentHashMap<String, Value> data) {
        Set<Map.Entry<String, Value>> entrySet = data.entrySet();
        StringBuilder insertBuilder = new StringBuilder("INSERT OR REPLACE INTO \"" + table + "\" (\"" + "target" + "\"");
        StringBuilder valuesBuilder = new StringBuilder(" VALUES(?");
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, Value> entry : entrySet) {
            insertBuilder.append(", `").append(entry.getKey()).append("`");
            valuesBuilder.append(", ?");
            values.add(entry.getValue());
        }
        insertBuilder.append(")");
        valuesBuilder.append(")");
        HashSet<FailedSet> failed = new HashSet<FailedSet>();
        try (PreparedStatement statement = this.setValuesParameters(target, values, insertBuilder, valuesBuilder, null);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            for (Map.Entry<String, Value> entry : entrySet) {
                failed.add(new FailedSet(table, target, entry.getKey(), entry.getValue().value, e));
            }
        }
        return failed;
    }

    @Override
    public boolean removeFromDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String column) {
        boolean bl;
        block8: {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE `" + table + "` SET `" + column + "` = NULL WHERE " + "target" + " = ?");
            try {
                statement.setString(1, target);
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }
}

