/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.erraticexplosions.listeners;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.erraticexplosions.ErraticExplosions;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingListener;
import xyz.srnyx.erraticexplosions.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.erraticexplosions.reflection.org.bukkit.entity.RefCreeper;

public class CreeperListener
extends AnnoyingListener {
    @NotNull
    private final ErraticExplosions plugin;

    @Override
    @NotNull
    public ErraticExplosions getAnnoyingPlugin() {
        return this.plugin;
    }

    public CreeperListener(@NotNull ErraticExplosions plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCreatureSpawn(@NotNull CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (RefCreeper.CREEPER_SET_EXPLOSION_RADIUS == null || RefCreeper.CREEPER_SET_MAX_FUSE_TICKS == null || !(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        try {
            RefCreeper.CREEPER_SET_EXPLOSION_RADIUS.invoke((Object)creeper, (int)this.plugin.config.power.getRandom());
            RefCreeper.CREEPER_SET_MAX_FUSE_TICKS.invoke((Object)creeper, this.plugin.config.fuse.getRandom());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            AnnoyingPlugin.log(Level.WARNING, "Failed to set creeper explosion power/fuse", e);
        }
    }
}

