/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.exavior.dozed.block.DozedBlockEntityTypes;
import net.exavior.dozed.block.DozedBlocks;
import net.exavior.dozed.config.DozedConfig;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.DozedCapabilities;
import net.exavior.dozed.data.SMItemHandler;
import net.exavior.dozed.effects.DozedMobEffects;
import net.exavior.dozed.entity.DozedEntityTypes;
import net.exavior.dozed.entity.client.renderer.CrystalAlloyRenderer;
import net.exavior.dozed.entity.client.renderer.EnderLightRenderer;
import net.exavior.dozed.entity.client.renderer.FallingStarRenderer;
import net.exavior.dozed.entity.client.renderer.LightAwryRenderer;
import net.exavior.dozed.event.DozedClientGameplayEvents;
import net.exavior.dozed.item.DozedItemProperties;
import net.exavior.dozed.item.DozedItems;
import net.exavior.dozed.loot_table.DozedLootTableConditions;
import net.exavior.dozed.network.DozedNetworkHandler;
import net.exavior.dozed.particle.DozedParticles;
import net.exavior.dozed.recipe.DozedRecipeSerializers;
import net.exavior.dozed.recipe.DozedRecipeTypes;
import net.exavior.dozed.util.DozedCreativeModeTabs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.slf4j.Logger;

@Mod(value="dozed")
public class Dozed {
    public static final String MODID = "dozed";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Dozed(IEventBus modEventBus, ModContainer modContainer) {
        DozedAttachments.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerPayloadHandler);
        modEventBus.addListener(this::registerCaps);
        NeoForge.EVENT_BUS.register((Object)this);
        DozedCreativeModeTabs.register(modEventBus);
        DozedItems.register(modEventBus);
        DozedBlocks.register(modEventBus);
        DozedBlockEntityTypes.register(modEventBus);
        DozedEntityTypes.register(modEventBus);
        DozedRecipeTypes.register(modEventBus);
        DozedRecipeSerializers.register(modEventBus);
        DozedMobEffects.register(modEventBus);
        DozedParticles.register(modEventBus);
        DozedLootTableConditions.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DozedConfig.CLIENT_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DozedConfig.SERVER_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(DozedItems.CRYSTAL_ALLOY);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(DozedItems.ENDER_LIGHT);
            event.accept(DozedItems.STAR_CORE);
            event.accept(DozedItems.QUASAR_CORE);
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept(DozedBlocks.ALTAR_BLOCK);
        }
    }

    private void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        DozedNetworkHandler.register(evt.registrar("1.0"));
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.registerEntity(DozedCapabilities.STAR_MOTION_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new SMItemHandler((Player)player));
    }

    static void apiError() {
        LOGGER.error("Missing API implementation!");
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            LOGGER.error(stackTraceElement.toString());
        }
    }

    public static Optional<SMItemHandler> getSMItemHandler(Player player) {
        if (player != null) {
            return Optional.ofNullable((SMItemHandler)player.getCapability(DozedCapabilities.STAR_MOTION_CAPABILITY));
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="dozed", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            EntityRenderers.register((EntityType)((EntityType)DozedEntityTypes.FALLING_CRYSTAL_ALLOY_ENTITY.get()), CrystalAlloyRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DozedEntityTypes.ENDER_LIGHT_ENTITY.get()), EnderLightRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DozedEntityTypes.FALLING_STAR_PROJECTILE_ENTITY.get()), FallingStarRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DozedEntityTypes.LIGHT_AWRY_PROJECTILE_ENTITY.get()), LightAwryRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DozedEntityTypes.ENDER_LIGHT_ENTITY.get()), ThrownItemRenderer::new);
            DozedItemProperties.addCustomItemProperties();
            DozedClientGameplayEvents.register();
        }
    }
}

