/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.block.custom;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.exavior.dozed.block.entities.AltarBlockEntity;
import net.exavior.dozed.item.DozedItems;
import net.exavior.dozed.recipe.custom.AltarRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AltarBlock
extends BaseEntityBlock {
    public static final MapCodec<AltarBlock> CODEC = AltarBlock.simpleCodec(AltarBlock::new);

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<AltarBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState p_222120_) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!player.isCrouching() && (blockEntity = level.getBlockEntity(pos)) instanceof AltarBlockEntity) {
            AltarBlockEntity altarBlock = (AltarBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                if (stack.isEmpty()) {
                    Optional<RecipeHolder<AltarRecipe>> optional = altarBlock.getCookableRecipe(altarBlock.getIngredients(), stack, level);
                    if (optional.isPresent()) {
                        ItemStack result = altarBlock.onPlace(altarBlock.getIngredients(), stack);
                        if (result.isItemEnabled(level.enabledFeatures())) {
                            Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)result);
                        }
                    } else {
                        ItemStack storedStack = ItemStack.EMPTY;
                        boolean storedBook = false;
                        ItemStack payment = ItemStack.EMPTY;
                        for (ItemStack check : altarBlock.getIngredients()) {
                            if (check.isEnchanted() && storedStack.isEmpty()) {
                                storedStack = check;
                                continue;
                            }
                            if (check.is(Items.BOOK)) {
                                storedBook = true;
                                continue;
                            }
                            if (check.is(DozedItems.CRYSTAL_ALLOY) && !check.isEmpty()) {
                                payment = check;
                                continue;
                            }
                            if (!(!check.is(Items.BOOK) && check.isEnchanted() && !storedStack.isEmpty() || !check.is(Items.BOOK) && !check.isEnchanted()) && (!check.is(DozedItems.CRYSTAL_ALLOY) || payment.isEmpty())) continue;
                            storedStack = ItemStack.EMPTY;
                            storedBook = false;
                            payment = ItemStack.EMPTY;
                            break;
                        }
                        if (!storedStack.isEmpty() && storedBook & !payment.isEmpty()) {
                            for (ItemStack dropStack : altarBlock.getIngredients()) {
                                if (!dropStack.is(Items.BOOK)) continue;
                                if (!storedStack.isEnchanted()) break;
                                ItemEnchantments itemEnchantments = storedStack.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
                                if (itemEnchantments.isEmpty()) continue;
                                ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(itemEnchantments);
                                Object2IntMap.Entry firstEnchantment = (Object2IntMap.Entry)itemEnchantments.entrySet().iterator().next();
                                Holder enchantmentToTransfer = (Holder)firstEnchantment.getKey();
                                int levelToTransfer = firstEnchantment.getIntValue();
                                mutableEnchantments.set(enchantmentToTransfer, 0);
                                ItemEnchantments updatedEnchantments = mutableEnchantments.toImmutable();
                                EnchantmentHelper.setEnchantments((ItemStack)storedStack, (ItemEnchantments)updatedEnchantments);
                                int enchSize = itemEnchantments.size();
                                storedStack.set(DataComponents.REPAIR_COST, (Object)((Integer)storedStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0) * ((enchSize - 1) / enchSize)));
                                ItemStack enchBook = dropStack.transmuteCopy((ItemLike)Items.ENCHANTED_BOOK);
                                ItemEnchantments.Mutable bookEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                                bookEnchantments.set(enchantmentToTransfer, levelToTransfer);
                                EnchantmentHelper.setEnchantments((ItemStack)enchBook, (ItemEnchantments)bookEnchantments.toImmutable());
                                altarBlock.getIngredients().set(altarBlock.getIngredients().indexOf((Object)dropStack), (Object)enchBook);
                                altarBlock.getIngredients().remove((Object)payment);
                            }
                            for (ItemStack dropStack : altarBlock.getIngredients()) {
                                Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)dropStack);
                            }
                        } else {
                            for (ItemStack dropStack : altarBlock.getIngredients()) {
                                Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)dropStack);
                            }
                        }
                    }
                    altarBlock.getIngredients().clear();
                } else {
                    ItemStack itemStack = new ItemStack(stack.getItemHolder(), 1, stack.getComponentsPatch());
                    itemStack.setCount(1);
                    altarBlock.getIngredients().add((Object)itemStack);
                    stack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AltarBlockEntity) {
            AltarBlockEntity altarBlock = (AltarBlockEntity)blockEntity;
            for (ItemStack dropStack : altarBlock.getIngredients()) {
                Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)dropStack);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AltarBlockEntity(pos, state);
    }
}

