/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.block.entities;

import java.util.Optional;
import net.exavior.dozed.block.DozedBlockEntityTypes;
import net.exavior.dozed.recipe.DozedRecipeTypes;
import net.exavior.dozed.recipe.custom.AltarRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AltarBlockEntity
extends BlockEntity {
    private final RecipeManager.CachedCheck<CraftingInput, AltarRecipe> quickCheck = RecipeManager.createCheck(DozedRecipeTypes.ALTAR.get());
    private NonNullList<ItemStack> ingredients = NonNullList.create();

    public AltarBlockEntity(BlockPos pos, BlockState blockState) {
        super(DozedBlockEntityTypes.ALTAR_BLOCK_ENTITY.get(), pos, blockState);
    }

    public Optional<RecipeHolder<AltarRecipe>> getCookableRecipe(NonNullList<ItemStack> ingredients, ItemStack stack, Level level) {
        CraftingInput craftingInput = CraftingInput.of((int)ingredients.size(), (int)1, ingredients);
        Optional recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)craftingInput, level);
        return recipeHolder;
    }

    public ItemStack onPlace(NonNullList<ItemStack> ingredients, ItemStack stack) {
        CraftingInput craftingInput = CraftingInput.of((int)ingredients.size(), (int)1, ingredients);
        return this.quickCheck.getRecipeFor((RecipeInput)craftingInput, this.level).map(p_344662_ -> ((AltarRecipe)p_344662_.value()).assemble((RecipeInput)craftingInput, (HolderLookup.Provider)this.level.registryAccess())).orElse(stack);
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void addIngredients(ItemStack stack) {
        this.ingredients.add((Object)stack);
    }

    public void removeIngredients(ItemStack stack) {
        this.ingredients.remove((Object)stack);
    }

    public void clearIngredients() {
        this.ingredients.clear();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ListTag listtag = tag.getList("DozedIngredients", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            this.ingredients.add((Object)ItemStack.parse((HolderLookup.Provider)registries, (Tag)compoundtag).orElse(ItemStack.EMPTY));
        }
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag listtag = new ListTag();
        for (ItemStack stack : this.ingredients) {
            listtag.add((Object)stack.save(registries));
        }
        tag.put("DozedIngredients", (Tag)listtag);
        this.setChanged();
    }
}

