/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.compat;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.exavior.dozed.block.DozedBlocks;
import net.exavior.dozed.recipe.custom.AltarRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AltarCategory
implements IRecipeCategory<AltarRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"altar_block");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/altar_jei_edited.png");
    public static final RecipeType<AltarRecipe> ALTAR_RECIPE_TYPE = new RecipeType(UID, AltarRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public AltarCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 150, 79);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)DozedBlocks.ALTAR_BLOCK.get()));
    }

    public RecipeType<AltarRecipe> getRecipeType() {
        return ALTAR_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.dozed.altar_block");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AltarRecipe recipe, IFocusGroup focuses) {
        for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients().get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, 67 - 8 * (recipe.getIngredients().size() - 1) + 16 * i, 11).addIngredients(ingredient);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 52).addItemStack(recipe.getResultItem(null));
    }
}

