/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DozedConfig {
    public static final CLIENT CLIENT;
    public static final SERVER SERVER;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ModConfigSpec SERVER_SPEC;

    static {
        Pair pair = new ModConfigSpec.Builder().configure(CLIENT::new);
        CLIENT = (CLIENT)pair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)pair.getRight();
        pair = new ModConfigSpec.Builder().configure(SERVER::new);
        SERVER = (SERVER)pair.getLeft();
        SERVER_SPEC = (ModConfigSpec)pair.getRight();
    }

    public static class CLIENT {
        public final ModConfigSpec.BooleanValue quasarCoreCancelInvalidConsumption;
        public final ModConfigSpec.DoubleValue jumpPower;
        public final ModConfigSpec.DoubleValue walljumpPower;
        public final ModConfigSpec.DoubleValue dashPower;
        public final ModConfigSpec.DoubleValue skipPower;
        public final ModConfigSpec.IntValue jumpOffsetX;
        public final ModConfigSpec.IntValue jumpOffsetY;
        public final ModConfigSpec.IntValue walljumpOffsetX;
        public final ModConfigSpec.IntValue walljumpOffsetY;
        public final ModConfigSpec.IntValue dashOffsetX;
        public final ModConfigSpec.IntValue dashOffsetY;
        public final ModConfigSpec.IntValue skipOffsetX;
        public final ModConfigSpec.IntValue skipOffsetY;
        public final ModConfigSpec.BooleanValue gui_fade_out;

        CLIENT(ModConfigSpec.Builder builder) {
            builder.comment("Client Configuration Settings").push("client");
            this.quasarCoreCancelInvalidConsumption = builder.comment("Whether the Quasar Core does not perform the ability when the Health Consumption is invalid.\n Default: false").define("quasar_cancel_invalid_consumption", false);
            this.jumpPower = builder.comment("\n\nAdjust the percentage of power of the Jump ability.").defineInRange("jump_power", 1.0, 0.1, 1.0);
            this.walljumpPower = builder.comment("\n\nAdjust the percentage of power of the Wall Jump ability.").defineInRange("wall_jump_power", 1.0, 0.1, 1.0);
            this.dashPower = builder.comment("\n\nAdjust the percentage of power of the Dash ability.").defineInRange("dash_power", 1.0, 0.1, 1.0);
            this.skipPower = builder.comment("\n\nAdjust the percentage of power of the Skip ability.").defineInRange("skip_power", 1.0, 0.1, 1.0);
            this.jumpOffsetX = builder.comment("\n\nChange the Offset for the Jump GUI.").defineInRange("jump_x_offset", 0, -512, 512);
            this.jumpOffsetY = builder.defineInRange("jump_y_offset", 0, -512, 512);
            this.walljumpOffsetX = builder.comment("\nChange the Offset for the Wall Jump GUI.").defineInRange("wall_jump_x_offset", 0, -512, 512);
            this.walljumpOffsetY = builder.defineInRange("wall_jump_y_offset", 0, -512, 512);
            this.dashOffsetX = builder.comment("\nChange the Offset for the Dash GUI.").defineInRange("dash_x_offset", 0, -512, 512);
            this.dashOffsetY = builder.defineInRange("dash_y_offset", 0, -512, 512);
            this.skipOffsetX = builder.comment("\nChange the Offset for the Skip GUI.").defineInRange("skip_x_offset", 0, -512, 512);
            this.skipOffsetY = builder.defineInRange("skip_y_offset", 0, -512, 512);
            this.gui_fade_out = builder.comment("\nWhether if the gui fades out when at maxed stacks.").define("gui_fade_out", true);
            builder.pop();
        }
    }

    public static class SERVER {
        public final ModConfigSpec.BooleanValue abilityRegenOnHitGround;
        public final ModConfigSpec.BooleanValue witherDropsStarCore;
        public final ModConfigSpec.BooleanValue heldItemRequired;
        public final ModConfigSpec.ConfigValue<String> heldItemString;
        public final ModConfigSpec.IntValue crystalAlloyFallFrequency;
        public final ModConfigSpec.DoubleValue jumpPower;
        public final ModConfigSpec.DoubleValue walljumpPower;
        public final ModConfigSpec.DoubleValue dashPower;
        public final ModConfigSpec.DoubleValue skipPower;
        public final ModConfigSpec.IntValue jumpTickRegen;
        public final ModConfigSpec.IntValue walljumpTickRegen;
        public final ModConfigSpec.IntValue dashTickRegen;
        public final ModConfigSpec.IntValue skipTickRegen;
        public final ModConfigSpec.IntValue jumpITicks;
        public final ModConfigSpec.IntValue walljumpITicks;
        public final ModConfigSpec.IntValue dashITicks;
        public final ModConfigSpec.IntValue skipITicks;

        SERVER(ModConfigSpec.Builder builder) {
            builder.comment("Server Configuration Settings").push("server");
            this.abilityRegenOnHitGround = builder.comment("Whether if the player will regen their abilities once they hit the ground, or always.\n Default: false").define("ability_regen_on_hit_ground", false);
            this.witherDropsStarCore = builder.comment("\nWhether the Wither drops a Star Core on death.\n Default: false").define("wither_drops_star_core", false);
            this.heldItemRequired = builder.comment("\nWhether if it is required to hold an item for Crystal Alloy to fall.\n Default: true").define("held_item_required", true);
            this.heldItemString = builder.comment("\nChange the held item for Crystal Alloy to fall.\n Default: minecraft:nether_star").define("held_item", (Object)"minecraft:nether_star");
            this.crystalAlloyFallFrequency = builder.comment("\nChange the Frequency on Crystal Alloy falling from the night sky. The Lower the number, the Higher the frequency.").defineInRange("falling_crystal_frequency", 250, 1, 1200);
            this.jumpPower = builder.comment("\n\nAmount of scaled power for the Jump ability.").defineInRange("jump_power", 1.0, 0.01, 3.0);
            this.walljumpPower = builder.comment("\nAmount of scaled power for the Wall Jump ability.").defineInRange("wall_jump_power", 1.0, 0.01, 3.0);
            this.dashPower = builder.comment("\nAmount of scaled power for the Dash ability.").defineInRange("dash_power", 1.0, 0.01, 3.0);
            this.skipPower = builder.comment("\nAmount of scaled power for the Skip ability.").defineInRange("skip_power", 1.0, 0.01, 3.0);
            this.jumpTickRegen = builder.comment("\n\nAmount of Ticks it takes to gain a stack of Jump. 20 ticks = 1 second.").defineInRange("jump_tick_regen", 100, 1, 1200);
            this.walljumpTickRegen = builder.comment("\nAmount of Ticks it takes to gain a stack of Wall Jump. 20 ticks = 1 second.").defineInRange("wall_jump_tick_regen", 80, 1, 1200);
            this.dashTickRegen = builder.comment("\nAmount of Ticks it takes to gain a stack of Dash. 20 ticks = 1 second.").defineInRange("dash_tick_regen", 80, 1, 1200);
            this.skipTickRegen = builder.comment("\nAmount of Ticks it takes to gain a stack of Skip. 20 ticks = 1 second.").defineInRange("skip_tick_regen", 70, 1, 1200);
            this.jumpITicks = builder.comment("\n\nAmount of Invincibility Ticks when using Jump. 20 ticks = 1 second.").defineInRange("jump_tick_regen", 3, 0, 1200);
            this.walljumpITicks = builder.comment("\nAmount of Invincibility Ticks when using Wall Jump. 20 ticks = 1 second.").defineInRange("wall_jump_tick_regen", 3, 0, 1200);
            this.dashITicks = builder.comment("\nAmount of Invincibility Ticks when using Dash. 20 ticks = 1 second.").defineInRange("dash_tick_regen", 7, 0, 1200);
            this.skipITicks = builder.comment("\nAmount of Invincibility Ticks when using Skip. 20 ticks = 1 second.").defineInRange("skip_tick_regen", 7, 0, 1200);
            builder.pop();
        }
    }
}

