/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.data;

import net.exavior.dozed.block.entities.AltarBlockEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class AltarIngredientsAttachment
implements INBTSerializable<CompoundTag> {
    public NonNullList<ItemStack> ingredients = NonNullList.create();
    CompoundTag deserialized = new CompoundTag();
    public boolean markDeserialized = false;
    private HolderLookup.Provider newProvider;

    public void init(AltarBlockEntity altarEntity) {
        if (this.markDeserialized) {
            this.markDeserialized = false;
            ListTag listtag = this.deserialized.getList("DozedIngredients", 9);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                this.ingredients.add((Object)ItemStack.parse((HolderLookup.Provider)this.newProvider, (Tag)compoundtag).orElse(ItemStack.EMPTY));
            }
            System.out.println("ListTag Ingredients: " + String.valueOf(listtag));
            System.out.println("Loaded Ingredients: " + String.valueOf(this.ingredients));
        }
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void addIngredients(ItemStack stack) {
        this.ingredients.add((Object)stack);
    }

    public void removeIngredients(ItemStack stack) {
        this.ingredients.remove((Object)stack);
    }

    public void clearIngredients() {
        this.ingredients.clear();
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        ListTag listtag = new ListTag();
        for (ItemStack stack : this.ingredients) {
            listtag.add((Object)stack.save(provider));
        }
        System.out.println("Saved Ingredients: " + String.valueOf(listtag));
        compound.put("DozedIngredients", (Tag)listtag);
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.deserialized = nbt;
        this.markDeserialized = true;
        this.newProvider = provider;
    }
}

