/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.data;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SMContainer
implements Container {
    private static final int SLOT_COUNT = 1;
    private ItemStack stack = ItemStack.EMPTY;

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public ItemStack getItem(int slot) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("SMContainer only has 1 slot: 0");
        }
        return this.stack;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack result;
        if (slot != 0) {
            throw new IndexOutOfBoundsException("SMContainer only has 1 slot: 0");
        }
        if (this.stack.isEmpty() || amount <= 0) {
            return ItemStack.EMPTY;
        }
        if (this.stack.getCount() <= amount) {
            result = this.stack;
            this.stack = ItemStack.EMPTY;
        } else {
            result = this.stack.split(amount);
        }
        this.setChanged();
        return result;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("SMContainer only has 1 slot: 0");
        }
        ItemStack result = this.stack;
        this.stack = ItemStack.EMPTY;
        return result;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("SMContainer only has 1 slot: 0");
        }
        this.stack = stack;
        this.setChanged();
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.setChanged();
    }
}

