/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.data;

import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.SMAttachment;
import net.exavior.dozed.item.custom.CoreItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class SMItemHandler
implements IItemHandler {
    private final SMAttachment attachment;

    public SMItemHandler(Player player) {
        this.attachment = (SMAttachment)player.getData(DozedAttachments.SM_SLOT);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.attachment.getStack() : ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0 || stack.isEmpty() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack currentStack = this.attachment.getStack();
        if (currentStack.isEmpty()) {
            if (!simulate) {
                this.attachment.setStack(stack.copyWithCount(1));
            }
            ItemStack remainder = stack.copy();
            remainder.shrink(1);
            return remainder;
        }
        if (!simulate) {
            this.attachment.setStack(stack.copyWithCount(1));
        }
        ItemStack remainder = stack.copy();
        remainder.shrink(1);
        return currentStack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0 || amount <= 0 || this.attachment.getStack().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack toExtract = this.attachment.getStack().copy();
        if (!simulate) {
            this.attachment.clear();
        }
        return toExtract;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && stack.getItem() instanceof CoreItem;
    }
}

