/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.data;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.exavior.dozed.Dozed;
import net.exavior.dozed.data.SMItemHandler;
import net.exavior.dozed.item.custom.CoreItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class StarMotionSlot
extends Slot {
    private final Player player;
    public static final ResourceLocation EMPTY_ITEM_SLOT_STAR_CORE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"item/star_core_slot");

    public StarMotionSlot(Container container, Player owner, int index, int xPosition, int yPosition) {
        super(container, 0, xPosition, yPosition);
        this.player = owner;
    }

    private Optional<SMItemHandler> getHandler() {
        return Dozed.getSMItemHandler(this.player);
    }

    public void setChanged() {
        super.setChanged();
    }

    public boolean hasItem() {
        return !this.getItem().isEmpty();
    }

    public ItemStack getItem() {
        return this.getHandler().map(handler -> handler.getStackInSlot(0)).orElse(ItemStack.EMPTY);
    }

    public void set(ItemStack stack) {
        System.out.println("Set");
        this.getHandler().ifPresent(handler -> handler.insertItem(0, stack, false));
        this.setChanged();
    }

    public ItemStack remove(int amount) {
        return this.getHandler().map(handler -> handler.extractItem(0, amount, false)).orElse(ItemStack.EMPTY);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_ITEM_SLOT_STAR_CORE);
    }

    public boolean isActive() {
        return !this.player.hasInfiniteMaterials();
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem() instanceof CoreItem;
    }

    public boolean mayPickup(Player player) {
        return true;
    }

    public int getMaxStackSize() {
        return 1;
    }
}

