/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.exavior.dozed.entity.custom.FallingCrystalAlloyEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CrystalAlloyModel<T extends FallingCrystalAlloyEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"crystalalloymodel"), "main");
    private final ModelPart crystal_alloy;
    private final ModelPart body;

    public CrystalAlloyModel(ModelPart root) {
        this.crystal_alloy = root.getChild("crystal_alloy");
        this.body = this.crystal_alloy.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition crystal_alloy = partdefinition.addOrReplaceChild("crystal_alloy", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = crystal_alloy.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(24, 12).addBox(3.0f, 3.0f, 3.0f, -6.0f, -6.0f, -6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.body.yRot = ageInTicks * 0.05f;
        this.body.xRot = Mth.sin((float)(ageInTicks / 10.0f)) * 3.5f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.crystal_alloy.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.crystal_alloy;
    }
}

