/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.exavior.dozed.entity.client.DozedModelLayers;
import net.exavior.dozed.entity.client.model.CrystalAlloyModel;
import net.exavior.dozed.entity.custom.FallingCrystalAlloyEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CrystalAlloyRenderer
extends EntityRenderer<FallingCrystalAlloyEntity> {
    private final CrystalAlloyModel model;

    public CrystalAlloyRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CrystalAlloyModel(context.bakeLayer(DozedModelLayers.CRYSTAL_ALLOY_LAYER));
        this.shadowRadius = 0.0f;
    }

    public ResourceLocation getTextureLocation(FallingCrystalAlloyEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/entity/crystal_alloy_entity.png");
    }

    public void render(FallingCrystalAlloyEntity p_entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        RenderType renderType = RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(p_entity));
        VertexConsumer vertexconsumer = bufferSource.getBuffer(renderType);
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.translate(0.0f, -1.17f, 0.0f);
        float f9 = this.getBob(p_entity, partialTick);
        this.model.setupAnim(p_entity, 0.0f, 0.0f, f9, 0.0f, 0.0f);
        this.model.renderToBuffer(poseStack, vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)p_entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    protected float getBob(FallingCrystalAlloyEntity livingBase, float partialTick) {
        return (float)livingBase.tickCount + partialTick;
    }
}

