/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.entity.custom;

import net.exavior.dozed.entity.DozedEntityTypes;
import net.exavior.dozed.item.DozedItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class EnderLightEntity
extends ThrowableItemProjectile {
    private int lifeTick = 0;

    public EnderLightEntity(EntityType<? extends EnderLightEntity> entityType, Level level) {
        super(entityType, level);
    }

    public EnderLightEntity(Level level, LivingEntity shooter) {
        super((EntityType)DozedEntityTypes.ENDER_LIGHT_ENTITY.get(), shooter, level);
    }

    protected Item getDefaultItem() {
        return (Item)DozedItems.ENDER_LIGHT.get();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                Entity entity = this.getOwner();
                if (entity != null && EnderLightEntity.isAllowedToTeleportOwner(entity, (Level)serverlevel)) {
                    if (entity.isPassenger()) {
                        entity.unRide();
                    }
                    if (entity instanceof ServerPlayer) {
                        EntityTeleportEvent.EnderEntity event;
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        if (serverplayer.connection.isAcceptingMessages() && !(event = EventHooks.onEnderTeleport((LivingEntity)serverplayer, (double)this.getX(), (double)this.getY(), (double)this.getZ())).isCanceled()) {
                            Endermite endermite;
                            if (this.random.nextFloat() < 0.05f && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = (Endermite)EntityType.ENDERMITE.create((Level)serverlevel)) != null) {
                                endermite.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                                serverlevel.addFreshEntity((Entity)endermite);
                            }
                            entity.changeDimension(new DimensionTransition(serverlevel, event.getTarget(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                            entity.resetFallDistance();
                            serverplayer.resetCurrentImpulseContext();
                            entity.hurt(this.damageSources().fall(), 6.0f);
                            this.playSound((Level)serverlevel, this.position());
                        }
                    } else {
                        entity.changeDimension(new DimensionTransition(serverlevel, this.position(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                        entity.resetFallDistance();
                        this.playSound((Level)serverlevel, this.position());
                    }
                    this.discard();
                    return;
                }
                this.discard();
                return;
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity entity, Level level) {
        if (entity.level().dimension() == level.dimension()) {
            boolean bl;
            if (!(entity instanceof LivingEntity)) {
                bl = entity.isAlive();
            } else {
                LivingEntity livingentity = (LivingEntity)entity;
                bl = livingentity.isAlive() && !livingentity.isSleeping();
            }
            return bl;
        }
        return entity.canUsePortal(true);
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer && !entity.isAlive() && this.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else {
            super.tick();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity instanceof ServerPlayer) {
                    EntityTeleportEvent.EnderEntity event;
                    ServerPlayer serverplayer = (ServerPlayer)entity;
                    if (this.lifeTick > 9 && !(event = EventHooks.onEnderTeleport((LivingEntity)serverplayer, (double)this.getX(), (double)this.getY(), (double)this.getZ())).isCanceled()) {
                        Endermite endermite;
                        if (this.random.nextFloat() < 0.05f && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = (Endermite)EntityType.ENDERMITE.create((Level)serverlevel)) != null) {
                            endermite.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                            serverlevel.addFreshEntity((Entity)endermite);
                        }
                        entity.changeDimension(new DimensionTransition(serverlevel, event.getTarget(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                        entity.resetFallDistance();
                        serverplayer.resetCurrentImpulseContext();
                        entity.hurt(this.damageSources().fall(), 3.0f);
                        this.playSound((Level)serverlevel, this.position());
                        this.discard();
                    }
                }
            }
            ++this.lifeTick;
        }
    }

    private void playSound(Level level, Vec3 pos) {
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        boolean bl;
        Entity entity;
        if (oldLevel.dimension() == Level.END && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            bl = super.canChangeDimensions(oldLevel, newLevel) && serverplayer.seenCredits;
        } else {
            bl = super.canChangeDimensions(oldLevel, newLevel);
        }
        return bl;
    }

    protected void onInsideBlock(BlockState state) {
        Entity entity;
        super.onInsideBlock(state);
        if (state.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.onInsideBlock(state);
        }
    }

    protected double getDefaultGravity() {
        return 0.02;
    }
}

