/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.entity.custom;

import javax.annotation.Nullable;
import net.exavior.dozed.item.DozedItems;
import net.exavior.dozed.particle.DozedParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;

public class FallingCrystalAlloyEntity
extends Projectile {
    private int lifeTick = 0;
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.defineId(FallingCrystalAlloyEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> HIT_ENTITY = SynchedEntityData.defineId(FallingCrystalAlloyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int FLAG_NOPHYSICS = 2;
    private Vec3 angle;
    @Nullable
    private BlockState lastState;
    protected boolean inGround;
    protected int inGroundTime;
    public int shakeTime;
    private int life;
    private double baseDamage = 1.0;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();

    public FallingCrystalAlloyEntity(EntityType<? extends FallingCrystalAlloyEntity> entityType, Level level) {
        super(entityType, level);
        this.angle = new Vec3((double)this.getRandom().nextInt(-3, 3) * 0.05, 0.0, (double)this.getRandom().nextInt(-3, 3) * 0.05);
    }

    public void setSoundEvent(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * FallingCrystalAlloyEntity.getViewScale()) * d0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID_FLAGS, (Object)0);
        builder.define(HIT_ENTITY, (Object)false);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
        this.life = 0;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.setPos(x, y, z);
        this.setRot(yRot, xRot);
    }

    public void setRot(float p_19916_, float p_19917_) {
        this.setYRot(p_19916_ % 360.0f);
        this.setXRot(p_19917_ % 360.0f);
    }

    public void lerpMotion(double x, double y, double z) {
        super.lerpMotion(x, y, z);
        this.life = 0;
    }

    public void tick() {
        VoxelShape voxelshape;
        super.tick();
        boolean flag = this.isNoPhysics();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!(blockstate.isAir() || flag || (voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty())) {
            Vec3 vec31 = this.position();
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos).contains(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain() || blockstate.is(Blocks.POWDER_SNOW) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.clearFire();
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            Vec3 vec32 = this.position();
            Vec3 vec33 = vec32.add(vec3);
            BlockHitResult hitresult = this.level().clip(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.getType() != HitResult.Type.MISS) {
                vec33 = hitresult.getLocation();
            }
            if (!this.isRemoved()) {
                EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.getType() != HitResult.Type.MISS && !flag && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    ProjectileDeflection projectiledeflection = this.hitTargetOrDeflectSelf((HitResult)hitresult);
                    this.hasImpulse = true;
                    if (projectiledeflection != ProjectileDeflection.NONE) {
                        // empty if block
                    }
                }
            }
            vec3 = this.getDeltaMovement();
            double d5 = vec3.x;
            double d6 = vec3.y;
            double d1 = vec3.z;
            double d7 = this.getX() + d5;
            double d2 = this.getY() + d6;
            double d3 = this.getZ() + d1;
            double d4 = vec3.horizontalDistance();
            if (flag) {
                this.setYRot((float)(Mth.atan2((double)(-d5), (double)(-d1)) * 180.0 / 3.1415927410125732));
            } else {
                this.setYRot((float)(Mth.atan2((double)d5, (double)d1) * 180.0 / 3.1415927410125732));
            }
            this.setXRot((float)(Mth.atan2((double)d6, (double)d4) * 180.0 / 3.1415927410125732));
            this.setXRot(FallingCrystalAlloyEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(FallingCrystalAlloyEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            float f = 0.99f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f1 = 0.25f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.getWaterInertia();
            }
            if (!flag) {
                this.push(this.angle.x * 0.01, -0.01, this.angle.z * 0.01);
            }
            this.setPos(d7, d2, d3);
            this.checkInsideBlocks();
        }
        if (this.lifeTick % 10 == 0) {
            this.level().playLocalSound((Entity)this, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.AMBIENT, 1.0f, 1.8f);
        }
        this.level().addParticle((ParticleOptions)DozedParticles.AMETHYST_LANTERN_GLOW.get(), true, this.getX() + (double)this.random.nextInt(-3, 3) * 0.2, this.getY() + (double)this.random.nextInt(-3, 3) * 0.2, this.getZ() + (double)this.random.nextInt(-3, 3) * 0.2, 0.0, 0.0, 0.0);
        this.level().addParticle((ParticleOptions)DozedParticles.AMETHYST_LANTERN_GLOW_STATIC.get(), true, this.getX() + (double)this.random.nextInt(-3, 3) * 0.2, this.getY() + (double)this.random.nextInt(-3, 3) * 0.2, this.getZ() + (double)this.random.nextInt(-3, 3) * 0.2, 0.0, 0.0, 0.0);
        this.level().addParticle((ParticleOptions)DozedParticles.AMETHYST_LANTERN_GLOW.get(), true, this.getX() + (double)this.random.nextInt(-3, 3) * 0.2, this.getY() + (double)this.random.nextInt(-3, 3) * 0.2, this.getZ() + (double)this.random.nextInt(-3, 3) * 0.2, 0.0, 0.0, 0.0);
        ++this.lifeTick;
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
        this.life = 0;
    }

    public void move(MoverType type, Vec3 pos) {
        super.move(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (!((Boolean)this.entityData.get(HIT_ENTITY)).booleanValue()) {
            boolean flag;
            Entity entity = result.getEntity();
            Entity entity1 = this.getOwner();
            DamageSource damagesource = this.damageSources().source(DamageTypes.GENERIC);
            float j = (float)this.baseDamage;
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity1;
                livingentity1.setLastHurtMob(entity);
            }
            boolean bl = flag = entity.getType() == EntityType.ENDERMAN;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.hurt(damagesource, j);
                livingEntity.invulnerableTime = 0;
                this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                this.setHitEntity(true);
                this.discard();
                this.spawnAtLocation((ItemLike)DozedItems.CRYSTAL_ALLOY);
            }
        }
        super.onHitEntity(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!((Boolean)this.entityData.get(HIT_ENTITY)).booleanValue()) {
            this.lastState = this.level().getBlockState(result.getBlockPos());
            super.onHitBlock(result);
            Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
            this.setDeltaMovement(vec3);
            Vec3 vec31 = vec3.normalize().scale((double)0.05f);
            this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
            this.inGround = true;
            this.shakeTime = 7;
            this.discard();
            this.spawnAtLocation((ItemLike)DozedItems.CRYSTAL_ALLOY);
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.ARROW_HIT;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity target) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("life", (short)this.life);
        if (this.lastState != null) {
            compound.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
        compound.putByte("shake", (byte)this.shakeTime);
        compound.putBoolean("inGround", this.inGround);
        compound.putDouble("damage", this.baseDamage);
        compound.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey((Object)this.soundEvent).toString());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.life = compound.getShort("life");
        if (compound.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("inBlockState"));
        }
        this.shakeTime = compound.getByte("shake") & 0xFF;
        this.inGround = compound.getBoolean("inGround");
        if (compound.contains("damage", 99)) {
            this.baseDamage = compound.getDouble("damage");
        }
        if (compound.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(ResourceLocation.parse((String)compound.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
    }

    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public boolean isAttackable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    private void setFlag(int id, boolean value) {
        byte b0 = (Byte)this.entityData.get(ID_FLAGS);
        if (value) {
            this.entityData.set(ID_FLAGS, (Object)((byte)(b0 | id)));
        } else {
            this.entityData.set(ID_FLAGS, (Object)((byte)(b0 & ~id)));
        }
    }

    private void setHitEntity(boolean value) {
        this.entityData.set(HIT_ENTITY, (Object)value);
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean noPhysics) {
        this.noPhysics = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        return !this.level().isClientSide ? this.noPhysics : ((Byte)this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    public boolean isPickable() {
        return false;
    }
}

