/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.entity.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallingStarProjectileEntity
extends Projectile {
    private int lifeTick = 0;
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.defineId(FallingStarProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> HIT_ENTITY = SynchedEntityData.defineId(FallingStarProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.defineId(FallingStarProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int FLAG_NOPHYSICS = 2;
    @Nullable
    private BlockState lastState;
    protected boolean inGround;
    protected int inGroundTime;
    private int invTime = 20;
    public int shakeTime;
    private int life;
    private double baseDamage = 1.0;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();

    public FallingStarProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public void setSoundEvent(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * FallingStarProjectileEntity.getViewScale()) * d0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID_FLAGS, (Object)0);
        builder.define(HIT_ENTITY, (Object)false);
        builder.define(IS_ACTIVE, (Object)false);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
        this.life = 0;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.setPos(x, y, z);
        this.setRot(yRot, xRot);
    }

    public void setRot(float p_19916_, float p_19917_) {
        this.setYRot(p_19916_ % 360.0f);
        this.setXRot(p_19917_ % 360.0f);
    }

    public void lerpMotion(double x, double y, double z) {
        super.lerpMotion(x, y, z);
        this.life = 0;
    }

    public void setInvTime(int timeInTicks) {
        if (this.invTime >= 0) {
            this.invTime = timeInTicks;
        }
    }

    public void tick() {
        VoxelShape voxelshape;
        super.tick();
        boolean flag = this.isNoPhysics();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!(blockstate.isAir() || flag || (voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty())) {
            Vec3 vec31 = this.position();
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos).contains(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            Vec3 vec32 = this.position();
            Vec3 vec33 = vec32.add(vec3);
            BlockHitResult hitresult = this.level().clip(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.getType() != HitResult.Type.MISS) {
                vec33 = hitresult.getLocation();
            }
            vec3 = this.getDeltaMovement();
            double d5 = vec3.x;
            double d6 = vec3.y;
            double d1 = vec3.z;
            double d7 = this.getX() + d5;
            double d2 = this.getY() + d6;
            double d3 = this.getZ() + d1;
            double d4 = vec3.horizontalDistance();
            if (flag) {
                this.setYRot((float)(Mth.atan2((double)(-d5), (double)(-d1)) * 180.0 / 3.1415927410125732));
            } else {
                this.setYRot((float)(Mth.atan2((double)d5, (double)d1) * 180.0 / 3.1415927410125732));
            }
            this.setXRot((float)(Mth.atan2((double)d6, (double)d4) * 180.0 / 3.1415927410125732));
            this.setXRot(FallingStarProjectileEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(FallingStarProjectileEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            float f = 0.8f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f1 = 0.25f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
            }
            this.setDeltaMovement(vec3.scale((double)f));
            this.level().addParticle((ParticleOptions)ParticleTypes.GLOW, true, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.setPos(d7, d2, d3);
            this.checkInsideBlocks();
        }
        double radius = 1.5;
        double halfHeight = 0.75;
        double px = this.getX();
        double py = this.getY();
        double pz = this.getZ();
        AABB damageArea = new AABB(px - radius, py - halfHeight, pz - radius, px + radius, py + halfHeight, pz + radius);
        AABB slowArea = new AABB(px - 1.0, py - halfHeight, pz - 1.0, px + 1.0, py + halfHeight, pz + 1.0);
        List entities = this.level().getEntities((Entity)this, damageArea.inflate(0.5), e -> e.isAlive() && e != this.getOwner() && e instanceof LivingEntity);
        List slowEntities = this.level().getEntities((Entity)this, slowArea.inflate(0.5), e -> e.isAlive() && e != this.getOwner() && e instanceof LivingEntity);
        if (!slowEntities.isEmpty()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.45));
        }
        for (Entity e2 : entities) {
            boolean intersectZ;
            AABB entityBox = e2.getBoundingBox();
            boolean intersectX = entityBox.maxX >= damageArea.minX && entityBox.minX <= damageArea.maxX;
            boolean intersectY = entityBox.maxY >= damageArea.minY && entityBox.minY <= damageArea.maxY;
            boolean bl = intersectZ = entityBox.maxZ >= damageArea.minZ && entityBox.minZ <= damageArea.maxZ;
            if (!intersectX || !intersectY || !intersectZ) continue;
            if (!((Boolean)this.entityData.get(IS_ACTIVE)).booleanValue()) {
                this.entityData.set(IS_ACTIVE, (Object)true);
            }
            if (!e2.hurt(this.damageSources().generic(), 2.0f)) continue;
            e2.invulnerableTime = this.invTime;
            this.level().playSound((Entity)this, e2.blockPosition(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.PLAYERS, 0.4f, 1.7f);
            this.level().playSound((Entity)this, e2.blockPosition(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 0.4f, 1.8f);
        }
        if (Math.abs(this.getDeltaMovement().x) < 0.1 && Math.abs(this.getDeltaMovement().z) < 0.1 || this.inGround) {
            this.entityData.set(IS_ACTIVE, (Object)true);
        }
        if (((Boolean)this.entityData.get(IS_ACTIVE)).booleanValue()) {
            ++this.lifeTick;
            for (int i = 0; i < 10; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.GLOW, this.getX() + (double)this.random.nextInt((int)(-radius) * 10, (int)radius * 10) * 0.1, this.getY(), this.getZ() + (double)this.random.nextInt((int)(-radius) * 10, (int)radius * 10) * 0.1, 0.0, 0.0, 0.0);
            }
        }
        if (this.lifeTick > 100) {
            this.discard();
        }
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
        this.life = 0;
    }

    public void move(MoverType type, Vec3 pos) {
        super.move(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!((Boolean)this.entityData.get(HIT_ENTITY)).booleanValue()) {
            this.lastState = this.level().getBlockState(result.getBlockPos());
            super.onHitBlock(result);
            Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
            this.setDeltaMovement(vec3.scale(0.0));
            Vec3 vec31 = vec3.normalize().scale((double)0.05f);
            this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
            this.inGround = true;
            this.shakeTime = 7;
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.ARROW_HIT;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity target) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("life", (short)this.life);
        if (this.lastState != null) {
            compound.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
        compound.putByte("shake", (byte)this.shakeTime);
        compound.putBoolean("inGround", this.inGround);
        compound.putDouble("damage", this.baseDamage);
        compound.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey((Object)this.soundEvent).toString());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.life = compound.getShort("life");
        if (compound.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("inBlockState"));
        }
        this.shakeTime = compound.getByte("shake") & 0xFF;
        this.inGround = compound.getBoolean("inGround");
        if (compound.contains("damage", 99)) {
            this.baseDamage = compound.getDouble("damage");
        }
        if (compound.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(ResourceLocation.parse((String)compound.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
    }

    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public boolean isAttackable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    private void setFlag(int id, boolean value) {
        byte b0 = (Byte)this.entityData.get(ID_FLAGS);
        if (value) {
            this.entityData.set(ID_FLAGS, (Object)((byte)(b0 | id)));
        } else {
            this.entityData.set(ID_FLAGS, (Object)((byte)(b0 & ~id)));
        }
    }

    private void setHitEntity(boolean value) {
        this.entityData.set(HIT_ENTITY, (Object)value);
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean noPhysics) {
        this.noPhysics = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        return !this.level().isClientSide ? this.noPhysics : ((Byte)this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    public boolean isPickable() {
        return false;
    }
}

