/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.entity.custom;

import net.exavior.dozed.particle.DozedParticles;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class LightAwryEntity
extends Projectile {
    private LivingEntity target;
    private int lifeTick = 0;

    public LightAwryEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        if (this.lifeTick > 150) {
            this.discard();
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        float f = 0.9f;
        this.setDeltaMovement(vec3.scale((double)f));
        if (this.target != null) {
            Vec3 targetPos = new Vec3(this.target.getX(), this.target.getY() + (double)(this.target.getBbHeight() / 2.0f), this.target.getZ());
            Vec3 direction = targetPos.subtract(this.position()).normalize();
            Vec3 movement = direction.scale(0.1 + (double)this.lifeTick * 0.009);
            if (this.lifeTick > 80) {
                this.setDeltaMovement(movement);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(movement));
            }
        }
        this.setPos(d0, d1, d2);
        this.level().addParticle((ParticleOptions)DozedParticles.AMETHYST_LANTERN_GLOW.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        ++this.lifeTick;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected void onHit(HitResult result) {
        HitResult.Type hitresult$type = result.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            EntityHitResult entityhitresult = (EntityHitResult)result;
            Entity entity = entityhitresult.getEntity();
            if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(entityhitresult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, result.getLocation(), GameEvent.Context.of((Entity)this, null));
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity livingEntity;
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) == this.target) {
            livingEntity.hurt(this.damageSources().generic(), 3.0f);
            livingEntity.igniteForTicks(35);
            this.discard();
        }
    }

    protected void onInsideBlock(BlockState state) {
        super.onInsideBlock(state);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public LivingEntity getTarget() {
        return this.target;
    }
}

