/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.event;

import java.util.Iterator;
import net.exavior.dozed.config.DozedConfig;
import net.exavior.dozed.data.DashAttachment;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.JumpAttachment;
import net.exavior.dozed.data.SMAttachment;
import net.exavior.dozed.data.SlideAttachment;
import net.exavior.dozed.data.WallJumpAttachment;
import net.exavior.dozed.event.custom.PostLivingFallEvent;
import net.exavior.dozed.item.DozedItems;
import net.exavior.dozed.keymap.DozedClientKeyMaps;
import net.exavior.dozed.network.client.packets.CPacketSyncSlideFall;
import net.exavior.dozed.network.client.packets.CTSGiveITicksPacket;
import net.exavior.dozed.network.client.packets.CTSPlayerHealthQuasarPacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class DozedClientGameplayEvents {
    public static void register() {
        NeoForge.EVENT_BUS.register(DozedClientGameplayEvents.class);
    }

    @SubscribeEvent
    public static void onDashQuasarPressed(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE) && !((KeyMapping)DozedClientKeyMaps.D_DASH.get()).isDown()) {
            player.setData(DozedAttachments.DASH_QUASAR_PRESSED, (Object)false);
        }
    }

    @SubscribeEvent
    public static void onDDash(ClientTickEvent.Pre event) {
        while (((KeyMapping)DozedClientKeyMaps.D_DASH.get()).consumeClick()) {
            Vec3 scaledView;
            Vec3 scaledView2;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) continue;
            float current_health = player.getHealth();
            if (!((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled) continue;
            Options options = Minecraft.getInstance().options;
            int wKey = options.keyUp.isDown() ? 1 : 0;
            int sKey = options.keyDown.isDown() ? 1 : 0;
            int aKey = options.keyLeft.isDown() ? 1 : 0;
            int dKey = options.keyRight.isDown() ? 1 : 0;
            int totalKeys = wKey + sKey + aKey + dKey;
            int playerDashes = (Integer)player.getData(DozedAttachments.DASH_LEFT);
            boolean quasar = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE);
            if (playerDashes <= 0 && (!quasar || ((Boolean)player.getData(DozedAttachments.DASH_QUASAR_PRESSED)).booleanValue()) || totalKeys <= 0) continue;
            player.setData(DozedAttachments.DASH_QUASAR_PRESSED, (Object)true);
            if (playerDashes <= 0) {
                if (DozedConfig.CLIENT.quasarCoreCancelInvalidConsumption.getAsBoolean() && player.getHealth() <= player.getMaxHealth() / 4.0f) {
                    return;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new CTSPlayerHealthQuasarPacket(current_health), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            Vec3 playerView = player.getLookAngle();
            double totalPushX = 0.0;
            double totalPushZ = 0.0;
            if (totalKeys <= 0) continue;
            if (wKey == 1) {
                scaledView2 = playerView.normalize().scale(1.7);
                totalPushX += scaledView2.x;
                totalPushZ += scaledView2.z;
            }
            if (aKey == 1) {
                Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(1.7);
                totalPushX += leftward.x;
                totalPushZ += leftward.z;
            }
            if (dKey == 1) {
                Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(1.7);
                totalPushX += rightward.x;
                totalPushZ += rightward.z;
            }
            if (sKey == 1) {
                scaledView2 = playerView.normalize().scale(-1.7);
                totalPushX += scaledView2.x;
                totalPushZ += scaledView2.z;
            }
            totalPushX /= (double)totalKeys;
            totalPushZ /= (double)totalKeys;
            double totalPower = DozedConfig.SERVER.dashPower.getAsDouble();
            double clientPower = DozedConfig.CLIENT.dashPower.getAsDouble();
            PacketDistributor.sendToServer((CustomPacketPayload)new CTSGiveITicksPacket(DozedConfig.SERVER.dashITicks.getAsInt()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.setDeltaMovement(0.0, 0.0, 0.0);
            player.fallDistance = 0.0f;
            player.setData(DozedAttachments.DASH_LEFT, (Object)Math.max(0, (Integer)player.getData(DozedAttachments.DASH_LEFT) - 1));
            player.setData(DozedAttachments.DID_HIT_GROUND, (Object)false);
            player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 0.8f);
            if (playerView.y > 0.0 && sKey == 0) {
                scaledView = playerView.normalize().scale(0.4);
                player.push(totalPushX * totalPower * clientPower, scaledView.y + 0.3, totalPushZ * totalPower * clientPower);
                continue;
            }
            if (sKey == 1) {
                scaledView = playerView.normalize().scale(0.4);
                player.push(totalPushX * totalPower * clientPower, -scaledView.y + 0.3, totalPushZ * totalPower * clientPower);
                continue;
            }
            player.push(totalPushX * totalPower * clientPower, playerView.y, totalPushZ * totalPower * clientPower);
        }
    }

    @SubscribeEvent
    public static void onJumpQuasarPressed(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE) && !((KeyMapping)DozedClientKeyMaps.D_JUMP.get()).isDown()) {
            player.setData(DozedAttachments.JUMP_QUASAR_PRESSED, (Object)false);
        }
    }

    @SubscribeEvent
    public static void onDJump(ClientTickEvent.Pre event) {
        while (((KeyMapping)DozedClientKeyMaps.D_JUMP.get()).consumeClick()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.onGround() || player.isInLiquid()) continue;
            float current_health = player.getHealth();
            if (!((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled) continue;
            int playerJumps = (Integer)player.getData(DozedAttachments.JUMP_LEFT);
            boolean quasar = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE);
            if (playerJumps <= 0 && (!quasar || ((Boolean)player.getData(DozedAttachments.JUMP_QUASAR_PRESSED)).booleanValue())) continue;
            player.setData(DozedAttachments.JUMP_QUASAR_PRESSED, (Object)true);
            if (playerJumps <= 0) {
                if (DozedConfig.CLIENT.quasarCoreCancelInvalidConsumption.getAsBoolean() && player.getHealth() <= player.getMaxHealth() / 4.0f) {
                    return;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new CTSPlayerHealthQuasarPacket(current_health), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            Options options = Minecraft.getInstance().options;
            int wKey = options.keyUp.isDown() ? 1 : 0;
            int sKey = options.keyDown.isDown() ? 1 : 0;
            int aKey = options.keyLeft.isDown() ? 1 : 0;
            int dKey = options.keyRight.isDown() ? 1 : 0;
            int totalKeys = wKey + sKey + aKey + dKey;
            Vec3 deltaM = player.getDeltaMovement();
            double totalPushX = 0.0;
            double totalPushZ = 0.0;
            Vec3 playerView = player.getLookAngle();
            if (totalKeys > 0) {
                Vec3 scaledView;
                if (wKey == 1) {
                    scaledView = playerView.normalize().scale(0.3);
                    totalPushX += scaledView.x;
                    totalPushZ += scaledView.z;
                }
                if (aKey == 1) {
                    Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(0.3);
                    totalPushX += leftward.x;
                    totalPushZ += leftward.z;
                }
                if (dKey == 1) {
                    Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(0.3);
                    totalPushX += rightward.x;
                    totalPushZ += rightward.z;
                }
                if (sKey == 1) {
                    scaledView = playerView.normalize().scale(-0.3);
                    totalPushX += scaledView.x;
                    totalPushZ += scaledView.z;
                }
            }
            totalPushX /= (double)totalKeys;
            totalPushZ /= (double)totalKeys;
            double totalPower = DozedConfig.SERVER.jumpPower.getAsDouble();
            double clientPower = DozedConfig.CLIENT.jumpPower.getAsDouble();
            PacketDistributor.sendToServer((CustomPacketPayload)new CTSGiveITicksPacket(DozedConfig.SERVER.jumpITicks.getAsInt()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.setDeltaMovement(0.0, 0.0, 0.0);
            player.fallDistance = 0.0f;
            player.setData(DozedAttachments.JUMP_LEFT, (Object)Math.max(0, (Integer)player.getData(DozedAttachments.JUMP_LEFT) - 1));
            player.setData(DozedAttachments.DID_HIT_GROUND, (Object)false);
            player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 1.3f);
            if (player.getLookAngle().y > 0.0) {
                Vec3 scaledView = playerView.normalize().scale(0.3);
                player.push(totalPushX + deltaM.x, (scaledView.y + 0.7) * totalPower * clientPower, totalPushZ + deltaM.z);
                continue;
            }
            player.push(totalPushX + deltaM.x, 0.7 * totalPower * clientPower, totalPushZ + deltaM.z);
        }
    }

    @SubscribeEvent
    public static void onWallJumpQuasarPressed(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE) && !((KeyMapping)DozedClientKeyMaps.D_WALL_JUMP.get()).isDown()) {
            player.setData(DozedAttachments.WALL_JUMP_QUASAR_PRESSED, (Object)false);
        }
    }

    @SubscribeEvent
    public static void onDWallJump(ClientTickEvent.Pre event) {
        while (((KeyMapping)DozedClientKeyMaps.D_WALL_JUMP.get()).consumeClick()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.onGround() || player.isInLiquid()) continue;
            float current_health = player.getHealth();
            if (!((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled) continue;
            int playerJumps = (Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT);
            boolean quasar = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE);
            if (playerJumps <= 0 && (!quasar || ((Boolean)player.getData(DozedAttachments.WALL_JUMP_QUASAR_PRESSED)).booleanValue())) continue;
            AABB aabb = player.getBoundingBox().inflate(0.5, 0.0, 0.5);
            Iterable collisions = player.level().getBlockCollisions((Entity)player, aabb);
            boolean hasCollision = false;
            Iterator iterator = collisions.iterator();
            if (iterator.hasNext()) {
                VoxelShape voxelShape = (VoxelShape)iterator.next();
                hasCollision = true;
            }
            if (!hasCollision) continue;
            player.setData(DozedAttachments.WALL_JUMP_QUASAR_PRESSED, (Object)true);
            if (playerJumps <= 0) {
                if (DozedConfig.CLIENT.quasarCoreCancelInvalidConsumption.getAsBoolean() && player.getHealth() <= player.getMaxHealth() / 4.0f) {
                    return;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new CTSPlayerHealthQuasarPacket(current_health), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            Options options = Minecraft.getInstance().options;
            int wKey = options.keyUp.isDown() ? 1 : 0;
            int sKey = options.keyDown.isDown() ? 1 : 0;
            int aKey = options.keyLeft.isDown() ? 1 : 0;
            int dKey = options.keyRight.isDown() ? 1 : 0;
            int totalKeys = wKey + sKey + aKey + dKey;
            Vec3 deltaM = player.getDeltaMovement();
            double totalPushX = 0.0;
            double totalPushZ = 0.0;
            Vec3 playerView = player.getLookAngle();
            if (totalKeys > 0) {
                Vec3 scaledView;
                if (wKey == 1) {
                    scaledView = playerView.normalize().scale(0.3);
                    totalPushX += scaledView.x;
                    totalPushZ += scaledView.z;
                }
                if (aKey == 1) {
                    Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(0.3);
                    totalPushX += leftward.x;
                    totalPushZ += leftward.z;
                }
                if (dKey == 1) {
                    Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(0.3);
                    totalPushX += rightward.x;
                    totalPushZ += rightward.z;
                }
                if (sKey == 1) {
                    scaledView = playerView.normalize().scale(-0.3);
                    totalPushX += scaledView.x;
                    totalPushZ += scaledView.z;
                }
            }
            double totalPower = DozedConfig.SERVER.walljumpPower.getAsDouble();
            double clientPower = DozedConfig.CLIENT.walljumpPower.getAsDouble();
            PacketDistributor.sendToServer((CustomPacketPayload)new CTSGiveITicksPacket(DozedConfig.SERVER.walljumpITicks.getAsInt()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.setDeltaMovement(0.0, 0.0, 0.0);
            player.setData(DozedAttachments.WALL_JUMP_LEFT, (Object)Math.max(0, (Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) - 1));
            player.setData(DozedAttachments.DID_HIT_GROUND, (Object)false);
            player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 1.3f);
            if (playerView.y > 0.0) {
                double scaledView = playerView.y * 0.15;
                player.push(totalPushX + deltaM.x, (0.8 + scaledView) * totalPower * clientPower, totalPushZ + deltaM.z);
                continue;
            }
            player.push(totalPushX + deltaM.x, 0.8 * totalPower * clientPower, totalPushZ + deltaM.z);
        }
    }

    @SubscribeEvent
    public static void onSkipFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float current_health = player.getHealth();
            float distance = Math.clamp(event.getDistance(), 0.0f, 10.0f);
            if (((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled && ((KeyMapping)DozedClientKeyMaps.D_SKIP.get()).isDown()) {
                Options options = Minecraft.getInstance().options;
                int wKey = options.keyUp.isDown() ? 1 : 0;
                int sKey = options.keyDown.isDown() ? 1 : 0;
                int aKey = options.keyLeft.isDown() ? 1 : 0;
                int dKey = options.keyRight.isDown() ? 1 : 0;
                int totalKeys = wKey + sKey + aKey + dKey;
                int playerSlides = (Integer)player.getData(DozedAttachments.SKIP_LEFT);
                boolean quasar = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.QUASAR_CORE);
                if ((playerSlides > 0 || quasar) && totalKeys > 0) {
                    Vec3 scaledView;
                    if (playerSlides <= 0 && !((Boolean)player.getData(DozedAttachments.SKIP_FALL_PACKET_SENT)).booleanValue()) {
                        if (DozedConfig.CLIENT.quasarCoreCancelInvalidConsumption.getAsBoolean() && player.getHealth() <= player.getMaxHealth() / 4.0f) {
                            return;
                        }
                        player.setData(DozedAttachments.SKIP_FALL_PACKET_SENT, (Object)true);
                        PacketDistributor.sendToServer((CustomPacketPayload)new CTSPlayerHealthQuasarPacket(current_health), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    Vec3 playerView = player.getLookAngle();
                    double totalPushX = 0.0;
                    double totalPushZ = 0.0;
                    if (wKey == 1) {
                        scaledView = playerView.normalize().scale(1.7);
                        totalPushX += scaledView.x;
                        totalPushZ += scaledView.z;
                    }
                    if (aKey == 1) {
                        Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(1.7);
                        totalPushX += leftward.x;
                        totalPushZ += leftward.z;
                    }
                    if (dKey == 1) {
                        Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(1.7);
                        totalPushX += rightward.x;
                        totalPushZ += rightward.z;
                    }
                    if (sKey == 1) {
                        scaledView = playerView.normalize().scale(-1.7);
                        totalPushX += scaledView.x;
                        totalPushZ += scaledView.z;
                    }
                    totalPushX /= (double)totalKeys;
                    totalPushZ /= (double)totalKeys;
                    totalPushX *= (double)distance * 0.2 + 0.7;
                    totalPushZ *= (double)distance * 0.2 + 0.7;
                    double totalPower = DozedConfig.SERVER.skipPower.getAsDouble();
                    double clientPower = DozedConfig.CLIENT.skipPower.getAsDouble();
                    PacketDistributor.sendToServer((CustomPacketPayload)new CTSGiveITicksPacket(DozedConfig.SERVER.skipITicks.getAsInt()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.setData(DozedAttachments.SKIP_LEFT, (Object)Math.max(0, (Integer)player.getData(DozedAttachments.SKIP_LEFT) - 1));
                    player.setData(DozedAttachments.DID_HIT_GROUND, (Object)false);
                    BlockState blockState = player.level().getBlockState(player.blockPosition().below());
                    BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
                    RandomSource randomSource = player.getRandom();
                    int i = 0;
                    while ((float)i < 4.0f * distance) {
                        player.level().addParticle((ParticleOptions)particle, player.getX() + (double)randomSource.nextInt(0, 5) * 0.1, player.getY() + 0.3, player.getZ() + (double)randomSource.nextInt(0, 5) * 0.1, 0.0, 0.0, 0.0);
                        ++i;
                    }
                    player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 0.8f);
                    if (((Boolean)player.getData(DozedAttachments.SLAM_HAPPEN)).booleanValue()) {
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                        Vec3 vec3 = new Vec3(totalPushX * totalPower * clientPower, 0.12 + (double)distance * 0.5, totalPushZ * totalPower * clientPower);
                        player.push(vec3);
                    } else {
                        player.push(totalPushX * totalPower * clientPower, 0.12, totalPushZ * totalPower * clientPower);
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)new CPacketSyncSlideFall(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            player.setData(DozedAttachments.SLAM_HAPPEN, (Object)false);
            player.setData(DozedAttachments.SKIP_FALL_HAPPEN, (Object)false);
        }
    }

    public static void onPlayerFallPost(PostLivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.push(0.0, (double)event.getDistance(), 0.0);
        }
    }
}

