/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.event;

import java.util.Collection;
import java.util.Map;
import net.exavior.dozed.Dozed;
import net.exavior.dozed.config.DozedConfig;
import net.exavior.dozed.data.DashAttachment;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.JumpAttachment;
import net.exavior.dozed.data.SMAttachment;
import net.exavior.dozed.data.SlideAttachment;
import net.exavior.dozed.data.WallJumpAttachment;
import net.exavior.dozed.effects.DozedMobEffects;
import net.exavior.dozed.entity.DozedEntityTypes;
import net.exavior.dozed.entity.custom.FallingCrystalAlloyEntity;
import net.exavior.dozed.event.custom.PostLivingFallEvent;
import net.exavior.dozed.item.DozedItems;
import net.exavior.dozed.item.custom.CoreItem;
import net.exavior.dozed.network.server.packets.STCAddDashRegenPacket;
import net.exavior.dozed.network.server.packets.STCAddJumpRegenPacket;
import net.exavior.dozed.network.server.packets.STCAddSkipRegenPacket;
import net.exavior.dozed.network.server.packets.STCAddWallJumpRegenPacket;
import net.exavior.dozed.particle.DozedParticles;
import net.exavior.dozed.util.CoreHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="dozed")
public class DozedEvents {
    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        Player playerEntity = evt.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            ((JumpAttachment)serverPlayer.getData(DozedAttachments.JUMP_ENABLED)).init(serverPlayer);
            ((WallJumpAttachment)serverPlayer.getData(DozedAttachments.WALL_JUMP_ENABLED)).init(serverPlayer);
            ((DashAttachment)serverPlayer.getData(DozedAttachments.DASH_ENABLED)).init(serverPlayer);
            ((SlideAttachment)serverPlayer.getData(DozedAttachments.SKIP_ENABLED)).init(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ((JumpAttachment)player2.getData(DozedAttachments.JUMP_ENABLED)).syncToClient(player2);
            ((WallJumpAttachment)player2.getData(DozedAttachments.WALL_JUMP_ENABLED)).syncToClient(player2);
            ((DashAttachment)player2.getData(DozedAttachments.DASH_ENABLED)).syncToClient(player2);
            ((SlideAttachment)player2.getData(DozedAttachments.SKIP_ENABLED)).syncToClient(player2);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone evt) {
        Player oldPlayer = evt.getOriginal();
        Player newPlayer = evt.getEntity();
        if (evt.isWasDeath()) {
            boolean keepInventory = oldPlayer.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
            if (keepInventory) {
                ItemStack oldStack = ((SMAttachment)oldPlayer.getData(DozedAttachments.SM_SLOT)).getStackWithoutHandler();
                ((SMAttachment)newPlayer.getData(DozedAttachments.SM_SLOT)).setStack(oldStack);
            }
        } else {
            ItemStack oldStack = ((SMAttachment)oldPlayer.getData(DozedAttachments.SM_SLOT)).getStackWithoutHandler();
            ((SMAttachment)newPlayer.getData(DozedAttachments.SM_SLOT)).setStack(oldStack);
            newPlayer.setData(DozedAttachments.JUMP_ENABLED, (Object)((JumpAttachment)oldPlayer.getData(DozedAttachments.JUMP_ENABLED)));
            newPlayer.setData(DozedAttachments.WALL_JUMP_ENABLED, (Object)((WallJumpAttachment)oldPlayer.getData(DozedAttachments.WALL_JUMP_ENABLED)));
            newPlayer.setData(DozedAttachments.DASH_ENABLED, (Object)((DashAttachment)oldPlayer.getData(DozedAttachments.DASH_ENABLED)));
            newPlayer.setData(DozedAttachments.SKIP_ENABLED, (Object)((SlideAttachment)oldPlayer.getData(DozedAttachments.SKIP_ENABLED)));
        }
    }

    @SubscribeEvent
    public static void entityConstructing(EntityEvent.EntityConstructing event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).level() != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((JumpAttachment)serverPlayer.getData(DozedAttachments.JUMP_ENABLED)).init(serverPlayer);
            ((WallJumpAttachment)serverPlayer.getData(DozedAttachments.WALL_JUMP_ENABLED)).init(serverPlayer);
            ((DashAttachment)serverPlayer.getData(DozedAttachments.DASH_ENABLED)).init(serverPlayer);
            ((SlideAttachment)serverPlayer.getData(DozedAttachments.SKIP_ENABLED)).init(serverPlayer);
        }
    }

    public static void entityJoinWorld(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            Dozed.getSMItemHandler((Player)serverPlayerEntity).ifPresent(handler -> {
                ServerPlayer mp = (ServerPlayer)entity;
            });
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PlayerList playerList = event.getPlayerList();
            for (ServerPlayer player : playerList.getPlayers()) {
                ((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).init(player);
                ((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).init(player);
                ((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).init(player);
                ((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).init(player);
            }
        } else {
            ServerPlayer player = event.getPlayer();
            ((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).init(player);
            ((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).init(player);
            ((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).init(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDropsEvent(LivingDropsEvent event) {
        boolean keepInventory;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isSpectator() && !(keepInventory = player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY))) {
            ItemStack stack = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStackWithoutHandler();
            if (!stack.isEmpty()) {
                Collection drops = event.getDrops();
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack);
                itemEntity.setPickUpDelay(40);
                float f = player.level().random.nextFloat() * 0.5f;
                float f1 = player.level().random.nextFloat() * ((float)Math.PI * 2);
                itemEntity.setDeltaMovement((double)(-Mth.sin((float)f1) * f), (double)0.2f, (double)(Mth.cos((float)f1) * f));
                drops.add(itemEntity);
            }
            ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).clear();
        }
    }

    @SubscribeEvent
    public static void playerTickEvent(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        ItemStack slotStack = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack();
        Item item = slotStack.getItem();
        if (item instanceof CoreItem) {
            CoreItem coreItem = (CoreItem)item;
            Map<CoreHelper.DOZED_ABILITIES, Integer> maxes = CoreHelper.getMax(coreItem);
            int DASH_REGEN = DozedConfig.SERVER.dashTickRegen.getAsInt();
            int SKIP_REGEN = DozedConfig.SERVER.skipTickRegen.getAsInt();
            int JUMP_REGEN = DozedConfig.SERVER.jumpTickRegen.getAsInt();
            int WALL_JUMP_REGEN = DozedConfig.SERVER.walljumpTickRegen.getAsInt();
            boolean ABILITY_REGEN_ON_HIT_GROUND = DozedConfig.SERVER.abilityRegenOnHitGround.getAsBoolean();
            if (!ABILITY_REGEN_ON_HIT_GROUND) {
                if (((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.DASH_REGEN) >= DASH_REGEN && (Integer)player.getData(DozedAttachments.DASH_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.DASH)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 1.3f);
                        player.setData(DozedAttachments.DASH_LEFT, (Object)((Integer)player.getData(DozedAttachments.DASH_LEFT) + 1));
                        player.setData(DozedAttachments.DASH_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.DASH_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.DASH)) {
                        player.setData(DozedAttachments.DASH_REGEN, (Object)((Integer)player.getData(DozedAttachments.DASH_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.DASH_REGEN, (Object)0);
                    }
                }
                if (((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.SKIP_REGEN) >= SKIP_REGEN && (Integer)player.getData(DozedAttachments.SKIP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.SKIP)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 1.3f);
                        player.setData(DozedAttachments.SKIP_LEFT, (Object)((Integer)player.getData(DozedAttachments.SKIP_LEFT) + 1));
                        player.setData(DozedAttachments.SKIP_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.SKIP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.SKIP)) {
                        player.setData(DozedAttachments.SKIP_REGEN, (Object)((Integer)player.getData(DozedAttachments.SKIP_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.SKIP_REGEN, (Object)0);
                    }
                }
                if (((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.JUMP_REGEN) >= JUMP_REGEN && (Integer)player.getData(DozedAttachments.JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.JUMP)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 0.8f);
                        player.setData(DozedAttachments.JUMP_LEFT, (Object)((Integer)player.getData(DozedAttachments.JUMP_LEFT) + 1));
                        player.setData(DozedAttachments.JUMP_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.JUMP)) {
                        player.setData(DozedAttachments.JUMP_REGEN, (Object)((Integer)player.getData(DozedAttachments.JUMP_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.JUMP_REGEN, (Object)0);
                    }
                }
                if (((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.WALL_JUMP_REGEN) >= WALL_JUMP_REGEN && (Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.WALL_JUMP)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 0.8f);
                        player.setData(DozedAttachments.WALL_JUMP_LEFT, (Object)((Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) + 1));
                        player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.WALL_JUMP)) {
                        player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)((Integer)player.getData(DozedAttachments.WALL_JUMP_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)0);
                    }
                }
            } else if (((Boolean)player.getData(DozedAttachments.DID_HIT_GROUND)).booleanValue()) {
                if (((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.DASH_REGEN) >= DASH_REGEN && (Integer)player.getData(DozedAttachments.DASH_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.DASH)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 1.3f);
                        player.setData(DozedAttachments.DASH_LEFT, (Object)((Integer)player.getData(DozedAttachments.DASH_LEFT) + 1));
                        player.setData(DozedAttachments.DASH_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.DASH_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.DASH)) {
                        player.setData(DozedAttachments.DASH_REGEN, (Object)((Integer)player.getData(DozedAttachments.DASH_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.DASH_REGEN, (Object)0);
                    }
                }
                if (((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.SKIP_REGEN) >= SKIP_REGEN && (Integer)player.getData(DozedAttachments.SKIP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.SKIP)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 1.3f);
                        player.setData(DozedAttachments.SKIP_LEFT, (Object)((Integer)player.getData(DozedAttachments.SKIP_LEFT) + 1));
                        player.setData(DozedAttachments.SKIP_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.SKIP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.SKIP)) {
                        player.setData(DozedAttachments.SKIP_REGEN, (Object)((Integer)player.getData(DozedAttachments.SKIP_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.SKIP_REGEN, (Object)0);
                    }
                }
                if (((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.JUMP_REGEN) >= JUMP_REGEN && (Integer)player.getData(DozedAttachments.JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.JUMP)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 0.8f);
                        player.setData(DozedAttachments.JUMP_LEFT, (Object)((Integer)player.getData(DozedAttachments.JUMP_LEFT) + 1));
                        player.setData(DozedAttachments.JUMP_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.JUMP)) {
                        player.setData(DozedAttachments.JUMP_REGEN, (Object)((Integer)player.getData(DozedAttachments.JUMP_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.JUMP_REGEN, (Object)0);
                    }
                }
                if (((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled) {
                    if ((Integer)player.getData(DozedAttachments.WALL_JUMP_REGEN) >= WALL_JUMP_REGEN && (Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.WALL_JUMP)) {
                        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.4f, 0.8f);
                        player.setData(DozedAttachments.WALL_JUMP_LEFT, (Object)((Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) + 1));
                        player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)0);
                    } else if ((Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) < maxes.get((Object)CoreHelper.DOZED_ABILITIES.WALL_JUMP)) {
                        player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)((Integer)player.getData(DozedAttachments.WALL_JUMP_REGEN) + 1));
                    } else {
                        player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)0);
                    }
                }
            }
        } else {
            player.setData(DozedAttachments.DASH_LEFT, (Object)0);
            player.setData(DozedAttachments.DASH_REGEN, (Object)0);
            player.setData(DozedAttachments.SKIP_LEFT, (Object)0);
            player.setData(DozedAttachments.SKIP_REGEN, (Object)0);
            player.setData(DozedAttachments.JUMP_LEFT, (Object)0);
            player.setData(DozedAttachments.JUMP_REGEN, (Object)0);
            player.setData(DozedAttachments.WALL_JUMP_LEFT, (Object)0);
            player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)0);
        }
    }

    @SubscribeEvent
    public static void onDamageVoidCore(LivingIncomingDamageEvent event) {
        float damage;
        Player player;
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof Player && ((SMAttachment)(player = (Player)entity).getData(DozedAttachments.SM_SLOT)).getStack().is(DozedItems.VOID_CORE) && (damage = event.getOriginalAmount()) >= player.getMaxHealth() / 4.0f) {
            if (((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new STCAddDashRegenPacket(20), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new STCAddJumpRegenPacket(20), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new STCAddWallJumpRegenPacket(20), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new STCAddSkipRegenPacket(20), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onSkipFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float distance = Math.clamp(event.getDistance(), 0.0f, 10.0f);
            float realDistance = Math.max(event.getDistance() - distance, 0.0f);
            if (((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled && ((Boolean)player.getData(DozedAttachments.SKIP_FALL_HAPPEN.get())).booleanValue()) {
                player.setData(DozedAttachments.SKIP_FALL_HAPPEN.get(), (Object)false);
                event.setDistance(realDistance);
            }
        }
    }

    public static void onJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ((Boolean)(player = (Player)livingEntity).getData(DozedAttachments.SLAM_HAPPEN)).booleanValue()) {
            player.push(0.0, (Double)player.getData(DozedAttachments.JUMP_STORAGE) * 1.5, 0.0);
        }
    }

    public static void showeringlightHurt(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(DozedMobEffects.SHOWERING_LIGHT)) {
            event.setAmount(event.getAmount() * 1.3f);
        }
    }

    public static void onPlayerFallPost(PostLivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.push(0.0, 5.0, 0.0);
            System.out.println("Testing fall");
        }
    }

    public static void onPlayerFall(LivingFallEvent event) {
        if (!event.isCanceled()) {
            NeoForge.EVENT_BUS.post((Event)new PostLivingFallEvent(event.getEntity(), event.getDistance()));
        }
    }

    @SubscribeEvent
    public static void onWitherDeathConfig(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        if (living instanceof WitherBoss) {
            WitherBoss witherBoss = (WitherBoss)living;
            if (DozedConfig.SERVER.witherDropsStarCore.getAsBoolean()) {
                witherBoss.spawnAtLocation(DozedItems.STAR_CORE);
            }
        }
    }

    @SubscribeEvent
    public static void onStarCoreTouchVoid(EntityTickEvent.Post event) {
        Entity owner;
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).getItem().is(DozedItems.STAR_CORE) && (owner = itemEntity.getOwner()) instanceof Player) {
            Player player = (Player)owner;
            if (itemEntity.blockPosition().getY() <= itemEntity.level().dimensionType().minY() - 5) {
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 8; ++i) {
                        serverLevel.sendParticles((ParticleOptions)DozedParticles.AMETHYST_LANTERN_GLOW.get(), itemEntity.getX() + (double)itemEntity.getRandom().nextInt(-3, 3) * 0.1, itemEntity.getY() + (double)itemEntity.getRandom().nextInt(0, 3) * 0.1, itemEntity.getZ() + (double)itemEntity.getRandom().nextInt(-3, 3) * 0.1, 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                itemEntity.discard();
                ItemStack itemstack = new ItemStack((ItemLike)DozedItems.VOID_CORE.get());
                if (!player.getInventory().add(itemstack)) {
                    player.drop(itemstack, false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onVoidCoreTakeLight(EntityTickEvent.Post event) {
        Entity owner;
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).getItem().is(DozedItems.VOID_CORE) && (owner = itemEntity.getOwner()) instanceof Player) {
            Player player = (Player)owner;
            if (itemEntity.hasData(DozedAttachments.DOZED_VOIDED_LIGHT_VALUE)) {
                int light = itemEntity.level().getMaxLocalRawBrightness(itemEntity.getOnPos().above());
                if (light > 6) {
                    itemEntity.setData(DozedAttachments.DOZED_VOIDED_LIGHT_VALUE, (Object)((Integer)itemEntity.getData(DozedAttachments.DOZED_VOIDED_LIGHT_VALUE) + light));
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (itemEntity.getRandom().nextFloat() < 0.1f) {
                            serverLevel.sendParticles((ParticleOptions)DozedParticles.VOIDED_LIGHT.get(), itemEntity.getX() + (double)itemEntity.getRandom().nextInt(-3, 3) * 0.1, itemEntity.getY() + (double)itemEntity.getRandom().nextInt(0, 3) * 0.1, itemEntity.getZ() + (double)itemEntity.getRandom().nextInt(-3, 3) * 0.1, 0, 0.0, 0.0, 0.0, 0.0);
                        }
                        if (itemEntity.getRandom().nextFloat() < 0.1f) {
                            serverLevel.sendParticles((ParticleOptions)DozedParticles.VOIDED_LIGHT_TWO.get(), itemEntity.getX() + (double)itemEntity.getRandom().nextInt(-3, 3) * 0.1, itemEntity.getY() + (double)itemEntity.getRandom().nextInt(0, 3) * 0.1, itemEntity.getZ() + (double)itemEntity.getRandom().nextInt(-3, 3) * 0.1, 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
                if ((Integer)itemEntity.getData(DozedAttachments.DOZED_VOIDED_LIGHT_VALUE) > 12000) {
                    itemEntity.discard();
                    ItemStack itemstack = new ItemStack((ItemLike)DozedItems.QUASAR_CORE.get());
                    if (!player.getInventory().add(itemstack)) {
                        player.drop(itemstack, false);
                    }
                }
            } else {
                itemEntity.setData(DozedAttachments.DOZED_VOIDED_LIGHT_VALUE, (Object)0);
            }
        }
    }

    @SubscribeEvent
    public static void onStarFallTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isNight()) {
            if (((Boolean)DozedConfig.SERVER.heldItemRequired.get()).booleanValue()) {
                for (ItemStack stack : player.getHandSlots()) {
                    if (!stack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)((String)DozedConfig.SERVER.heldItemString.get()))))) continue;
                    RandomSource random = player.getRandom();
                    Level level = player.level();
                    if (random.nextInt((Integer)DozedConfig.SERVER.crystalAlloyFallFrequency.get() + 1) != 1) continue;
                    FallingCrystalAlloyEntity entity = new FallingCrystalAlloyEntity((EntityType<? extends FallingCrystalAlloyEntity>)((EntityType)DozedEntityTypes.FALLING_CRYSTAL_ALLOY_ENTITY.get()), level);
                    entity.setPos(player.getX() + (double)random.nextInt(-10, 10), level.getHeight(), player.getZ() + (double)random.nextInt(-10, 10));
                    level.addFreshEntity((Entity)entity);
                }
            } else {
                RandomSource random = player.getRandom();
                Level level = player.level();
                if (random.nextInt((Integer)DozedConfig.SERVER.crystalAlloyFallFrequency.get() + 1) == 1) {
                    FallingCrystalAlloyEntity entity = new FallingCrystalAlloyEntity((EntityType<? extends FallingCrystalAlloyEntity>)((EntityType)DozedEntityTypes.FALLING_CRYSTAL_ALLOY_ENTITY.get()), level);
                    entity.setPos(player.getX() + (double)random.nextInt(-10, 10), level.getHeight(), player.getZ() + (double)random.nextInt(-10, 10));
                    level.addFreshEntity((Entity)entity);
                }
            }
        }
    }
}

